/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.CriticalSystemStateIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.license.LicenseManager;
import com.teamscale.core.log.worker.GlobalWorkerLogIndex;
import com.teamscale.core.log.worker.WorkerLogData;
import com.teamscale.core.runtime.impl.analysis.DeltaIndex;
import com.teamscale.core.runtime.impl.analysis.ETriggerExecutionResultState;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.VirtualStoreIndex;
import com.teamscale.core.runtime.impl.analysis.trigger.ETriggerType;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.scheduling.JobCompletionSupport;
import com.teamscale.core.runtime.impl.scheduling.PeriodicJobSupport;
import com.teamscale.core.runtime.impl.scheduling.ProjectDiscoveryHelper;
import com.teamscale.core.runtime.impl.scheduling.ProjectSchedulingData;
import com.teamscale.core.runtime.impl.scheduling.ProjectSchedulingFilter;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.scheduling.SchedulingData;
import com.teamscale.core.runtime.impl.worker.JobExecutionResult;
import com.teamscale.core.runtime.impl.worker.WorkerClusterStatus;
import com.teamscale.core.runtime.impl.worker.WorkerIndex;
import com.teamscale.core.runtime.impl.worker.WorkerJobExecutor;
import com.teamscale.core.runtime.impl.worker.WorkerThreadProfilingHelper;
import com.teamscale.core.shutdown.ShutdownLock;
import com.teamscale.core.shutdown.ShutdownManager;
import com.teamscale.core.shutdown.ShutdownManagerAwareThread;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import java.util.stream.Collector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.distribution.IMessageListener;
import org.conqat.engine.persistence.index.collections.DurableIdGenerator;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.concurrent.ThreadUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.lang.SilentAutoClosable;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class WorkerThread
extends ShutdownManagerAwareThread {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int WORKER_PRIORITY = 4;
    public static final boolean LOG_PERFORMANCE_DETAILS = EFeatureToggle.ENABLE_LOG_PERFORMANCE_DETAILS.isEnabled();
    private static final boolean LOG_SCHEDULER_PERFORMANCE_DETAILS = LOG_PERFORMANCE_DETAILS && EFeatureToggle.ENABLE_LOG_SCHEDULER_PERFORMANCE_DETAILS.isEnabled();
    private static final int MAX_SLEEP_TIME_MILLIS = 200;
    private static final String PROGRESS_REPORTING_PHASE_NAME = "progress reporting";
    private static final String PROJECT_DISCOVERY_PHASE_NAME = "project discovery";
    private static final String PERIODIC_JOB_SCHEDULING_PHASE_NAME = "periodic job scheduling";
    private static final String JOB_SEARCH_PHASE_NAME = "job search";
    private static final String DEAD_CONNECTOR_CHECK_PHASE = "dead connector check";
    private static final String JOB_PROGRESS_UPDATE_PHASE_NAME = "job progress update";
    private static final Set<String> ADMINISTRATIVE_PHASE_NAMES = Set.of("progress reporting", "project discovery", "periodic job scheduling", "job search", "dead connector check", "job progress update");
    private final String workerId;
    private final WorkerClusterStatus clusterStatus;
    private final WorkerClusterStatus.WorkerThreadStatus threadStatus;
    private final DurableIdGenerator idGenerator;
    private final InstanceConfiguration instanceConfiguration;
    private TemporaryDirectory tempDirectory;
    private boolean mayBeInterrupted = false;
    private final ShutdownLock shutdownLock = ShutdownManager.getInstance().obtainShutdownLock();
    private long sleepDelayMillis = 1L;
    private final IndexLayer indexLayer;
    private final WorkerIndex workerIndex;
    private final DeltaIndex deltaIndex;
    private final VirtualStoreIndex virtualStoreIndex;
    private final ProjectIndex projectIndex;
    private final ILockProvider lockProvider;
    private final SchedulingData schedulingData;
    private final WorkerThreadProfilingHelper profilingHelper;
    private final Runnable workerWakeupAction;
    private final IParallelTaskExecutor parallelTaskExecutor = new IParallelTaskExecutor(this){
        final /* synthetic */ WorkerThread this$0;
        {
            WorkerThread workerThread = this$0;
            Objects.requireNonNull(workerThread);
            this.this$0 = workerThread;
        }

        @Override
        public OptionalInt maximumParallelism() {
            return OptionalInt.of(Math.min(WorkerClusterStatus.MAX_TRIGGER_PARALLEL_THREADS + 1, this.this$0.clusterStatus.getWorkerCount()));
        }

        @Override
        public <T, R> R executeInParallelAndCombine(Collection<Callable<T>> tasks, Collector<T, ?, R> collector) throws ExecutionException, InterruptedException {
            return this.this$0.executeInParallel(tasks, collector);
        }
    };

    public WorkerThread(String workerId, WorkerClusterStatus clusterStatus, InstanceConfiguration instanceConfiguration, IndexLayer indexLayer, ILockProvider lockProvider, SchedulingData schedulingData, DurableIdGenerator idGenerator, Runnable workerWakeupAction) throws StorageException {
        this.setName("Teamscale Worker " + workerId);
        this.setDaemon(true);
        this.workerId = workerId;
        this.clusterStatus = clusterStatus;
        this.threadStatus = clusterStatus.createThreadStatus(workerId);
        this.instanceConfiguration = instanceConfiguration;
        this.indexLayer = indexLayer;
        this.workerIndex = indexLayer.openGlobalIndex(WorkerIndex.class);
        this.deltaIndex = indexLayer.openGlobalIndex(DeltaIndex.class);
        this.virtualStoreIndex = indexLayer.openGlobalIndex(VirtualStoreIndex.class);
        this.projectIndex = indexLayer.openGlobalIndex(ProjectIndex.class);
        this.lockProvider = lockProvider;
        this.schedulingData = schedulingData;
        this.idGenerator = idGenerator;
        this.workerWakeupAction = workerWakeupAction;
        this.profilingHelper = new WorkerThreadProfilingHelper(workerId, this.threadStatus, indexLayer);
        this.setPriority(4);
        try {
            this.tempDirectory = FileSystemUtils.getTemporaryDirectoryDeletedOnShutdown((String)workerId);
        }
        catch (IOException e) {
            LOGGER.fatal("Could not create temporary directory {}: {}", (Object)workerId, (Object)e.getMessage(), (Object)e);
            ShutdownManager.getInstance().shutdown();
        }
        this.registerMessageListener();
    }

    private void registerMessageListener() {
        this.indexLayer.getMessageBroker().registerListener(this.workerId, new IMessageListener(this){
            final /* synthetic */ WorkerThread this$0;
            {
                WorkerThread workerThread = this$0;
                Objects.requireNonNull(workerThread);
                this.this$0 = workerThread;
            }

            public void receive(String messageString) {
                Messages.WorkerThreadMessageBase message = 2.deserializeMessageString(messageString);
                if (message != null) {
                    this.this$0.handleMessage(message);
                }
            }

            private static Messages.WorkerThreadMessageBase deserializeMessageString(String messageString) {
                try {
                    return (Messages.WorkerThreadMessageBase)JsonUtils.deserializeFromJson((String)messageString, Messages.WorkerThreadMessageBase.class);
                }
                catch (JsonSerializationException e) {
                    LOGGER.error("Could not deserialize message: {}", (Object)messageString);
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(Messages.WorkerThreadMessageBase message) {
        if (message instanceof Messages.CancelTriggerMessage) {
            Messages.CancelTriggerMessage cancelTriggerMessage = (Messages.CancelTriggerMessage)message;
            WorkerClusterStatus.WorkerThreadStatus workerThreadStatus = this.threadStatus;
            synchronized (workerThreadStatus) {
                if (Objects.equals(cancelTriggerMessage.project, this.threadStatus.getProjectId()) && Objects.equals(cancelTriggerMessage.taskName, this.threadStatus.getTaskName()) && Objects.equals(cancelTriggerMessage.commit, this.threadStatus.getCommit())) {
                    this.threadStatus.cancelTask(cancelTriggerMessage.interrupt);
                } else {
                    LOGGER.info("Skipping cancellation of trigger {} as it is different from the current one ({}, {}, {})", (Object)cancelTriggerMessage, (Object)this.threadStatus.getProjectId(), (Object)this.threadStatus.getTaskName(), (Object)this.threadStatus.getCommit());
                }
            }
        } else {
            throw new UnsupportedOperationException("Unknown message: " + String.valueOf(message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loop() {
        this.waitForValidLicense();
        this.threadStatus.getOverallBusyTimer().beginBusyPhase();
        try {
            this.sleepDelayMillis = this.determineNewSleepDelay(this.performWork(), this.sleepDelayMillis);
        }
        catch (Throwable t) {
            this.handleOutOfMemoryErrorIfApplicable(t);
            this.handleFatalError(t);
        }
        finally {
            Thread.interrupted();
        }
        this.threadStatus.getOverallBusyTimer().beginWaitingPhase();
        WorkerThread workerThread = this;
        synchronized (workerThread) {
            this.mayBeInterrupted = true;
        }
        ThreadUtils.sleep((long)this.sleepDelayMillis);
        workerThread = this;
        synchronized (workerThread) {
            this.mayBeInterrupted = false;
        }
        Thread.interrupted();
    }

    private void handleOutOfMemoryErrorIfApplicable(Throwable t) {
        for (Throwable current = t; current != null; current = current.getCause()) {
            if (!(current instanceof OutOfMemoryError)) continue;
            try {
                this.indexLayer.openGlobalIndex(CriticalSystemStateIndex.class).setStatus(CriticalSystemStateIndex.CriticalSystemStatus.createOutOfMemoryStatus());
            }
            catch (StorageException storageException) {
                LOGGER.error("Error writing critical system state: {}", (Object)storageException.getMessage(), (Object)storageException);
            }
            return;
        }
    }

    private void handleFatalError(Throwable t) {
        String message = "Fatal error in worker thread: " + t.getMessage();
        LOGGER.error(message, t);
        this.logFatalErrorInWorkerLog(message, t);
    }

    private void logFatalErrorInWorkerLog(String message, Throwable t) {
        try {
            GlobalWorkerLogIndex workerLogIndex = this.indexLayer.openGlobalIndex(GlobalWorkerLogIndex.class);
            long time = System.currentTimeMillis();
            String messageWithStacktrace = message + "\n" + StringUtils.obtainStackTrace((Throwable)t);
            LoggingEventTransport loggingEvent = new LoggingEventTransport(messageWithStacktrace, ELogLevel.FATAL, time, this.getName(), Collections.emptyMap());
            CommitDescriptor commit = CommitDescriptor.createUnbranchedDescriptor((long)1L);
            JobDescriptor job = JobDescriptor.forMaintenanceProject().withTrigger(ETriggerType.PRIVILEGED, this.getClass().getName()).withSchedulingReason("perform work").withRollbackRelevant(false).withCancelable(false).build();
            WorkerLogData workerLogData = WorkerLogData.create(this.workerId, time, job, job.getInternalProjectId(), commit, Collections.singletonList(loggingEvent), Collections.emptyList(), ETriggerExecutionResultState.FAILED_BADLY);
            workerLogIndex.insertWorkerLog(workerLogData);
        }
        catch (StorageException e) {
            LOGGER.error("Error writing worker log: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @VisibleForTesting
    protected long determineNewSleepDelay(boolean hadWork, long currentSleepDelay) {
        if (hadWork) {
            return 0L;
        }
        return Math.min(200L, 2L * Math.max(5L, currentSleepDelay));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptIfPossible() {
        WorkerThread workerThread = this;
        synchronized (workerThread) {
            if (this.mayBeInterrupted) {
                this.interrupt();
            }
        }
    }

    private boolean performWork() {
        boolean hadWork = false;
        this.threadStatus.getSchedulingTimer().beginBusyPhase();
        if (this.schedulingData.isProjectDiscoveryNeeded()) {
            this.runProjectDiscovery();
            hadWork = true;
        }
        if (this.runPeriodicJobScheduling()) {
            hadWork = true;
        }
        if (this.schedulingData.isDeadConnectorCheckNeeded() && this.runDeadConnectorCheck()) {
            hadWork = true;
        }
        this.threadStatus.getSchedulingTimer().beginWaitingPhase();
        while (this.supportParallelExecutionOfOtherJob(false)) {
            hadWork = true;
        }
        this.threadStatus.getSchedulingTimer().beginBusyPhase();
        Optional<ScheduledJob> extractedJob = this.findNextJob();
        this.threadStatus.getSchedulingTimer().beginWaitingPhase();
        if (extractedJob.isPresent()) {
            ScheduledJob job = extractedJob.get();
            hadWork = true;
            this.processJob(job);
            this.workerWakeupAction.run();
        }
        if (!hadWork) {
            hadWork = this.supportParallelExecutionOfOtherJob(true);
        }
        return hadWork;
    }

    private void runProjectDiscovery() {
        this.profilingHelper.startPhase(PROJECT_DISCOVERY_PHASE_NAME, null);
        try {
            new ProjectDiscoveryHelper(this.projectIndex, this.schedulingData, this.lockProvider).runProjectDiscovery();
        }
        catch (TriggerCompilationException | StorageException e) {
            this.profilingHelper.reportError(e);
        }
        this.profilingHelper.endPhase(LOG_SCHEDULER_PERFORMANCE_DETAILS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runPeriodicJobScheduling() {
        Lock lock = this.clusterStatus.getPeriodicJobSchedulingLock();
        if (!lock.tryLock()) {
            return false;
        }
        try {
            List<Integer> periodicSchedulingTicks = this.schedulingData.getPeriodicSchedulingData().getPeriodicSchedulingTicks();
            for (int tick : periodicSchedulingTicks) {
                this.runPeriodicJobScheduling(tick);
            }
            boolean bl = !periodicSchedulingTicks.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private void runPeriodicJobScheduling(int tick) {
        this.profilingHelper.startPhase(PERIODIC_JOB_SCHEDULING_PHASE_NAME, null);
        this.schedulingData.runOnAllProjects(projectData -> projectData.runWithPeriodicJobSupport(periodicJobSupport -> {
            try {
                periodicJobSupport.schedulePeriodicJobs(tick, false);
            }
            catch (StorageException e) {
                this.profilingHelper.setProjectId(this.resolveToPublicId(projectData.getInternalProjectId()));
                this.profilingHelper.reportError(e);
            }
        }));
        this.workerWakeupAction.run();
        this.profilingHelper.endPhase(LOG_SCHEDULER_PERFORMANCE_DETAILS);
    }

    private PublicProjectId resolveToPublicId(InternalProjectId internalProjectId) {
        try {
            return this.indexLayer.resolveToPrimaryPublicProjectId((IProjectId)internalProjectId);
        }
        catch (StorageException e) {
            return new PublicProjectId(internalProjectId.toString());
        }
    }

    private boolean runDeadConnectorCheck() {
        Lock lock = this.clusterStatus.getDeadConnectorCheckLock();
        if (!lock.tryLock()) {
            return false;
        }
        try {
            this.profilingHelper.startPhase(DEAD_CONNECTOR_CHECK_PHASE, null);
            this.schedulingData.runOnAllProjects(projectData -> {
                try {
                    projectData.runDeadConnectorCheck();
                }
                catch (StorageException e) {
                    this.profilingHelper.setProjectId(this.resolveToPublicId(projectData.getInternalProjectId()));
                    this.profilingHelper.reportError(e);
                }
            });
            this.schedulingData.updateLastDeadConnectorCheckTimesteamp();
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
            this.profilingHelper.endPhase(LOG_SCHEDULER_PERFORMANCE_DETAILS);
        }
    }

    private boolean supportParallelExecutionOfOtherJob(boolean forceSingleExecution) {
        Optional<Pair<WorkerClusterStatus.WorkerThreadStatus, Runnable>> threadAndTask = this.clusterStatus.findWorkerInNeedOfExecutionSupport(forceSingleExecution);
        if (threadAndTask.isEmpty()) {
            return false;
        }
        WorkerClusterStatus.WorkerThreadStatus supportedThread = (WorkerClusterStatus.WorkerThreadStatus)threadAndTask.get().getFirst();
        supportedThread.getSupportingWorkers().incrementAndGet();
        this.threadStatus.setSupportedWorker(supportedThread.getWorkerId());
        WorkerJobExecutor currentExecutor = supportedThread.getCurrentExecutor();
        CCSMAssert.isNotNull((Object)currentExecutor, () -> "CurrentExecutor should never be 'null' here.");
        ScheduledJob scheduledJob = supportedThread.getScheduledJob();
        CCSMAssert.isNotNull((Object)scheduledJob, () -> "ScheduledJob should never be 'null' here.");
        try (SilentAutoClosable ignoredCleanup = currentExecutor.registerParallelExecution(this.workerId, scheduledJob);){
            ((Runnable)threadAndTask.get().getSecond()).run();
            if (!forceSingleExecution) {
                supportedThread.participateInTaskExecution();
            }
        }
        supportedThread.getSupportingWorkers().decrementAndGet();
        this.threadStatus.clear();
        return true;
    }

    private Optional<ScheduledJob> findNextJob() {
        ProjectSchedulingFilter filter;
        this.profilingHelper.startPhase(JOB_SEARCH_PHASE_NAME, null);
        try {
            filter = this.workerIndex.getSchedulingFilterAccess().get();
        }
        catch (StorageException e) {
            this.profilingHelper.reportError(e);
            return Optional.empty();
        }
        AtomicReference foundJob = new AtomicReference();
        int maxAttempts = this.schedulingData.getProjectCount() + 1;
        for (int i = 0; i < maxAttempts && foundJob.get() == null; ++i) {
            Optional<ProjectSchedulingData> projectSchedulingData = this.schedulingData.getNextUnlockedProject(filter, i == 0);
            projectSchedulingData.ifPresent(data -> data.runWithSchedulingHelper(schedulingHelper -> {
                try {
                    schedulingHelper.extractAndAssignNextJob().ifPresent(foundJob::set);
                }
                catch (TriggerCompilationException | StorageException e) {
                    this.profilingHelper.setProjectId(this.resolveToPublicId(schedulingHelper.getInternalProjectId()));
                    this.profilingHelper.reportError(e);
                }
            }));
        }
        this.profilingHelper.endPhase(LOG_SCHEDULER_PERFORMANCE_DETAILS);
        return Optional.ofNullable((ScheduledJob)foundJob.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJob(ScheduledJob scheduledJob) {
        PublicProjectId publicProjectId = this.resolveToPublicId(scheduledJob.getProjectId());
        this.profilingHelper.startPhase("job execution", publicProjectId);
        this.threadStatus.startTask(publicProjectId, scheduledJob.getTriggerName(), scheduledJob.getSchedulingCommitDescriptor(), scheduledJob.getJob().isCancelable());
        try {
            this.processJobWithoutErrorHandling(scheduledJob);
        }
        catch (TriggerCompilationException | StorageException e) {
            this.profilingHelper.reportError(e);
        }
        finally {
            if (this.shutdownLock.isInNoShutdownRegion()) {
                this.shutdownLock.exitNoShutdownRegion();
            }
            this.profilingHelper.endPhase(false);
        }
    }

    private void processJobWithoutErrorHandling(ScheduledJob scheduledJob) throws StorageException, TriggerCompilationException {
        JobExecutionResult executionResult = this.executeJob(scheduledJob);
        if (executionResult.isDeleted()) {
            this.schedulingData.invalidateProject(scheduledJob.getProjectId());
            return;
        }
        ProjectSchedulingData projectSchedulingData = this.schedulingData.getOrCreateProjectSchedulingData(scheduledJob.getProjectId());
        projectSchedulingData.runWithPeriodicJobSupport(periodicJobSupport -> {
            try {
                JobCompletionSupport jobCompletionSupport = new JobCompletionSupport(scheduledJob.getProjectId(), this.deltaIndex, this.virtualStoreIndex, (PeriodicJobSupport)periodicJobSupport, this.indexLayer, projectSchedulingData.getProgressPublisher());
                jobCompletionSupport.completeJob(executionResult, this::handleFatalError);
            }
            catch (TriggerCompilationException | StorageException e) {
                LOGGER.error("Critical error while persisting results for job {}: {}", (Object)scheduledJob.getJob(), (Object)e.getMessage(), (Object)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected JobExecutionResult executeJob(ScheduledJob scheduledJob) throws StorageException, TriggerCompilationException {
        WorkerJobExecutor workerJobExecutor = this.getWorkerJobExecutor(scheduledJob);
        this.threadStatus.setCurrentExecutorAndJob(workerJobExecutor, scheduledJob);
        try {
            JobExecutionResult jobExecutionResult = workerJobExecutor.executeJob(scheduledJob);
            return jobExecutionResult;
        }
        finally {
            this.threadStatus.resetCurrentExecutorAndJob();
        }
    }

    private @NonNull WorkerJobExecutor getWorkerJobExecutor(ScheduledJob scheduledJob) throws StorageException, TriggerCompilationException {
        return new WorkerJobExecutor(this.workerId, this.instanceConfiguration, this.indexLayer, this.resolveToPublicId(scheduledJob.getProjectId()), this.deltaIndex, this.virtualStoreIndex, this.projectIndex, this.schedulingData.getOrCreateProjectSchedulingData(scheduledJob.getProjectId()).getTriggerCache(), this.lockProvider, this.tempDirectory, this.shutdownLock, this.idGenerator, this.parallelTaskExecutor);
    }

    private <R, T> R executeInParallel(Collection<Callable<T>> tasks, Collector<T, ?, R> collector) throws ExecutionException {
        if (tasks.size() <= 1) {
            return WorkerThread.executeSequentially(tasks, collector);
        }
        List<FutureTask> futures = tasks.stream().map(FutureTask::new).toList();
        this.threadStatus.offerParallelTasks(futures.subList(0, futures.size() - 1));
        ((FutureTask)CollectionUtils.getLast(futures)).run();
        this.threadStatus.participateInTaskExecution();
        return WorkerThread.waitForExecutionOfTasks(futures, collector);
    }

    private static <R, T, A> R executeSequentially(Collection<Callable<T>> tasks, Collector<T, A, R> collector) throws ExecutionException {
        A resultContainer = collector.supplier().get();
        BiConsumer<A, A> accumulator = collector.accumulator();
        try {
            for (Callable<T> task : tasks) {
                accumulator.accept(resultContainer, task.call());
            }
            return collector.finisher().apply(resultContainer);
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    private static <T, A, R> R waitForExecutionOfTasks(List<? extends Future<T>> futures, Collector<T, A, R> collector) throws ExecutionException {
        ArrayList<Throwable> allExceptions = new ArrayList<Throwable>();
        A intermediate = collector.supplier().get();
        BiConsumer<A, A> accumulator = collector.accumulator();
        for (Future<T> future : futures) {
            try {
                accumulator.accept(intermediate, future.get());
            }
            catch (InterruptedException e) {
                allExceptions.add(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    allExceptions.add(e.getCause());
                    continue;
                }
                allExceptions.add(e);
            }
        }
        WorkerThread.reportAndThrow(allExceptions);
        return collector.finisher().apply(intermediate);
    }

    private static void reportAndThrow(List<Throwable> allExceptions) throws ExecutionException {
        if (allExceptions.size() == 1) {
            Throwable throwable = allExceptions.get(0);
            if (throwable instanceof ExecutionException) {
                ExecutionException executionException = (ExecutionException)throwable;
                throw executionException;
            }
            throw new ExecutionException(throwable);
        }
        if (!allExceptions.isEmpty()) {
            allExceptions.forEach(exception -> LOGGER.error(exception.getMessage(), exception));
            throw new ExecutionException(new RuntimeException("Encountered multiple exceptions during concurrent execution! See log for details."));
        }
    }

    private void waitForValidLicense() {
        boolean loggedMissingLicense = false;
        LicenseManager licenseManager = LicenseManager.getInstance();
        while (licenseManager.getLicense() == null || licenseManager.getLicense().getExpired()) {
            this.threadStatus.startTask(null, "Waiting for valid license", null, false);
            if (!loggedMissingLicense) {
                LOGGER.error("No valid license. No analyses will be executed anymore.");
                loggedMissingLicense = true;
            }
            ThreadUtils.sleep((long)Duration.ofSeconds(10L).toMillis());
        }
    }

    public static boolean isAdministrativePhaseName(String phaseName) {
        return ADMINISTRATIVE_PHASE_NAMES.contains(phaseName);
    }

    public static class Messages {

        public static final class CancelTriggerMessage
        extends WorkerThreadMessageBase {
            @JsonProperty(value="project")
            private final PublicProjectId project;
            @JsonProperty(value="taskName")
            private final String taskName;
            @JsonProperty(value="commit")
            private final @Nullable CommitDescriptor commit;
            @JsonProperty(value="interrupt")
            private final boolean interrupt;

            @JsonCreator
            public CancelTriggerMessage(@JsonProperty(value="project") PublicProjectId project, @JsonProperty(value="taskName") String taskName, @JsonProperty(value="commit") @Nullable CommitDescriptor commit, @JsonProperty(value="interrupt") boolean interrupt) {
                this.project = project;
                this.taskName = taskName;
                this.commit = commit;
                this.interrupt = interrupt;
            }
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="type")
        private static abstract class WorkerThreadMessageBase {
            private WorkerThreadMessageBase() {
            }

            public String toString() {
                return JsonUtils.serializeToJSON((Object)this);
            }
        }
    }
}

