/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.prometheus.metrics.core.metrics.Gauge;
import io.prometheus.metrics.core.metrics.Summary;
import io.prometheus.metrics.model.snapshots.Unit;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@Index(name="user-satisfaction-feedback", options={EStorageOption.BACKUP, EStorageOption.COMPRESSED})
public class UserSatisfactionFeedbackIndex
implements IGlobalIndex {
    private static final Summary PROMETHEUS_USER_SATISFACTION_SUMMARY = (Summary)((Summary.Builder)((Summary.Builder)Summary.builder().name("user_satisfaction_score")).help("The user satisfaction feedback score.")).quantile(0.5, 0.01).quantile(0.2, 0.01).quantile(0.05, 0.01).register();
    private static final Gauge PROMETHEUS_LAST_USER_FEEDBACK_TIMESTAMP_GAUGE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("user_satisfaction_last_feedback_received_timestamp_seconds")).help("The timestamp in seconds when the last user satisfaction feedback was submitted by a user.")).unit(Unit.SECONDS)).register();
    private final ValueIndex<ArrayList<UserSatisfactionFeedback>> delegate;

    public UserSatisfactionFeedbackIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public PairList<String, ArrayList<UserSatisfactionFeedback>> getAllUserSatisfactionEntries() throws StorageException {
        return this.delegate.getAllEntries();
    }

    public void addUserSatisfactionFeedback(String username, UserSatisfactionFeedback userSatisfactionFeedback) throws StorageException {
        PROMETHEUS_USER_SATISFACTION_SUMMARY.observe((double)userSatisfactionFeedback.rating);
        PROMETHEUS_LAST_USER_FEEDBACK_TIMESTAMP_GAUGE.set(Unit.millisToSeconds((long)System.currentTimeMillis()));
        ArrayList existingRecords = (ArrayList)this.delegate.getValue(username);
        ArrayList<UserSatisfactionFeedback> newRecords = new ArrayList<UserSatisfactionFeedback>();
        if (existingRecords != null) {
            newRecords.addAll(existingRecords);
        }
        newRecords.add(userSatisfactionFeedback);
        this.delegate.setValue(username, newRecords);
    }

    @IndexValueClass(containedInBackup=true)
    public record UserSatisfactionFeedback(@JsonProperty(value="date") @Nullable LocalDate date, @JsonProperty(value="rating") int rating, @JsonProperty(value="feedback") String feedback, @JsonProperty(value="mayBeContacted") boolean mayBeContacted) implements Serializable
    {
        public UserSatisfactionFeedback withDate(LocalDate date) {
            return new UserSatisfactionFeedback(date, this.rating, this.feedback, this.mayBeContacted);
        }
    }
}

