/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.utils;

import com.teamscale.core.utils.XXHashUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class FileWatcher
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Duration DEFAULT_CHECK_INTERVAL = Duration.ofSeconds(10L);
    private static final Duration DEFAULT_FULL_CHECK_INTERVAL = Duration.ofMinutes(1L);
    private final Path path;
    private final Consumer<String> changeAction;
    private @Nullable FileTime lastModificationTime;
    private @Nullable Long lastContentHash;
    private final Timer timer = new Timer(this.getClass().getSimpleName(), true);

    public FileWatcher(Path path, Consumer<String> changeAction) {
        this(path, changeAction, DEFAULT_CHECK_INTERVAL, DEFAULT_FULL_CHECK_INTERVAL);
    }

    public FileWatcher(Path path, Consumer<String> changeAction, Duration checkInterval, Duration fullCheckInterval) {
        this.path = path;
        this.changeAction = changeAction;
        this.timer.schedule(new TimerTask(this){
            final /* synthetic */ FileWatcher this$0;
            {
                FileWatcher fileWatcher = this$0;
                Objects.requireNonNull(fileWatcher);
                this.this$0 = fileWatcher;
            }

            @Override
            public void run() {
                this.this$0.checkForModification(false);
            }
        }, 0L, checkInterval.toMillis());
        this.timer.schedule(new TimerTask(this){
            final /* synthetic */ FileWatcher this$0;
            {
                FileWatcher fileWatcher = this$0;
                Objects.requireNonNull(fileWatcher);
                this.this$0 = fileWatcher;
            }

            @Override
            public void run() {
                this.this$0.checkForModification(true);
            }
        }, fullCheckInterval.toMillis(), fullCheckInterval.toMillis());
    }

    private synchronized void checkForModification(boolean checkContent) {
        if (!Files.isRegularFile(this.path, new LinkOption[0]) || !Files.isReadable(this.path)) {
            if (this.lastContentHash != null) {
                this.changeAction.accept(null);
            }
            this.lastContentHash = null;
            this.lastModificationTime = null;
            return;
        }
        try {
            FileTime modificationTime = Files.getLastModifiedTime(this.path, new LinkOption[0]);
            if (checkContent || this.lastModificationTime == null || modificationTime.toInstant().isAfter(this.lastModificationTime.toInstant())) {
                String content = Files.readString(this.path);
                long contentHash = XXHashUtils.xxhash64(content);
                this.lastModificationTime = modificationTime;
                if (this.lastContentHash == null || contentHash != this.lastContentHash) {
                    this.lastContentHash = contentHash;
                    this.changeAction.accept(content);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to access " + String.valueOf(this.path) + ": " + e.getMessage());
        }
    }

    @Override
    public void close() {
        this.timer.cancel();
    }
}

