/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.abap.CallStatementCheckBase;
import eu.cqse.check.abap.MissingCheckOfSySubrcCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.util.CheckUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.abap.FunctionCallInfo;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-missing-authority-check-for-call-transaction", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MissingAuthorityCheckForCallTransactionCheck
extends CallStatementCheckBase {
    static final String AUTHORITY_CHECK_TCODE = "AUTHORITY_CHECK_TCODE";
    private static final String CHECK_NAME = "Missing authority check at CALL TRANSACTION";
    @CheckOption(name="Missing authority check at CALL TRANSACTION - Non-critical transactions", description="Comma separated list of transaction codes(regular expressions) which are non-critical and thus not require an authority-check.")
    private Set<String> nonCriticalTransactions = Collections.emptySet();

    @Override
    protected boolean isTargetedCallStatement(ETokenType typeOfsecondToken) {
        return typeOfsecondToken == ETokenType.TRANSACTION;
    }

    @Override
    protected void processCallStatement() throws CheckException {
        if (this.hasWithAuthorityCheckAddition()) {
            return;
        }
        this.checkAuthorityCheckBeforeAndCreateFindings();
    }

    private boolean hasWithAuthorityCheckAddition() {
        return TokenStreamUtils.firstTokenOfTypeSequence(this.getCallStatmentTokens(), (int)0, (ETokenType[])new ETokenType[]{ETokenType.WITH, ETokenType.AUTHORITY_CHECK}) != -1;
    }

    private void checkAuthorityCheckBeforeAndCreateFindings() throws CheckException {
        IToken calledTransaction = (IToken)this.getCallStatmentTokens().get(2);
        if (this.isNoncriticalTransaction(calledTransaction)) {
            return;
        }
        ShallowEntity expectedAuthorityCheck = this.findStatementWhichShouldBeAuthorityCheck();
        if (this.isAuthorityCheck(expectedAuthorityCheck, calledTransaction)) {
            return;
        }
        this.buildFinding("Missing authority check before CALL TRANSACTION", this.buildLocation().forEntity(this.getCallStatement())).createAndStore();
    }

    private boolean isNoncriticalTransaction(IToken calledTransaction) {
        String transactionCode = CheckUtils.getUnquotedTextForCharacterLiteral((IToken)calledTransaction);
        if (transactionCode == null) {
            return false;
        }
        return this.nonCriticalTransactions.stream().anyMatch(transactionCode::matches);
    }

    private boolean isAuthorityCheck(ShallowEntity entity, IToken calledTransaction) throws CheckException {
        if (entity == null) {
            return false;
        }
        Optional functionCallInfo = LanguageFeatureParser.ABAP.getFunctionCallInfo(entity);
        if (functionCallInfo.isEmpty()) {
            return false;
        }
        if (!AUTHORITY_CHECK_TCODE.equals(((FunctionCallInfo)functionCallInfo.get()).getFunctionName())) {
            return false;
        }
        this.createFindingsInCaseOfIneffectiveAuthorityCheck(entity, calledTransaction, (FunctionCallInfo)functionCallInfo.get());
        return true;
    }

    private void createFindingsInCaseOfIneffectiveAuthorityCheck(ShallowEntity entity, IToken calledTransaction, FunctionCallInfo authorityCheckCallInfo) throws CheckException {
        Optional authorizedTransaction = authorityCheckCallInfo.getPassedExportingToken("tcode");
        if (authorizedTransaction.isEmpty()) {
            this.buildFinding("No transaction code passed to authority check before CALL TRANSACTION", this.buildLocation().forEntity(entity)).createAndStore();
        } else if (!TokenUtils.isEqualTypeAndText((IToken)((IToken)authorizedTransaction.get()), (IToken)calledTransaction)) {
            this.buildFinding("Ineffective authority check before CALL TRANSACTION: Checks for transaction code " + MarkupUtils.escapeMarkdownRelevantSymbols((String)((IToken)authorizedTransaction.get()).getText()) + " but called is " + MarkupUtils.escapeMarkdownRelevantSymbols((String)calledTransaction.getText()), this.buildLocation().forToken((IToken)authorizedTransaction.get())).createAndStore();
        }
        if (!authorityCheckCallInfo.isSettingErrorCodeForException("not_ok")) {
            this.buildFinding("Ineffective authority check before CALL TRANSACTION: No error code set for exception 'not_ok'", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }

    private ShallowEntity findStatementWhichShouldBeAuthorityCheck() throws CheckException {
        ShallowEntity ifStatement;
        ShallowEntity parent = this.getCallStatement().getParent();
        if (MissingCheckOfSySubrcCheckBase.isConditionalOnSySubrc(parent) && MissingAuthorityCheckForCallTransactionCheck.isFirstChildStatement(this.getCallStatement())) {
            return MissingAuthorityCheckForCallTransactionCheck.getPrecedingStatement(parent);
        }
        if (parent.getType() == EShallowEntityType.STATEMENT && "else".equals(parent.getSubtype()) && MissingAuthorityCheckForCallTransactionCheck.isFirstChildStatement(this.getCallStatement()) && MissingCheckOfSySubrcCheckBase.isConditionalOnSySubrc(ifStatement = this.findSiblingIfForElse(parent))) {
            return MissingAuthorityCheckForCallTransactionCheck.getPrecedingStatement(ifStatement);
        }
        ShallowEntity precedingEntity = MissingAuthorityCheckForCallTransactionCheck.getPrecedingStatement(this.getCallStatement());
        if (MissingCheckOfSySubrcCheckBase.isConditionalOnSySubrc(precedingEntity)) {
            precedingEntity = MissingAuthorityCheckForCallTransactionCheck.getPrecedingStatement(precedingEntity);
        }
        return precedingEntity;
    }

    private ShallowEntity findSiblingIfForElse(ShallowEntity entity) throws CheckException {
        List ifSiblings = MissingAuthorityCheckForCallTransactionCheck.select((ShallowEntity)entity, (String)"preceding-sibling::STATEMENT[subtype('if')]");
        if (!ifSiblings.isEmpty()) {
            return (ShallowEntity)ifSiblings.getLast();
        }
        return null;
    }

    private static boolean isFirstChildStatement(ShallowEntity entity) {
        if (entity.getParent() == null) {
            return false;
        }
        List<ShallowEntity> children = entity.getParent().getChildrenOfType(EShallowEntityType.STATEMENT).stream().filter(childEntity -> !Objects.equals(childEntity.getSubtype(), "data")).toList();
        if (children.isEmpty()) {
            return false;
        }
        return entity.equals(children.getFirst());
    }

    private static ShallowEntity getPrecedingStatement(ShallowEntity entity) {
        List siblings = entity.getParent().getChildrenOfType(EShallowEntityType.STATEMENT);
        int entityIndex = siblings.indexOf(entity);
        if (entityIndex > 0) {
            return (ShallowEntity)siblings.get(entityIndex - 1);
        }
        return null;
    }
}

