/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.abap.AbapCheckUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-no-data-declaration-in-statement-block", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoDataDeclarationInStatementBlockCheck
extends CheckImplementationBase {
    protected static final String FINDING_MESSAGE = "No data declarations in statement blocks";
    private static final Set<String> DATA_DECLARATION_SUBTYPES = CollectionUtils.asHashSet((Object[])new String[]{"class-data", "constants", "data", "field-groups", "field-symbols", "parameters", "ranges", "select-options", "statics", "types"});

    public void execute() throws CheckException {
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE), DATA_DECLARATION_SUBTYPES);
        for (ShallowEntity selectedEntity : selectedEntities) {
            this.processEntity(selectedEntity);
        }
    }

    private void processEntity(ShallowEntity dataDeclarationEntity) throws CheckException {
        boolean isGlobalScope = AbapCheckUtils.isEntityWithinGlobalScope((ShallowEntity)dataDeclarationEntity);
        boolean isFunctionalScope = AbapCheckUtils.isEntityWithinLocalValidScope((ShallowEntity)dataDeclarationEntity);
        boolean isClassScope = AbapCheckUtils.isEntityWithinClassScope((ShallowEntity)dataDeclarationEntity);
        boolean isInStatementBlock = !isGlobalScope && !isFunctionalScope && !isClassScope;
        boolean isInlineDeclaration = AbapCheckUtils.isInlineDataDeclaration((ShallowEntity)dataDeclarationEntity);
        if (isInStatementBlock && !isInlineDeclaration) {
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forEntity(dataDeclarationEntity)).createAndStore();
        }
    }
}

