/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap_cds;

import eu.cqse.check.abap_cds.AbapCdsCheckUtils;
import eu.cqse.check.abap_cds.AccessControlPhase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;

@Check(id="cqse-access-control-authorization-check", languages={ELanguage.ABAP, ELanguage.ABAP_CDS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, phases={AccessControlPhase.class})
public class AccessControlAuthorizationCheck
extends CheckImplementationBase {
    private static final String CHECK_VALUE = "#CHECK";
    private static final String MANDATORY_VALUE = "#MANDATORY";
    private static final Set<String> UNNECESSARY_ACCESS_CONTROL_VALUE = Set.of("#NOT_REQUIRED", "#NOT_ALLOWED");
    private static final String ANNOTATION_NAME = "accesscontrol.authorizationcheck";
    public static final String SUPPRESS_FINDINGS_OPTION_NAME = "Access control authorization - suppress findings";
    @CheckOption(name="Access control authorization - suppress findings", description="Suppresses findings for#NOT_ALLOWED and #NOT_REQUIRED annotation values, except a corresponding DCL role exists.")
    private boolean suppressFindings = false;
    public static final String REQUIRE_MANDATORY_OPTION_NAME = "Access control authorization - require MANDATORY";
    @CheckOption(name="Access control authorization - require MANDATORY", description="When enabled, only #MANDATORY is accepted as authorization check value. Views using #CHECK will produce findings.")
    private boolean requireMandatory = false;

    public void execute() throws CheckException {
        if (!AbapCdsCheckUtils.isAbapCdsViewDefinition((ITokenElementContext)this.context)) {
            return;
        }
        List<AnnotatedView> allViews = AccessControlAuthorizationCheck.getViews(this.context.getAbstractSyntaxTree(this.getCodeViewOption()));
        for (AnnotatedView view : allViews) {
            this.checkViewForFinding(view.viewEntity(), view.accessControlAnnotationEntity());
        }
    }

    private void checkViewForFinding(ShallowEntity entity, ShallowEntity viewAnnotation) {
        String annotationValue = AccessControlAuthorizationCheck.determineAnnotationValue(viewAnnotation);
        boolean isUsed = this.viewGetsUsed(entity);
        if (annotationValue == null) {
            if (isUsed) {
                this.buildFinding("View is used but does not declare an authorization check.", this.buildLocation().forEntity(entity)).createAndStore();
            } else {
                this.buildFinding("View does not have an authorization check annotation.", this.buildLocation().forEntity(entity)).createAndStore();
            }
        } else if (CHECK_VALUE.equals(annotationValue) || MANDATORY_VALUE.equals(annotationValue)) {
            if (!isUsed) {
                this.buildFinding("View declares an authorization check, but is not used.", this.buildLocation().forEntity(entity)).createAndStore();
            } else if (this.requireMandatory && CHECK_VALUE.equals(annotationValue)) {
                this.buildFinding("View uses #CHECK, but #MANDATORY is required.", this.buildLocation().forEntity(entity)).createAndStore();
            }
        } else if (UNNECESSARY_ACCESS_CONTROL_VALUE.contains(annotationValue) && (!this.suppressFindings || isUsed)) {
            this.buildFinding("View is used but does not declare an authorization check.", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }

    private boolean viewGetsUsed(ShallowEntity entity) {
        if (entity.getName() == null) {
            return false;
        }
        List usingObjects = (List)this.context.accessPhaseInvertedResult(AccessControlPhase.class).apply(entity.getName());
        return !usingObjects.isEmpty();
    }

    private static String determineAnnotationValue(ShallowEntity entity) {
        if (entity == null || entity.ownStartTokens().size() <= 5) {
            return null;
        }
        String annotationParameter = ((IToken)entity.ownStartTokens().get(5)).getText();
        if (CHECK_VALUE.equals(annotationParameter) || MANDATORY_VALUE.equals(annotationParameter)) {
            return annotationParameter;
        }
        if (UNNECESSARY_ACCESS_CONTROL_VALUE.contains(annotationParameter)) {
            return annotationParameter;
        }
        return null;
    }

    private static List<AnnotatedView> getViews(List<ShallowEntity> entities) {
        List allAnnotationsAndViews = ShallowEntityTraversalUtils.selectEntities(entities, entity -> EnumSet.of(EShallowEntityType.METHOD, EShallowEntityType.META).contains(entity.getType()) && Set.of("View Definition", "View Entity Definition", "Annotation with value").contains(entity.getSubtype()));
        ShallowEntity lastAnnotation = null;
        ArrayList<AnnotatedView> annotatedViews = new ArrayList<AnnotatedView>();
        for (ShallowEntity entity2 : allAnnotationsAndViews) {
            if (entity2.getType() == EShallowEntityType.METHOD) {
                annotatedViews.add(new AnnotatedView(lastAnnotation, entity2));
                lastAnnotation = null;
                continue;
            }
            if (!Objects.equals(entity2.getName(), ANNOTATION_NAME)) continue;
            lastAnnotation = entity2;
        }
        return annotatedViews;
    }

    private record AnnotatedView(@Nullable ShallowEntity accessControlAnnotationEntity, ShallowEntity viewEntity) {
    }
}

