/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-method-name-and-field-name-equals", languages={ELanguage.CS, ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MethodNameAndFieldNameEqualsCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "The name %s is used as method name and field name";

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity entity) {
        Map<String, List<ShallowEntity>> methodEntitiesByName = entity.getChildrenOfType(EShallowEntityType.METHOD).stream().filter(child -> child.getName() != null).collect(Collectors.groupingBy(ShallowEntity::getName));
        Map<String, List<ShallowEntity>> attributeEntitiesByName = entity.getChildrenOfType(EShallowEntityType.ATTRIBUTE).stream().filter(child -> child.getName() != null).collect(Collectors.groupingBy(ShallowEntity::getName));
        HashSet equalNames = CollectionUtils.intersectionSet(methodEntitiesByName.keySet(), (Collection[])new Collection[]{attributeEntitiesByName.keySet()});
        for (String equalName : equalNames) {
            this.buildFinding(String.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)equalName)), this.buildLocation().forEntity(attributeEntitiesByName.get(equalName).get(0))).createAndStore();
        }
    }
}

