/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-cpp-no-if-zero-or-false-pre-dir", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CppNoIfZeroOrFalsePreDirCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        UnmodifiableList tokens = this.context.getTokens(ECodeViewOption.FILTERED);
        for (IToken token : tokens) {
            if (!CppNoIfZeroOrFalsePreDirCheck.isPreprocessorDefinition(token)) continue;
            boolean isIfFalse = token.getText().replaceAll("\\s+", " ").equals("#ifdef false");
            boolean isIfZero = token.getText().replaceAll("\\s+", " ").equals("#ifdef 0");
            if (token.getType() != ETokenType.PREPROCESSOR_DIRECTIVE || !isIfFalse && !isIfZero) continue;
            this.buildFinding("The conditional expression of preprocessor directive #ifdef (0 or false) should be avoided", this.buildLocation().forToken(token)).createAndStore();
        }
    }

    private static boolean isPreprocessorDefinition(IToken token) {
        return token.getText().startsWith("#ifdef");
    }
}

