/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.cpp.CppCheckUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-missing-header-protection", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C})
public class MissingHeaderProtectionCheck
extends CheckImplementationBase {
    private static final Pattern PRAGMA_ONCE_PATTERN = Pattern.compile("\\s*#\\s*pragma\\s+once\\s*");
    @CheckOption(name="Header extensions", description="File extensions that are used to identify header files.")
    private Set<String> headerExtensions = new HashSet<String>(CppCheckUtils.HEADER_EXTENSIONS);

    public void execute() throws CheckException {
        String extension = StringUtils.getLastPart((String)this.context.getUniformPath(), (char)'.');
        if (extension == null || !this.headerExtensions.isEmpty() && !this.headerExtensions.contains(extension.toLowerCase())) {
            return;
        }
        List tokens = ScannerUtils.getTokens((String)this.context.getTextContent(ECodeViewOption.ETextViewOption.UNFILTERED_CONTENT), (ELanguage)this.context.getLanguage(), (String)this.context.getUniformPath());
        if (tokens.stream().anyMatch(token -> token.getType() == ETokenType.PRAGMA_DIRECTIVE && PRAGMA_ONCE_PATTERN.matcher(token.getText()).matches())) {
            return;
        }
        Predicate<IToken> isRelevantToken = token -> token.getType().getTokenClass() != ETokenType.ETokenClass.COMMENT;
        List relevantIndices = TokenStreamUtils.indicesOfByPredicate((List)tokens, isRelevantToken);
        if (relevantIndices.size() < 3) {
            this.createHeaderProtectFinding();
            return;
        }
        String checkedConstant = MissingHeaderProtectionCheck.checkAndExtractIfndef((IToken)tokens.get((Integer)relevantIndices.get(0)));
        String definedConstant = MissingHeaderProtectionCheck.extractDefineConstant((IToken)tokens.get((Integer)relevantIndices.get(1)));
        if (checkedConstant == null || definedConstant == null || !MissingHeaderProtectionCheck.checkClosingEndIf((IToken)tokens.get((Integer)CollectionUtils.getLast((List)relevantIndices)))) {
            this.createHeaderProtectFinding();
        } else if (!checkedConstant.equals(definedConstant)) {
            this.buildFinding("Header protection defines constant `" + definedConstant + "` but is is checked for `" + checkedConstant + "`", this.buildLocation().forLine(((IToken)tokens.get((Integer)relevantIndices.get(1))).getLineNumber() + 1)).createAndStore();
        }
    }

    private static String checkAndExtractIfndef(IToken token) {
        if (token.getType() != ETokenType.PREPROCESSOR_DIRECTIVE) {
            return null;
        }
        String[] parts = MissingHeaderProtectionCheck.getPreprocessorDirectiveText(token).split("(\\s|[()])+");
        if (parts.length >= 2 && parts[0].equals("#ifndef")) {
            return parts[1];
        }
        if (parts.length < 3 || !parts[0].equals("#if")) {
            return null;
        }
        if (parts[1].equals("!defined")) {
            return parts[2];
        }
        if (parts[1].equals("!") && parts[2].equals("defined") && parts.length > 3) {
            return parts[3];
        }
        return null;
    }

    private static String getPreprocessorDirectiveText(IToken token) {
        return token.getText().trim().replaceFirst("#\\s+", "#");
    }

    private static String extractDefineConstant(IToken token) {
        if (token.getType() != ETokenType.PREPROCESSOR_DIRECTIVE) {
            return null;
        }
        String[] parts = MissingHeaderProtectionCheck.getPreprocessorDirectiveText(token).split("\\s+");
        if (parts.length < 2 || !parts[0].equals("#define")) {
            return null;
        }
        return parts[1];
    }

    private static boolean checkClosingEndIf(IToken lastToken) {
        return lastToken.getType() == ETokenType.PREPROCESSOR_DIRECTIVE && MissingHeaderProtectionCheck.getPreprocessorDirectiveText(lastToken).startsWith("#endif");
    }

    private void createHeaderProtectFinding() {
        this.buildFinding("Header protection missing or not implemented correctly", this.buildLocation().forElement()).createAndStore();
    }
}

