/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.arrays;

import eu.cqse.check.cpp.CppIntegerLiteralParser;
import eu.cqse.check.cpp.misra.arrays.ArrayAutomatonContext;
import eu.cqse.check.cpp.misra.arrays.ArrayElement;
import eu.cqse.check.cpp.misra.arrays.EArrayType;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

class ArrayAutomaton {
    private static final TokenPattern SIMPLE_INITIALIZATION_PATTERN = new TokenPattern().beginningOfStream().sequence(new Object[]{ETokenType.LBRACE, ETokenType.INTEGER_LITERAL, ETokenType.RBRACE}).endOfStream();
    private static final TokenPattern SIMPLE_NULLPTR_INITIALIZATION_PATTERN = new TokenPattern().beginningOfStream().sequence(new Object[]{ETokenType.LBRACE, ETokenType.NULLPTR, ETokenType.RBRACE}).endOfStream();
    private static final TokenPattern SIMPLE_IDENTIFIER_INITIALIZATION_PATTERN = new TokenPattern().beginningOfStream().sequence(new Object[]{ETokenType.LBRACE, ETokenType.IDENTIFIER, ETokenType.RBRACE}).endOfStream();
    private static final EnumSet<ETokenType> COMPOUND_TOKEN_TYPES = EnumSet.of(ETokenType.LBRACE, ETokenType.STRING_LITERAL, ETokenType.LBRACK);
    private static final EnumSet<EArrayType> COMPOUND_ARRAY_TYPES = EnumSet.of(EArrayType.STRUCT, EArrayType.UNKNOWN);
    private final ArrayAutomatonContext arrayAutomatonContext;
    private final ArrayElement[] elements;
    private List<IToken> compoundTokens = new ArrayList<IToken>();
    private final List<IToken> tokensToCreateCompoundFindingsFor = new ArrayList<IToken>();
    private List<Integer> designationCache = new ArrayList<Integer>();
    protected Map<String, Integer> arrayOffsetAliasEnumNames = new HashMap<String, Integer>();
    private int nestingDepth;
    private int aggregateInitializationNestingDepth = 0;
    private int functionCallDepth = 0;
    private int offset;
    private boolean designatedInitializer = false;
    private boolean designated = false;
    private boolean arrayElementIsValue = true;
    private boolean compoundExpected = false;
    private boolean previousParsedTokenWasComma = false;
    private boolean previousParsedTokenWasLbrace = false;
    private boolean previousParsedTokenWasIdentifier = false;
    private boolean insideAggregateInitialization = false;
    private boolean containsAggregateInitializationAtLeastOnce = false;
    private boolean isInsideArrayIndex = false;
    private boolean isInsideFunctionCallArguments = false;

    private ArrayAutomaton(ArrayAutomatonContext arrayAutomatonContext) {
        this.arrayAutomatonContext = arrayAutomatonContext;
        this.elements = new ArrayElement[arrayAutomatonContext.getCapacity()];
    }

    static Optional<ArrayAutomaton> parse(ArrayAutomatonContext arrayAutomatonContext) {
        ArrayAutomaton automaton = new ArrayAutomaton(arrayAutomatonContext);
        for (IToken token : arrayAutomatonContext.getInitializationTokens()) {
            if (automaton.handleToken(token)) continue;
            return Optional.empty();
        }
        return Optional.of(automaton);
    }

    private boolean handleToken(IToken token) {
        this.checkForAggregateInitializationStart(token);
        if (this.insideAggregateInitialization) {
            return this.handleAggregateInitialization(token);
        }
        this.checkForFunctionCallStart(token);
        if (this.isInsideFunctionCallArguments) {
            return this.handleFunctionCall(token);
        }
        this.checkTrailingComma(token);
        this.compoundTokens.add(token);
        if (this.compoundExpected && !COMPOUND_TOKEN_TYPES.contains(token.getType())) {
            this.addCompoundFinding(token);
        }
        this.compoundExpected = false;
        boolean valid = true;
        switch (token.getType().getTokenClass()) {
            case DELIMITER: {
                valid = this.handleDelimiter(token);
                break;
            }
            case OPERATOR: {
                this.handleOperator(token);
                break;
            }
            default: {
                valid = this.handleNonDelimiter(token);
            }
        }
        this.previousParsedTokenWasComma = token.getType() == ETokenType.COMMA;
        this.previousParsedTokenWasLbrace = token.getType() == ETokenType.LBRACE;
        this.previousParsedTokenWasIdentifier = token.getType() == ETokenType.IDENTIFIER;
        return valid;
    }

    private void checkForAggregateInitializationStart(IToken token) {
        if (this.previousParsedTokenWasLbrace && token.getType() == ETokenType.DOT && !this.insideAggregateInitialization) {
            this.insideAggregateInitialization = true;
            this.aggregateInitializationNestingDepth = 1;
            --this.nestingDepth;
        }
    }

    private void checkForFunctionCallStart(IToken token) {
        if (this.previousParsedTokenWasIdentifier && token.getType() == ETokenType.LPAREN) {
            this.isInsideFunctionCallArguments = true;
        }
    }

    private boolean handleFunctionCall(IToken token) {
        switch (token.getType()) {
            case LPAREN: {
                ++this.functionCallDepth;
                break;
            }
            case RPAREN: {
                --this.functionCallDepth;
                if (this.functionCallDepth != 0) break;
                this.isInsideFunctionCallArguments = false;
                break;
            }
        }
        return true;
    }

    private boolean isInStructInitialization() {
        return this.nestingDepth > this.arrayAutomatonContext.dimensionality();
    }

    private boolean handleAggregateInitialization(IToken token) {
        this.containsAggregateInitializationAtLeastOnce = true;
        switch (token.getType()) {
            case LBRACE: {
                ++this.aggregateInitializationNestingDepth;
                break;
            }
            case RBRACE: {
                --this.aggregateInitializationNestingDepth;
                if (this.aggregateInitializationNestingDepth != 0) break;
                this.insideAggregateInitialization = false;
                break;
            }
        }
        return true;
    }

    private boolean handleDelimiter(IToken token) {
        boolean valid = true;
        switch (token.getType()) {
            case LBRACE: {
                if (this.nestingDepth < this.arrayAutomatonContext.dimensionality()) {
                    this.resetCompoundTokens(token);
                } else if (COMPOUND_ARRAY_TYPES.contains((Object)this.arrayAutomatonContext.getType())) {
                    valid = this.handleElement();
                }
                ++this.nestingDepth;
                break;
            }
            case RBRACE: {
                this.fillLastCompoundWithEmptyElementsIfNeeded();
                valid = COMPOUND_ARRAY_TYPES.contains((Object)this.arrayAutomatonContext.getType()) && this.nestingDepth > this.arrayAutomatonContext.dimensionality() ? this.handleElement() : this.checkCompoundTokens();
                --this.nestingDepth;
                break;
            }
            case LBRACK: {
                if (this.previousParsedTokenWasIdentifier) {
                    this.isInsideArrayIndex = true;
                    break;
                }
                if (!this.designatedInitializer) {
                    this.designatedInitializer = true;
                    this.designationCache = new ArrayList<Integer>();
                }
                this.arrayElementIsValue = true;
                break;
            }
            case RBRACK: {
                if (!this.isInsideArrayIndex) break;
                this.isInsideArrayIndex = false;
                break;
            }
            case COMMA: {
                if (COMPOUND_ARRAY_TYPES.contains((Object)this.arrayAutomatonContext.getType()) && this.nestingDepth > this.arrayAutomatonContext.dimensionality()) break;
                this.compoundExpected = this.areOffsetsInDifferentCompounds(this.offset, ++this.offset);
                this.designated = false;
                this.arrayElementIsValue = true;
                break;
            }
        }
        return valid;
    }

    private void fillLastCompoundWithEmptyElementsIfNeeded() {
        if (this.skipCompoundFilling()) {
            return;
        }
        int alreadyInitializedTokensInLastCompound = (int)this.compoundTokens.stream().map(IToken::getType).filter(Predicate.not(ETokenType::isDelimiter)).count();
        int numberOfUninitializedElementsInLastCompound = this.arrayAutomatonContext.getDimensionSize(this.nestingDepth - 1) - alreadyInitializedTokensInLastCompound;
        if (numberOfUninitializedElementsInLastCompound > 0) {
            for (int i = 0; i < numberOfUninitializedElementsInLastCompound; ++i) {
                if (this.offset + i >= this.elements.length) continue;
                this.elements[this.offset + i] = null;
            }
            this.offset += numberOfUninitializedElementsInLastCompound;
        }
    }

    private boolean skipCompoundFilling() {
        return this.designated || this.containsAggregateInitializationAtLeastOnce || SIMPLE_INITIALIZATION_PATTERN.matchesAnywhere(this.compoundTokens) || SIMPLE_IDENTIFIER_INITIALIZATION_PATTERN.matchesAnywhere(this.compoundTokens) || SIMPLE_NULLPTR_INITIALIZATION_PATTERN.matchesAnywhere(this.compoundTokens) || this.nestingDepth <= 1;
    }

    private void checkTrailingComma(IToken token) {
        if (this.previousParsedTokenWasComma && token.getType() == ETokenType.RBRACE && !this.isInStructInitialization()) {
            --this.offset;
            this.compoundExpected = false;
        }
    }

    private void handleOperator(IToken token) {
        if (token.getType() == ETokenType.EQ && this.designatedInitializer) {
            this.designatedInitializer = false;
            this.designated = true;
            int[] designationIndexes = this.designationCache.stream().mapToInt(i -> i).limit(this.arrayAutomatonContext.dimensionality()).toArray();
            this.offset = this.arrayAutomatonContext.toOffset(designationIndexes);
            this.compoundExpected = this.areOffsetsInDifferentCompounds(this.offset - 1, this.offset);
        }
    }

    private boolean handleNonDelimiter(IToken token) {
        boolean valid = true;
        switch (token.getType()) {
            case STRING_LITERAL: {
                if (this.compoundTokens.size() > 1 && this.compoundTokens.get(this.compoundTokens.size() - 2).getType() == ETokenType.STRING_LITERAL) break;
                valid = this.handleStringLiteral();
                break;
            }
            case IDENTIFIER: {
                if (this.isInsideArrayIndex) break;
                if (this.designatedInitializer) {
                    int aliasOffset = this.arrayOffsetAliasEnumNames.computeIfAbsent(token.getText(), name -> this.arrayOffsetAliasEnumNames.size());
                    this.designationCache.add(aliasOffset);
                    break;
                }
                valid = this.handleElement();
                break;
            }
            case CHARACTER_LITERAL: {
                if (this.designatedInitializer) {
                    String charIndexLiteral = token.getText().replace("'", "");
                    if (charIndexLiteral.length() != 1) {
                        valid = false;
                        break;
                    }
                    this.designationCache.add(Integer.valueOf(charIndexLiteral.charAt(0)));
                    break;
                }
                valid = this.handleElement();
                break;
            }
            case INTEGER_LITERAL: {
                if (this.isInsideArrayIndex) break;
                if (this.designatedInitializer) {
                    this.designationCache.add(CppIntegerLiteralParser.parse((String)token.getText()));
                    break;
                }
            }
            default: {
                valid = this.handleElement();
            }
        }
        return valid;
    }

    private boolean handleStringLiteral() {
        ++this.nestingDepth;
        boolean valid = true;
        if (this.arrayElementIsValue) {
            valid = this.fillCompound();
        }
        --this.nestingDepth;
        return valid;
    }

    private boolean handleElement() {
        boolean valid = true;
        if (!this.designatedInitializer) {
            if (this.arrayElementIsValue) {
                valid = this.handleDefinition(this.offset, this.designated);
            }
            this.arrayElementIsValue = false;
        }
        return valid;
    }

    private boolean handleDefinition(int offset, boolean designated) {
        if (offset >= this.elements.length) {
            return false;
        }
        if (this.elements[offset] == null) {
            this.elements[offset] = new ArrayElement();
        }
        this.elements[offset].increaseInitializationCounter(designated);
        return true;
    }

    private void addCompoundFinding(IToken token) {
        int index;
        List<IToken> tokens = this.arrayAutomatonContext.getInitializationTokens();
        if (tokens.get((index = tokens.indexOf(token)) - 1).getType() != ETokenType.EQ) {
            this.tokensToCreateCompoundFindingsFor.add(token);
        } else if (++index < tokens.size() && tokens.get(index).getType() == ETokenType.COMMA && ++index < tokens.size() && tokens.get(index).getType().getTokenClass() != ETokenType.ETokenClass.DELIMITER) {
            this.tokensToCreateCompoundFindingsFor.add(token);
        }
    }

    private void resetCompoundTokens(IToken token) {
        this.compoundTokens = new ArrayList<IToken>();
        this.compoundTokens.add(token);
    }

    private boolean checkCompoundTokens() {
        boolean isZeroInitializer = SIMPLE_INITIALIZATION_PATTERN.matchesAnywhere(this.compoundTokens) && CppIntegerLiteralParser.parse((String)this.compoundTokens.get(1).getText()) == 0;
        boolean isNullInitializer = SIMPLE_IDENTIFIER_INITIALIZATION_PATTERN.matchesAnywhere(this.compoundTokens) && "NULL".equals(this.compoundTokens.get(1).getText());
        boolean isNullPtrInitializer = SIMPLE_NULLPTR_INITIALIZATION_PATTERN.matchesAnywhere(this.compoundTokens);
        if (isZeroInitializer || isNullInitializer || isNullPtrInitializer) {
            ++this.offset;
            if (this.arrayAutomatonContext.getCapacity() <= 1) {
                return true;
            }
            return this.fillCompound();
        }
        return true;
    }

    private boolean areOffsetsInDifferentCompounds(int offsetOne, int offsetTwo) {
        int[] oneIndices = this.arrayAutomatonContext.toIndexes(offsetOne);
        int[] twoIndices = this.arrayAutomatonContext.toIndexes(offsetTwo);
        for (int i = oneIndices.length - 2; i >= 0; --i) {
            if (oneIndices[i] == twoIndices[i]) continue;
            return true;
        }
        return false;
    }

    private boolean fillCompound() {
        int endOffset = this.getLastCompoundIndex();
        while (this.offset < endOffset) {
            if (this.handleDefinition(this.offset++, this.designated)) continue;
            return false;
        }
        return this.handleDefinition(this.offset, this.designated);
    }

    private int getLastCompoundIndex() {
        int[] indexes = this.arrayAutomatonContext.toIndexes(this.offset);
        if (indexes.length >= this.nestingDepth) {
            indexes[this.nestingDepth - 1] = this.arrayAutomatonContext.getDimensionSize(this.nestingDepth - 1) - 1;
        }
        return this.arrayAutomatonContext.toOffset(indexes);
    }

    protected boolean isFullyInitialized() {
        boolean allDefined = true;
        boolean allDesignated = true;
        for (ArrayElement entry : this.elements) {
            allDefined &= entry != null;
            allDesignated &= entry == null || entry.isDesignated();
        }
        return allDefined || allDesignated;
    }

    protected boolean anyMultipleInitialization() {
        for (ArrayElement entry : this.elements) {
            if (entry == null || !entry.isMultiplyInitialized()) continue;
            return true;
        }
        return false;
    }

    protected List<int[]> getMultipleInitializations() {
        ArrayList<int[]> indexes = new ArrayList<int[]>();
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == null || !this.elements[i].isMultiplyInitialized()) continue;
            indexes.add(this.arrayAutomatonContext.toIndexes(i));
        }
        return indexes;
    }

    protected List<IToken> getTokensToCreateCompoundFindingsFor() {
        return this.tokensToCreateCompoundFindingsFor;
    }
}

