/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.libraries;

import eu.cqse.check.base.UnwantedMethodCallsCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import java.util.Collection;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-forbidden-type-generic-math-functions", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ForbiddenTypeGenericMathFunctionsCheck
extends UnwantedMethodCallsCheckBase {
    private static final Set<String> FORBIDDEN_METHODS = CollectionUtils.asHashSet((Object[])new String[]{"fabs", "exp", "log", "pow", "sqrt", "sin", "cos", "tan", "asin", "acos", "atan", "sinh", "cosh", "tanh", "asinh", "acosh", "atanh", "atan2", "cbrt", "ceil", "copysign", "erf", "erfc", "exp2", "expm1", "fdim", "floor", "fma", "fmax", "fmin", "fmod", "frexp", "hypot", "ilogb", "ldexp", "lgamma", "llrint", "llround", "log10", "log1p", "log2", "logb", "lrint", "lround", "nearbyint", "nextafter", "nexttoward", "remainder", "remquo", "rint", "round", "scalbln", "scalbn", "tgamma", "trunc", "carg", "conj", "creal", "cimag", "cproj"});

    public void execute() throws CheckException {
        if (!this.includesTgmath()) {
            return;
        }
        super.execute();
    }

    private boolean includesTgmath() throws CheckException {
        return CollectionUtils.anyMatch((Collection)this.context.getTokens(ECodeViewOption.FILTERED), token -> token.getType() == ETokenType.PREPROCESSOR_INCLUDE && token.getText().contains("<tgmath.h>"));
    }

    protected Set<String> getUnwantedMethods() {
        return FORBIDDEN_METHODS;
    }
}

