/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.switches;

import eu.cqse.check.cpp.misra.switches.CppNoreturnMethodExtractorPhase;
import eu.cqse.check.cpp.misra.switches.WellFormedSwitchCheckVisitor;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.IShallowEntityVisitor;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-switch-statement-is-well-formed", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, phases={CppNoreturnMethodExtractorPhase.class})
public class SwitchStatementIsWellFormedCheck
extends CheckImplementationBase {
    @CheckOption(name="Ignore missing break statement in default cases of switch statements", description="If enabled, default cases of switch statements do not need a break if they are the last cases of the switch. However some valid MISRA findings will not be reported (the MISRA rule requires a break in each case including the default case, even if it is the last case).")
    private boolean ignoreMissingBreakStatementInDefaultCase = true;

    public void execute() throws CheckException {
        List allEntities = ShallowEntityTraversalUtils.getAllEntities((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()));
        for (ShallowEntity entity : allEntities) {
            if (!"switch".equals(entity.getSubtype())) continue;
            this.processEntity(entity);
        }
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private void processEntity(ShallowEntity entity) {
        WellFormedSwitchCheckVisitor visitor = new WellFormedSwitchCheckVisitor(this.context, this.ignoreMissingBreakStatementInDefaultCase);
        entity.traverse((IShallowEntityVisitor)visitor);
        if (!visitor.isInExitState()) {
            this.buildFinding(visitor.getFindingMessage(), this.buildLocation().forEntity(visitor.getCurrentEntity())).createAndStore();
        }
    }
}

