/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.clike.CLikeMethodParameterCountCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;

@Check(id="cqse-cs-method-parameter-count", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CsMethodParameterCountCheck
extends CLikeMethodParameterCountCheckBase {
    private static final String CHECK_NAME = "Methods should not have too many parameters (C#)";
    @CheckOption(name="Methods should not have too many parameters (C#): max. parameters", description="Maximum parameter count")
    private int maxNumberOfAllowedParameters = 7;

    @Override
    protected int getMaximumAllowedParameterCount() {
        return this.maxNumberOfAllowedParameters;
    }

    @Override
    protected boolean isDerivedMethod(ShallowEntity methodEntity) {
        return TokenStreamUtils.containsAny((List)methodEntity.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.OVERRIDE, ETokenType.NEW});
    }
}

