/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.hana_views;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.hana_views.HanaViewsCheckUtil;
import eu.cqse.check.xml.XmlCheckBase;
import eu.cqse.check.xml.XmlCheckHandlerBase;
import eu.cqse.check.xml.XmlElementAttributesCheckHandlerBase;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.conqat.lib.commons.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Check(id="cqse-join-on-calculated-attributes", languages={ELanguage.HANA_VIEW})
public class JoinOnCalculatedAttributesCheck
extends XmlCheckBase {
    private Set<String> calculatedAttributes = null;

    @Override
    protected void preProcess() throws CheckException {
        this.calculatedAttributes = new HashSet<String>();
        try {
            XMLUtils.parseSAX((InputSource)XMLUtils.toInputSource((String)this.context.getTextContent(ECodeViewOption.ETextViewOption.FILTERED_CONTENT)), (DefaultHandler)new DefaultHandler(this){
                final /* synthetic */ JoinOnCalculatedAttributesCheck this$0;
                {
                    JoinOnCalculatedAttributesCheck joinOnCalculatedAttributesCheck = this$0;
                    Objects.requireNonNull(joinOnCalculatedAttributesCheck);
                    this.this$0 = joinOnCalculatedAttributesCheck;
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    if (HanaViewsCheckUtil.ELEMENTS_CALCULATED_ATTRIBUTE.contains(localName)) {
                        this.this$0.calculatedAttributes.add(attributes.getValue("id"));
                    }
                }
            });
        }
        catch (IOException | SAXException e) {
            throw new CheckException("Unable to parse " + this.context.getUniformPath(), e);
        }
    }

    @Override
    public XmlCheckHandlerBase getHandler() {
        return new XmlElementAttributesCheckHandlerBase(this, "joinAttribute"){
            final /* synthetic */ JoinOnCalculatedAttributesCheck this$0;
            {
                JoinOnCalculatedAttributesCheck joinOnCalculatedAttributesCheck = this$0;
                Objects.requireNonNull(joinOnCalculatedAttributesCheck);
                this.this$0 = joinOnCalculatedAttributesCheck;
                super(xmlElementName);
            }

            @Override
            protected void checkAttributes(Attributes attributes) {
                String joinAttribute = attributes.getValue("name");
                if (this.this$0.calculatedAttributes.contains(joinAttribute)) {
                    this.createFinding("Join on calculated attribute '" + joinAttribute + "'");
                }
            }
        };
    }
}

