/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ECheckTarget;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.EJavaTestFramework;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.MethodCallMatchers;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Check(id="java:S3415", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, target={ECheckTarget.TEST_CODE})
public class AssertionArgumentOrderCheck
extends CheckImplementationBase {
    private static final String MESSAGE_SWAP = "Swap these 2 arguments so they are in the correct order: %s.";
    private static final String MESSAGE_TWO_LITERALS = "Change this assertion to not compare two literals.";
    private static final String MESSAGE_REPLACE_LITERAL = "Replace this literal with the actual expression you want to assert.";
    private static final Set<String> JUNIT4_METHODS = Set.of("assertEquals", "assertSame", "assertNotSame");
    private static final Set<String> JUNIT5_METHODS = Set.of("assertEquals", "assertSame", "assertNotSame", "assertArrayEquals", "assertIterableEquals", "assertLinesMatch", "assertNotEquals");
    private static final Set<String> TESTNG_METHODS = Set.of("assertEquals", "assertNotEquals", "assertSame", "assertNotSame");
    private static final Set<String> ASSERTJ_COMPARISON_METHODS = Set.of("isEqualTo", "isNotEqualTo", "isSameAs", "isNotSameAs", "isCloseTo", "isLessThanOrEqualTo");
    private static final MethodCallMatchers ASSERTION_MATCHERS = MethodCallMatchers.combine((JavaMethodCallMatcher[])new JavaMethodCallMatcher[]{AssertionArgumentOrderCheck.createMatcher(EJavaTestFramework.ASSERT_J, Set.of("assertThat", "assertThatObject"), 1, 1), AssertionArgumentOrderCheck.createMatcher(EJavaTestFramework.JUNIT_4, JUNIT4_METHODS, 2, Integer.MAX_VALUE), AssertionArgumentOrderCheck.createMatcher(EJavaTestFramework.JUNIT_5, JUNIT5_METHODS, 2, Integer.MAX_VALUE), AssertionArgumentOrderCheck.createMatcher(EJavaTestFramework.TESTNG, TESTNG_METHODS, 2, Integer.MAX_VALUE)});
    private static final TokenPattern LITERAL_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.ETokenClass.LITERAL});
    private static final TokenPattern STRING_LITERAL_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.STRING_LITERAL});
    private static final TokenPattern STATIC_FINAL_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.STATIC, ETokenType.FINAL});
    private static final TokenPattern QUALIFIED_CONSTANT_PATTERN = TokenPattern.of().sequence(new Object[]{ITokenMatcher.hasText((String[])new String[]{"this"}).or(new ITokenMatcher[]{ETokenType.IDENTIFIER}), ETokenType.DOT}).repeated(new Object[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new Object[]{ITokenMatcher.matchesRegex((String)"[A-Z0-9_]+")});
    private static final TokenPattern NEW_EMPTY_ARRAY_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.NEW, ETokenType.IDENTIFIER}).skipNested((Object)ETokenType.LBRACK, (Object)ETokenType.RBRACK, false).notFollowedBy((Object)ETokenType.LBRACE);
    private static final TokenPattern NEW_ARRAY_WITH_INIT_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.NEW, ETokenType.IDENTIFIER}).skipNested((Object)ETokenType.LBRACK, (Object)ETokenType.RBRACK, false).skipNested((Object)ETokenType.LBRACE, (Object)ETokenType.RBRACE, false);
    private static final TokenPattern COLLECTION_FACTORY_PATTERN = TokenPattern.of().sequence(new Object[]{ITokenMatcher.hasText((String[])new String[]{"singletonList", "singleton", "emptyList", "emptySet", "asList"}), ETokenType.LPAREN}).group(0);

    private static JavaMethodCallMatcher createMatcher(EJavaTestFramework framework, Set<String> methods, int minParams, int maxParams) {
        return JavaMethodCallMatcher.create().onTypes(framework.getAssertionTypes()).withTargetMethodNames(methods).withParameterCount(minParams, maxParams).withTag((Object)framework);
    }

    public void execute() throws CheckException {
        if (LanguageFeatureParser.JAVA.getTestFrameworkImports((List)this.getRootChildren()).isEmpty()) {
            return;
        }
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        Set<String> constants = AssertionArgumentOrderCheck.buildConstantSet(ast);
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        for (JavaMethodCallMatcher.MethodCall call : ASSERTION_MATCHERS.find(this.context, typeResolver)) {
            Object object = call.tag();
            if (!(object instanceof EJavaTestFramework)) continue;
            EJavaTestFramework framework = (EJavaTestFramework)object;
            this.checkAssertion(call, framework, constants);
        }
    }

    private void checkAssertion(JavaMethodCallMatcher.MethodCall call, EJavaTestFramework framework, Set<String> constants) {
        switch (framework) {
            case ASSERT_J: {
                this.checkAssertJ(call, constants);
                break;
            }
            case JUNIT_4: {
                this.checkJUnit(call, constants, true);
                break;
            }
            case JUNIT_5: {
                this.checkJUnit(call, constants, false);
                break;
            }
            case TESTNG: {
                this.checkTestNG(call, constants);
                break;
            }
        }
    }

    private void checkAssertJ(JavaMethodCallMatcher.MethodCall call, Set<String> constants) {
        boolean isComplexCase;
        List actual = (List)call.parameters().getFirst();
        List chainedCalls = call.findChainedCalls();
        Optional<JavaMethodCallMatcher.ChainedCall> comparison = chainedCalls.stream().filter(c -> ASSERTJ_COMPARISON_METHODS.contains(c.methodName())).findFirst();
        if (comparison.isEmpty()) {
            if (AssertionArgumentOrderCheck.isLiteral(actual)) {
                this.report(MESSAGE_REPLACE_LITERAL, call.entity(), actual);
            }
            return;
        }
        List<List<IToken>> expectedParams = AssertionArgumentOrderCheck.splitParams(comparison.get().parameters());
        if (expectedParams.isEmpty()) {
            return;
        }
        boolean bl = isComplexCase = chainedCalls.indexOf(comparison.get()) > 0 || expectedParams.size() > 1;
        if (isComplexCase) {
            if (AssertionArgumentOrderCheck.isLiteral(actual)) {
                this.report(MESSAGE_REPLACE_LITERAL, call.entity(), actual);
            }
            return;
        }
        List<IToken> expected = expectedParams.getFirst();
        if (AssertionArgumentOrderCheck.isLiteral(actual) || !this.isConstantOrLiteral(expected, constants)) {
            this.reportSwappedArgs(actual, expected, "actual value, expected value", call.entity(), constants);
        }
    }

    private void checkJUnit(JavaMethodCallMatcher.MethodCall call, Set<String> constants, boolean isJUnit4) {
        List args = call.parameters();
        if (args.size() < 2 || args.stream().allMatch(List::isEmpty)) {
            return;
        }
        ArgumentPair pair = AssertionArgumentOrderCheck.extractJUnitArgs(args, isJUnit4);
        this.reportSwappedArgs(pair.actual, pair.expected, "expected value, actual value", call.entity(), constants);
    }

    private void checkTestNG(JavaMethodCallMatcher.MethodCall call, Set<String> constants) {
        List args = call.parameters();
        if (args.size() < 2 || args.stream().allMatch(List::isEmpty)) {
            return;
        }
        this.reportSwappedArgs((List)args.get(0), (List)args.get(1), "actual value, expected value", call.entity(), constants);
    }

    private static ArgumentPair extractJUnitArgs(List<List<IToken>> args, boolean isJUnit4) {
        if (args.size() > 2) {
            if (isJUnit4 && STRING_LITERAL_PATTERN.matchFully(args.getFirst()) != null) {
                return new ArgumentPair(args.get(1), args.get(2));
            }
            List<IToken> last = args.getLast();
            if (AssertionArgumentOrderCheck.isMessageOrSupplier(last)) {
                return new ArgumentPair(args.get(0), args.get(1));
            }
        }
        return new ArgumentPair(args.get(0), args.get(1));
    }

    private static boolean isMessageOrSupplier(List<IToken> tokens) {
        return STRING_LITERAL_PATTERN.matchFully(tokens) != null || TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.ARROW) != -1;
    }

    private void reportSwappedArgs(List<IToken> actual, List<IToken> expected, String order, ShallowEntity entity, Set<String> constants) {
        boolean actualLiteral = AssertionArgumentOrderCheck.isLiteral(actual);
        boolean expectedLiteral = AssertionArgumentOrderCheck.isLiteral(expected);
        if (actualLiteral && expectedLiteral) {
            this.report(MESSAGE_TWO_LITERALS, entity, expected);
            return;
        }
        boolean actualConstantOrLiteral = this.isConstantOrLiteral(actual, constants);
        boolean expectedConstantOrLiteral = this.isConstantOrLiteral(expected, constants);
        if (actualLiteral || actualConstantOrLiteral && !expectedConstantOrLiteral) {
            this.report(String.format(MESSAGE_SWAP, order), entity, actual);
        }
    }

    private static Set<String> buildConstantSet(List<ShallowEntity> ast) {
        HashSet<String> constants = new HashSet<String>(AssertionArgumentOrderCheck.findStaticFinalFields(ast));
        LanguageFeatureParser.JAVA.getImportsAndFullNamespaceVariables(ast).stream().map(AssertionArgumentOrderCheck::getSimpleName).filter(name -> name.matches("[A-Z0-9_]+")).forEach(constants::add);
        return constants;
    }

    private static String getSimpleName(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot < 0) {
            return qualifiedName;
        }
        return qualifiedName.substring(lastDot + 1);
    }

    private static Set<String> findStaticFinalFields(List<ShallowEntity> ast) {
        return ShallowEntityTraversalUtils.listEntitiesOfType(ast, (EShallowEntityType)EShallowEntityType.ATTRIBUTE).stream().filter(attr -> STATIC_FINAL_PATTERN.matchesAnywhere((List)attr.ownStartTokens())).flatMap(attr -> ShallowParsingUtils.extractVariableNameTokens((List)attr.ownStartTokens()).stream()).map(IToken::getText).collect(Collectors.toSet());
    }

    private static boolean isLiteral(List<IToken> tokens) {
        return tokens.size() == 1 && LITERAL_PATTERN.matchFully(tokens) != null;
    }

    private boolean isConstantOrLiteral(List<IToken> tokens, Set<String> constants) {
        if (tokens.isEmpty()) {
            return false;
        }
        return AssertionArgumentOrderCheck.isLiteral(tokens) || AssertionArgumentOrderCheck.isSingleConstant(tokens, constants) || QUALIFIED_CONSTANT_PATTERN.matchFully(tokens) != null || NEW_EMPTY_ARRAY_PATTERN.matchFully(tokens) != null || this.isConstantCollection(tokens, constants) || this.isConstantArrayInit(tokens, constants);
    }

    private static boolean isSingleConstant(List<IToken> tokens, Set<String> constants) {
        return tokens.size() == 1 && tokens.getFirst().getType() == ETokenType.IDENTIFIER && constants.contains(tokens.getFirst().getText());
    }

    private boolean isConstantCollection(List<IToken> tokens, Set<String> constants) {
        return Optional.ofNullable(COLLECTION_FACTORY_PATTERN.findFirstMatch(tokens)).flatMap(m -> AssertionArgumentOrderCheck.extractArgsAfterMatch(tokens, m)).map(args -> args.isEmpty() || this.allConstantsOrLiterals((List<IToken>)args, constants)).orElse(false);
    }

    private boolean isConstantArrayInit(List<IToken> tokens, Set<String> constants) {
        if (NEW_ARRAY_WITH_INIT_PATTERN.matchFully(tokens) == null) {
            return false;
        }
        int braceStart = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.LBRACE);
        if (braceStart == -1 || braceStart >= tokens.size() - 1) {
            return false;
        }
        List<IToken> content = tokens.subList(braceStart + 1, tokens.size() - 1);
        return content.isEmpty() || this.allConstantsOrLiterals(content, constants);
    }

    private static Optional<List<IToken>> extractArgsAfterMatch(List<IToken> tokens, TokenPatternMatch match) {
        List indices = match.groupIndices(0);
        if (indices.isEmpty()) {
            return Optional.empty();
        }
        int lparen = (Integer)indices.getLast();
        int rparen = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(lparen + 1), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        if (rparen == -1) {
            return Optional.empty();
        }
        return Optional.of(tokens.subList(lparen + 1, rparen));
    }

    private boolean allConstantsOrLiterals(List<IToken> tokens, Set<String> constants) {
        return AssertionArgumentOrderCheck.splitParams(tokens).stream().allMatch(e -> this.isConstantOrLiteral((List<IToken>)e, constants));
    }

    private static List<List<IToken>> splitParams(List<IToken> tokens) {
        return TokenStreamUtils.splitWithNesting(tokens, (ETokenType)ETokenType.COMMA, (List)TokenStreamUtils.STANDARD_OPENING_TOKEN_TYPES, (List)TokenStreamUtils.STANDARD_CLOSING_TOKEN_TYPES);
    }

    private void report(String message, ShallowEntity entity, List<IToken> tokens) {
        if (tokens.isEmpty()) {
            this.buildFinding(message, this.buildLocation().forEntity(entity)).createAndStore();
        } else {
            this.buildFinding(message, this.buildLocation().forTokens(tokens)).createAndStore();
        }
    }

    private record ArgumentPair(List<IToken> expected, List<IToken> actual) {
    }
}

