/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Check(id="java:S6539", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ClassImportCouplingCheck
extends CheckImplementationBase {
    @CheckOption(name="couplingThreshold (java:S6539)", description="Maximum number of classes a single class is allowed to depend upon.")
    private int max = 20;
    @CheckOption(name="Ignore Utility Classes", description="When enabled, classes with names containing the string 'Util' are excluded from analysis.")
    private boolean ignoreUtilClasses = true;
    private static final int TYPE_GROUP = 0;
    private static final Set<String> MOST_COMMON_JAVA_LANG = Set.of("Object", "String", "Class", "System", "Math", "Runtime", "Enum", "Void", "Package", "Module", "Boolean", "Byte", "Character", "Short", "Integer", "Long", "Float", "Double", "Number", "StringBuilder", "StringBuffer", "CharSequence", "Runnable", "Comparable", "Iterable", "Cloneable", "AutoCloseable", "Readable", "Appendable", "Thread", "ThreadGroup", "ThreadLocal", "Thread.State", "Override", "Deprecated", "SuppressWarnings", "FunctionalInterface", "SafeVarargs", "StrictMath", "Process", "ProcessBuilder", "StackTraceElement", "INSTANCE");
    private static final TokenPattern QUALIFIED_NAME = TokenPattern.of().sequence(new Object[]{ETokenType.IDENTIFIER}).repeated(new Object[]{TokenPattern.of().sequence(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER})});
    private static final TokenPattern CAPTURE_QUALIFIED_NAME = TokenPattern.of().sequence(new Object[]{QUALIFIED_NAME}).group(0);
    private static final TokenPattern FIELD_TYPE_PATTERN = TokenPattern.of().sequence(new Object[]{CAPTURE_QUALIFIED_NAME, ETokenType.IDENTIFIER}).notFollowedBy((Object)ETokenType.LPAREN);
    private static final TokenPattern GENERIC_TYPE_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.LT}).repeated(new Object[]{TokenPattern.of().sequence(new Object[]{CAPTURE_QUALIFIED_NAME}).optional(new Object[]{ETokenType.COMMA})});
    private static final TokenPattern METHOD_REFERENCE_PATTERN = TokenPattern.of().sequence(new Object[]{CAPTURE_QUALIFIED_NAME, ETokenType.DOUBLE_COLON});
    private static final TokenPattern ARRAY_TYPE_PATTERN = TokenPattern.of().sequence(new Object[]{CAPTURE_QUALIFIED_NAME}).repeated(new Object[]{TokenPattern.of().sequence(new Object[]{ETokenType.LBRACK, ETokenType.RBRACK})});
    private static final TokenPattern METHOD_PARAMETER_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.LPAREN}).repeated(new Object[]{TokenPattern.of().optional(new Object[]{ETokenType.AT_OPERATOR, QUALIFIED_NAME}).sequence(new Object[]{CAPTURE_QUALIFIED_NAME, ETokenType.IDENTIFIER}).optional(new Object[]{ETokenType.COMMA})});
    private static final TokenPattern SWITCH_CASE_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.CASE, CAPTURE_QUALIFIED_NAME});
    private static final TokenPattern METHOD_PATTERNS = TokenPattern.of().alternative(new Object[]{TokenPattern.of().sequence(new Object[]{CAPTURE_QUALIFIED_NAME, ETokenType.IDENTIFIER, ETokenType.LPAREN}), METHOD_PARAMETER_PATTERN, TokenPattern.of().sequence(new Object[]{ETokenType.THROWS}).repeated(new Object[]{TokenPattern.of().sequence(new Object[]{CAPTURE_QUALIFIED_NAME}).optional(new Object[]{ETokenType.COMMA})}), TokenPattern.of().sequence(new Object[]{ETokenType.EXTENDS, CAPTURE_QUALIFIED_NAME}), TokenPattern.of().sequence(new Object[]{ETokenType.AND, CAPTURE_QUALIFIED_NAME}), METHOD_REFERENCE_PATTERN});
    private static final TokenPattern STATEMENT_PATTERNS = TokenPattern.of().alternative(new Object[]{TokenPattern.of().sequence(new Object[]{CAPTURE_QUALIFIED_NAME, ETokenType.IDENTIFIER, ETokenType.EQ}), TokenPattern.of().sequence(new Object[]{ETokenType.LPAREN, CAPTURE_QUALIFIED_NAME, ETokenType.RPAREN}), TokenPattern.of().sequence(new Object[]{ETokenType.INSTANCEOF, CAPTURE_QUALIFIED_NAME}), TokenPattern.of().sequence(new Object[]{ETokenType.NEW, CAPTURE_QUALIFIED_NAME}), TokenPattern.of().sequence(new Object[]{ETokenType.CATCH, ETokenType.LPAREN, CAPTURE_QUALIFIED_NAME}), TokenPattern.of().sequence(new Object[]{ETokenType.LPAREN, CAPTURE_QUALIFIED_NAME, ETokenType.IDENTIFIER, ETokenType.ARROW}), METHOD_REFERENCE_PATTERN});
    private static final Map<EShallowEntityType, TokenPattern> PATTERN_MAP = new EnumMap<EShallowEntityType, TokenPattern>(EShallowEntityType.class);

    public void execute() throws CheckException {
        ShallowEntity root = this.context.getRootEntity(this.getCodeViewOption());
        String projectPackage = ClassImportCouplingCheck.getProjectPackage(root);
        Set<String> externalTypes = ClassImportCouplingCheck.extractExternalTypes(projectPackage, root);
        this.getClassEntities((List<ShallowEntity>)root.getChildren()).forEach(entity -> {
            Set<String> dependencies = this.collectDependencies((ShallowEntity)entity, projectPackage, externalTypes);
            if (dependencies.size() > this.max) {
                this.reportFinding((ShallowEntity)entity, dependencies.size());
            }
        });
    }

    private static String getProjectPackage(ShallowEntity root) {
        return LanguageFeatureParser.JAVA.getPackageName((List)root.getChildren()).map(pkg -> {
            int firstDot = pkg.indexOf(46);
            if (firstDot > 0) {
                return pkg.substring(0, firstDot);
            }
            return pkg;
        }).orElse("");
    }

    private static Set<String> extractExternalTypes(String projectPackage, ShallowEntity root) {
        JavaImportSensitiveTypeResolver resolver = new JavaImportSensitiveTypeResolver(root);
        return resolver.getSpecificImports().stream().filter(importedClass -> !importedClass.startsWith(projectPackage)).map(fqn -> fqn.substring(fqn.lastIndexOf(46) + 1)).collect(Collectors.toSet());
    }

    private Stream<ShallowEntity> getClassEntities(List<ShallowEntity> ast) {
        return ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive(ast, (EShallowEntityType)EShallowEntityType.TYPE).stream().filter(entity -> {
            String subtype = entity.getSubtype();
            boolean isClassOrEnum = "class".equals(subtype) || "enum".equals(subtype);
            boolean isNotUtil = !this.ignoreUtilClasses || entity.getName() != null && !entity.getName().contains("Util");
            return isClassOrEnum && isNotUtil;
        });
    }

    private Set<String> collectDependencies(ShallowEntity entity, String projectPackage, Set<String> externalTypes) {
        Set<String> selfAndNestedTypes = this.getSelfAndNestedTypeNames(entity);
        return this.getAllDescendants(entity).flatMap(ClassImportCouplingCheck::extractTypesFromEntity).filter(qualifiedName -> ClassImportCouplingCheck.isCountableDependency(qualifiedName, projectPackage, externalTypes, selfAndNestedTypes)).collect(Collectors.toSet());
    }

    private Set<String> getSelfAndNestedTypeNames(ShallowEntity entity) {
        return this.getAllDescendants(entity).filter(e -> e.getType() == EShallowEntityType.TYPE).map(ShallowEntity::getName).collect(Collectors.toSet());
    }

    private Stream<ShallowEntity> getAllDescendants(ShallowEntity entity) {
        return Stream.concat(Stream.of(entity), entity.getChildren().stream().filter(ClassImportCouplingCheck::shouldTraverseChild).flatMap(this::getAllDescendants));
    }

    private static Stream<String> extractTypesFromEntity(ShallowEntity entity) {
        Stream<String> dependencies = Stream.empty();
        if ("enum literal".equals(entity.getSubtype())) {
            return dependencies;
        }
        TokenPattern pattern = PATTERN_MAP.get(entity.getType());
        if (pattern != null) {
            dependencies = pattern.findNonOverlappingMatches((List)entity.ownStartTokens()).stream().flatMap(match -> match.getMatchGroup(0).stream().map(groupElement -> groupElement.getTokens().stream().map(IToken::getText).collect(Collectors.joining())));
        }
        return dependencies;
    }

    private static boolean isCountableDependency(String typeName, String projectPackage, Set<String> externalSimpleNames, Set<String> selfAndNestedTypes) {
        boolean isIgnoredType;
        boolean isQualified = typeName.contains(".");
        String simpleName = isQualified ? typeName.substring(typeName.lastIndexOf(46) + 1) : typeName;
        boolean isGenericParameter = simpleName.length() == 1 && Character.isUpperCase(simpleName.charAt(0));
        boolean isScreamingSnakeCase = simpleName.equals(simpleName.toUpperCase()) && simpleName.length() > 1 && simpleName.contains("_");
        boolean isField = Character.isLowerCase(simpleName.charAt(0));
        boolean isException = simpleName.endsWith("Exception");
        boolean bl = isIgnoredType = MOST_COMMON_JAVA_LANG.contains(simpleName) || selfAndNestedTypes.contains(simpleName);
        if (isGenericParameter || isScreamingSnakeCase || isField || isIgnoredType || isException) {
            return false;
        }
        if (isQualified) {
            return !projectPackage.isEmpty() && typeName.startsWith(projectPackage);
        }
        return !externalSimpleNames.contains(simpleName);
    }

    private static boolean shouldTraverseChild(ShallowEntity entity) {
        if (entity.getType() != EShallowEntityType.TYPE) {
            return true;
        }
        return "enum".equals(entity.getSubtype()) || ClassImportCouplingCheck.isPublic(entity);
    }

    private static boolean isPublic(ShallowEntity entity) {
        return entity.ownStartTokens().stream().anyMatch(arg_0 -> ((ETokenType)ETokenType.PUBLIC).matches(arg_0));
    }

    private void reportFinding(ShallowEntity entity, int dependencyCount) {
        String message = String.format("Split this \"Monster Class\" into smaller and more specialized ones to reduce its dependencies on other classes from %d to the maximum authorized %d or less", dependencyCount, this.max);
        this.buildFinding(message, this.buildLocation().forEntity(entity)).createAndStore();
    }

    static {
        PATTERN_MAP.put(EShallowEntityType.ATTRIBUTE, TokenPattern.of().alternative(new Object[]{FIELD_TYPE_PATTERN, GENERIC_TYPE_PATTERN, ARRAY_TYPE_PATTERN}));
        PATTERN_MAP.put(EShallowEntityType.METHOD, TokenPattern.of().alternative(new Object[]{METHOD_PATTERNS, GENERIC_TYPE_PATTERN, ARRAY_TYPE_PATTERN}));
        PATTERN_MAP.put(EShallowEntityType.STATEMENT, TokenPattern.of().alternative(new Object[]{STATEMENT_PATTERNS, GENERIC_TYPE_PATTERN, ARRAY_TYPE_PATTERN, SWITCH_CASE_PATTERN}));
        PATTERN_MAP.put(EShallowEntityType.META, TokenPattern.of().sequence(new Object[]{ETokenType.AT_OPERATOR, CAPTURE_QUALIFIED_NAME}));
    }
}

