/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.List;

@Check(id="cqse-inner-type-visibility", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class InnerTypeVisibilityCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List innerTypes = ShallowEntityTraversalUtils.findNestedEntities((List)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE, entity -> true, (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity innerType : innerTypes) {
            if (!TokenStreamUtils.contains((List)innerType.ownStartTokens(), (ETokenType)ETokenType.PUBLIC)) continue;
            this.buildFinding(this.getFindingMessage(innerType), this.buildLocation().forEntity(innerType)).createAndStore();
        }
    }

    private String getFindingMessage(ShallowEntity entity) {
        return "Inner type `" + entity.getName() + "` should not be public";
    }
}

