/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.java.WildcardImportResolver;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableSet;

@Check(id="cqse-java-lang-name", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class JavaLangNameCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Type uses name from java.lang";
    @CheckOption(name="Type uses name from java.lang: Allow names from sub-packages", description="Determines whether class names from sub-packages of `java.lang` (e.g. `java.lang.reflect`) should be allowed or not.\n")
    private boolean allowSubPackages = false;

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity entity) {
        String className;
        String clashingPackage;
        if (((IToken)entity.includedTokens().get(0)).getType() != ETokenType.NEW && (clashingPackage = this.getClashingPackage(className = entity.getName())) != null) {
            this.buildFinding("`%s` clashes with name from `%s`".formatted(className, clashingPackage), this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }

    private String getClashingPackage(String className) {
        if (WildcardImportResolver.getTypesInPackage((String)"java.lang").contains((Object)className)) {
            return "java.lang";
        }
        if (!this.allowSubPackages) {
            for (String packageName : WildcardImportResolver.getSubpackages((String)"java.lang")) {
                UnmodifiableSet typeNamesInPackage = WildcardImportResolver.getTypesInPackage((String)packageName);
                if (!typeNamesInPackage.contains(className)) continue;
                return packageName;
            }
        }
        return null;
    }
}

