/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ECheckTarget;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.java.JavaTypeInfoExtractor;
import eu.cqse.check.framework.util.EJavaTestFramework;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-missing-test-annotation", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, target={ECheckTarget.TEST_CODE})
public class MissingTestAnnotationCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Annotation in JUnit test class missing";
    private static final Set<String> TEST_ANNOTATION_SIMPLE_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"Test", "RepeatedTest", "ParameterizedTest", "BeforeEach", "AfterEach", "BeforeAll", "AfterAll", "Before", "After", "BeforeClass", "AfterClass"});
    private static final Set<String> TEST_ANNOTATION_QUALIFIED_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"org.junit.Test", "org.junit.jupiter.api.Test", "org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.AfterEach", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll", "org.junit.Before", "org.junit.After", "org.junit.BeforeClass", "org.junit.AfterClass"});
    @CheckOption(name="Annotation in JUnit test class missing: Test class name pattern", description="The naming pattern for test classes. Default is \".*Test$\".")
    private String testClassNamePattern = ".*Test$";
    private Pattern compiledTestClassNamePattern;

    public void initialize() throws CheckException {
        this.compiledTestClassNamePattern = Pattern.compile(this.testClassNamePattern);
    }

    public void execute() throws CheckException {
        if (!this.hasJUnitImport()) {
            return;
        }
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            if (type.getName() == null || !this.compiledTestClassNamePattern.matcher(type.getName()).matches()) continue;
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity classEntity) {
        boolean isJUnit4OrHigher = MissingTestAnnotationCheck.isJUnit4OrHigherTestClass(classEntity);
        if (!isJUnit4OrHigher) {
            return;
        }
        for (ShallowEntity child : classEntity.getChildrenOfType(EShallowEntityType.METHOD)) {
            if (MissingTestAnnotationCheck.isConstructor(classEntity, child) || LanguageFeatureParser.JAVA.isAnnotated(child) || !MissingTestAnnotationCheck.isMethodWithTestNamingConventionMissingAnnotation(child) && !MissingTestAnnotationCheck.isPublicNonAbstractNonStaticParameterlessMethod(child)) continue;
            this.createMissingAnnotationFinding(child);
        }
    }

    private static boolean isConstructor(ShallowEntity classEntity, ShallowEntity child) {
        return classEntity.getName() == null || classEntity.getName().equals(child.getName());
    }

    private static boolean isMethodWithTestNamingConventionMissingAnnotation(ShallowEntity method) {
        String name = method.getName();
        if (name == null || !name.startsWith("test")) {
            return false;
        }
        if (LanguageFeatureParser.JAVA.isAnnotated(method)) {
            return false;
        }
        return MissingTestAnnotationCheck.isNonAbstractNonStaticParameterlessMethod(method);
    }

    private static boolean isJUnit4OrHigherTestClass(ShallowEntity classEntity) {
        return classEntity.getChildrenOfType(EShallowEntityType.METHOD).stream().anyMatch(MissingTestAnnotationCheck::isTestAnnotationPresent);
    }

    private void createMissingAnnotationFinding(ShallowEntity method) {
        if (TokenStreamUtils.containsAny((List)method.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.PUBLIC})) {
            this.buildFinding("Method " + MarkupUtils.formatAsSourceCode((String)method.getName()) + " is `public` but has no JUnit annotation", this.buildLocation().forEntityFirstLine(method)).createAndStore();
        } else {
            this.buildFinding("Method " + MarkupUtils.formatAsSourceCode((String)method.getName()) + " has no JUnit annotation", this.buildLocation().forEntityFirstLine(method)).createAndStore();
        }
    }

    private static boolean isTestAnnotationPresent(ShallowEntity method) {
        List annotations = LanguageFeatureParser.JAVA.getAnnotations(method);
        return annotations.stream().map(ShallowEntity::getName).anyMatch(MissingTestAnnotationCheck::isTestAnnotationName);
    }

    private static boolean isPublicNonAbstractNonStaticParameterlessMethod(ShallowEntity method) {
        if (!TokenStreamUtils.containsAny((List)method.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.PUBLIC})) {
            return false;
        }
        return MissingTestAnnotationCheck.isNonAbstractNonStaticParameterlessMethod(method);
    }

    private static boolean isNonAbstractNonStaticParameterlessMethod(ShallowEntity method) {
        if (TokenStreamUtils.containsAny((List)method.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.ABSTRACT})) {
            return false;
        }
        if (TokenStreamUtils.containsAny((List)method.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.STATIC})) {
            return false;
        }
        return new JavaTypeInfoExtractor().extractFromMethod(method).isEmpty();
    }

    private static boolean isTestAnnotationName(String annotationName) {
        return TEST_ANNOTATION_SIMPLE_NAMES.contains(annotationName) || TEST_ANNOTATION_QUALIFIED_NAMES.contains(annotationName);
    }

    private boolean hasJUnitImport() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        UnmodifiableSet testFrameworkImports = LanguageFeatureParser.JAVA.getTestFrameworkImports(ast).getKeys();
        return testFrameworkImports.contains(EJavaTestFramework.JUNIT_4) || testFrameworkImports.contains(EJavaTestFramework.JUNIT_5);
    }
}

