/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.clike.CLikeCheckUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="java:S2229", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SpringIncompatibleTransactionalCheck
extends CheckImplementationBase {
    private static final String MANDATORY = "MANDATORY";
    private static final String NESTED = "NESTED";
    private static final String NEVER = "NEVER";
    private static final String NOT_SUPPORTED = "NOT_SUPPORTED";
    private static final String REQUIRED = "REQUIRED";
    private static final String REQUIRES_NEW = "REQUIRES_NEW";
    private static final String SUPPORTS = "SUPPORTS";
    private static final String NOT_TRANSACTIONAL = "SONAR_NOT_TRANSACTIONAL";
    private static final String UNRESOLVABLE = "UNRESOLVABLE";
    private static final Set<String> ALL_PROPAGATION_TYPES = Set.of("MANDATORY", "NESTED", "NEVER", "NOT_SUPPORTED", "REQUIRED", "REQUIRES_NEW", "SUPPORTS");
    private static final Set<String> TRANSACTIONAL_ANNOTATION_NAMES = Set.of("org.springframework.transaction.annotation.Transactional", "Transactional", "javax.transaction.Transactional");
    private static final int GROUP_METHOD_NAME = 0;
    private static final int GROUP_ARGUMENTS = 1;
    private static final TokenPattern METHOD_CALL_PATTERN = TokenPattern.of().alternative(new Object[]{TokenPattern.of().sequence(new Object[]{ETokenType.THIS, ETokenType.DOT}), TokenPattern.of().notPrecededBy((Object)ETokenType.DOT)}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false).group(1);
    private static final TokenPattern NAMED_PROPAGATION_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"propagation", "value"})}), ETokenType.EQ}).repeated(new Object[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0);
    private static final TokenPattern UNNAMED_PROPAGATION_PATTERN = TokenPattern.of().repeated(new Object[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0);
    private static final Map<String, Set<String>> INCOMPATIBLE_PROPAGATION_MAP = SpringIncompatibleTransactionalCheck.buildIncompatiblePropagationMap();

    private static Map<String, Set<String>> buildIncompatiblePropagationMap() {
        return Map.ofEntries(Map.entry(NOT_TRANSACTIONAL, Set.of(MANDATORY, NESTED, REQUIRED, REQUIRES_NEW)), Map.entry(MANDATORY, Set.of(NESTED, NEVER, NOT_SUPPORTED, REQUIRES_NEW)), Map.entry(NESTED, Set.of(NESTED, NEVER, NOT_SUPPORTED, REQUIRES_NEW)), Map.entry(NEVER, Set.of(MANDATORY, NESTED, REQUIRED, REQUIRES_NEW)), Map.entry(NOT_SUPPORTED, Set.of(MANDATORY, NESTED, REQUIRED, REQUIRES_NEW)), Map.entry(REQUIRED, Set.of(NESTED, NEVER, NOT_SUPPORTED, REQUIRES_NEW)), Map.entry(REQUIRES_NEW, Set.of(NESTED, NEVER, NOT_SUPPORTED, REQUIRES_NEW)), Map.entry(SUPPORTS, Set.of(MANDATORY, NESTED, NEVER, NOT_SUPPORTED, REQUIRED, REQUIRES_NEW)));
    }

    public void execute() throws CheckException {
        this.context.getAbstractSyntaxTree(this.getCodeViewOption()).stream().filter(entity -> EShallowEntityType.TYPE == entity.getType() && "class".equals(entity.getSubtype())).forEach(this::analyzeClass);
    }

    private void analyzeClass(ShallowEntity classEntity) {
        String classPropagation = SpringIncompatibleTransactionalCheck.determinePropagation(classEntity, NOT_TRANSACTIONAL);
        if (UNRESOLVABLE.equals(classPropagation)) {
            return;
        }
        List<ShallowEntity> relevantMethods = ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive((Collection)classEntity.getChildren(), (EShallowEntityType)EShallowEntityType.METHOD).stream().filter(method -> LanguageFeatureParser.JAVA.hasExplicitVisibility(method, ETokenType.PUBLIC) && !LanguageFeatureParser.JAVA.isStatic(method)).toList();
        Map<PropagationKey, String> methodsPropagationMap = relevantMethods.stream().collect(Collectors.toMap(PropagationKey::new, method -> SpringIncompatibleTransactionalCheck.determinePropagation(method, classPropagation)));
        if (SpringIncompatibleTransactionalCheck.hasSameValues(methodsPropagationMap.values())) {
            return;
        }
        relevantMethods.forEach(method -> this.findViolationsInMethod((ShallowEntity)method, methodsPropagationMap));
    }

    private static String determinePropagation(ShallowEntity entity, String inheritedPropagation) {
        String defaultValue = NOT_TRANSACTIONAL.equals(inheritedPropagation) ? REQUIRED : inheritedPropagation;
        return SpringIncompatibleTransactionalCheck.findTransactionalAnnotation(entity).map(annotation -> SpringIncompatibleTransactionalCheck.parsePropagation(annotation).orElse(defaultValue)).orElse(inheritedPropagation);
    }

    private static Optional<String> parsePropagation(ShallowEntity annotationEntity) {
        List paramTokens = LanguageFeatureParser.JAVA.getAnnotationParameterTokens(annotationEntity);
        if (paramTokens.isEmpty()) {
            return Optional.empty();
        }
        TokenPatternMatch namedMatch = NAMED_PROPAGATION_PATTERN.findFirstMatch(paramTokens);
        if (namedMatch != null) {
            String propagation = namedMatch.groupString(0);
            if (ALL_PROPAGATION_TYPES.contains(propagation)) {
                return Optional.of(propagation);
            }
            return Optional.of(UNRESOLVABLE);
        }
        TokenPatternMatch fullMatch = UNNAMED_PROPAGATION_PATTERN.matchFully(paramTokens);
        if (fullMatch != null) {
            String potentialPropagation = fullMatch.groupString(0);
            if (ALL_PROPAGATION_TYPES.contains(potentialPropagation)) {
                return Optional.of(potentialPropagation);
            }
            return Optional.of(UNRESOLVABLE);
        }
        return Optional.empty();
    }

    private static Optional<ShallowEntity> findTransactionalAnnotation(ShallowEntity entity) {
        return LanguageFeatureParser.JAVA.getAnnotations(entity).stream().filter(a -> TRANSACTIONAL_ANNOTATION_NAMES.contains(a.getName())).findFirst();
    }

    private void findViolationsInMethod(ShallowEntity method, Map<PropagationKey, String> methodsPropagationMap) {
        String callerPropagation = methodsPropagationMap.get(new PropagationKey(method));
        if (callerPropagation == null || UNRESOLVABLE.equals(callerPropagation) || method.getChildren().isEmpty()) {
            return;
        }
        UnmodifiableList children = method.getChildren();
        int startTokenIndex = ((ShallowEntity)children.getFirst()).getStartTokenIndex();
        int endTokenIndex = ((ShallowEntity)children.getLast()).getEndTokenIndex();
        List methodTokens = method.getAllTokensOfFile().subList(startTokenIndex, endTokenIndex);
        METHOD_CALL_PATTERN.findNonOverlappingMatches(methodTokens).forEach(match -> this.checkAndReportViolation((TokenPatternMatch)match, callerPropagation, methodsPropagationMap));
    }

    private void checkAndReportViolation(TokenPatternMatch match, String callerPropagation, Map<PropagationKey, String> methodsPropagationMap) {
        int argumentCount;
        String calledMethodName = match.groupString(0);
        String calleePropagation = methodsPropagationMap.get(new PropagationKey(calledMethodName, argumentCount = CLikeCheckUtils.getMethodArguments((List)match.groupTokens(1), (int)0).size()));
        if (calleePropagation == null || UNRESOLVABLE.equals(calleePropagation)) {
            return;
        }
        Set<String> incompatiblePropagations = INCOMPATIBLE_PROPAGATION_MAP.get(callerPropagation);
        if (incompatiblePropagations != null && incompatiblePropagations.contains(calleePropagation)) {
            String message = String.format("\"%s's\" @Transactional requirement is incompatible with the one for this method", calledMethodName);
            List locationToken = match.groupTokens(0);
            this.buildFinding(message, this.buildLocation().forTokens(locationToken)).createAndStore();
        }
    }

    private static boolean hasSameValues(Collection<String> methodsPropagationList) {
        return methodsPropagationList.stream().distinct().count() <= 1L;
    }

    private record PropagationKey(String methodName, int argumentCount) {
        PropagationKey(ShallowEntity method) {
            this(method.getName(), CLikeCheckUtils.getMethodDeclarationArguments((ShallowEntity)method).size());
        }
    }
}

