/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

@Check(id="cqse-unwanted-constructor-calls", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UnwantedConstructorCallsCheck
extends CheckImplementationBase {
    private static final ETokenType[] CONSTRUCTOR_CALL_SEQUENCE = new ETokenType[]{ETokenType.NEW, ETokenType.IDENTIFIER, ETokenType.LPAREN};
    private static final EnumSet<ETokenType> FORBIDDEN_STRING_CONSTRUCTOR_PARAMETER_TOKENS = EnumSet.of(ETokenType.STRING_LITERAL, ETokenType.RPAREN);
    @CheckOption(name="Unwanted constructor names", description="All constructor names, that shall not be called.")
    private List<String> constructorNames = Arrays.asList("Boolean", "Byte", "Short", "Integer", "Long", "Float", "Double", "String");

    public void execute() throws CheckException {
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity selectedEntity : selectedEntities) {
            this.processTokens((List<IToken>)selectedEntity.ownStartTokens());
            this.processTokens((List<IToken>)selectedEntity.ownEndTokens());
        }
    }

    private void processTokens(List<IToken> tokens) throws CheckException {
        List callIndices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])CONSTRUCTOR_CALL_SEQUENCE);
        Iterator iterator = callIndices.iterator();
        while (iterator.hasNext()) {
            int callIndex = (Integer)iterator.next();
            if (UnwantedConstructorCallsCheck.isAllowedStringCall(tokens, callIndex)) continue;
            IToken typeToken = tokens.get(callIndex + 1);
            String typeName = typeToken.getText();
            for (String wrapperName : this.constructorNames) {
                if (!wrapperName.equals(typeName)) continue;
                this.buildFinding("Constructor of type `" + wrapperName + "` should not be called explicitly", this.buildLocation().forToken(typeToken)).createAndStore();
                return;
            }
        }
    }

    private static boolean isAllowedStringCall(List<IToken> tokens, int callIndex) {
        String typeName = tokens.get(callIndex + 1).getText();
        int parameterIndex = callIndex + 3;
        if (typeName.equals(String.class.getSimpleName()) && parameterIndex < tokens.size()) {
            ETokenType parameterType = tokens.get(parameterIndex).getType();
            return !FORBIDDEN_STRING_CONSTRUCTOR_PARAMETER_TOKENS.contains(parameterType);
        }
        return false;
    }
}

