/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.matlab;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

@Check(id="cqse-inconsistent-class-and-filename", languages={ELanguage.MATLAB}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class InconsistentClassAndFilenameCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "The name of the first class defined in a file should match the file name";

    public void execute() throws CheckException {
        ShallowEntity firstClass = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE).stream().filter(entity -> entity.getSubtype().equals("class")).findFirst().orElse(null);
        if (firstClass == null) {
            return;
        }
        String className = firstClass.getName();
        if (className == null) {
            return;
        }
        String fileName = UniformPathUtils.getElementName((String)this.context.getUniformPath());
        String fileNameWithoutExtension = FileSystemUtils.getFilenameWithoutExtension((String)fileName);
        if (!className.equals(fileNameWithoutExtension)) {
            this.buildFinding(CHECK_NAME, this.buildLocation().forEntityFirstLine(firstClass)).createAndStore();
        }
    }
}

