/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.plsql;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;

@Check(id="cqse-runtime-literal-concatenation", languages={ELanguage.PLSQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidLiteralConcatenationCheck
extends CheckImplementationBase {
    private static final int OPERATOR_MATCH_GROUP = 0;
    private static final String CONCAT_REGEX = "(?i)concat";
    private static final UnmodifiableSet<ETokenType> CONCATENATION_OPERATORS = CollectionUtils.asUnmodifiable(Set.of(ETokenType.CONCATENATION, ETokenType.PLUS));
    private static final TokenPattern LITERAL_CONCATENATION_PATTERN = new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.STRING_LITERAL}).sequence(new Object[]{CONCATENATION_OPERATORS}).group(0), new TokenPattern().sequence(new Object[]{CONCATENATION_OPERATORS}).group(0).sequence(new Object[]{ETokenType.STRING_LITERAL}), new TokenPattern().regex("(?i)concat").group(0).sequence(new Object[]{ETokenType.LPAREN}).sequence(new Object[]{ETokenType.STRING_LITERAL}), new TokenPattern().regex("(?i)concat").group(0).sequence(new Object[]{ETokenType.LPAREN}).skipTo(new Object[]{ETokenType.COMMA}).sequence(new Object[]{ETokenType.STRING_LITERAL})});

    public void execute() throws CheckException {
        List abstractSyntaxTree = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)abstractSyntaxTree, EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity selectedEntity : selectedEntities) {
            this.processEntity(selectedEntity);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        Set<IToken> operatorTokens = AvoidLiteralConcatenationCheck.getConcatenationOperatorsWithLiterals((UnmodifiableList<IToken>)tokens);
        this.createFindingsForOperators(operatorTokens);
    }

    private static Set<IToken> getConcatenationOperatorsWithLiterals(UnmodifiableList<IToken> tokens) {
        List matches = LITERAL_CONCATENATION_PATTERN.findAll(tokens);
        if (matches.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<IToken> operatorTokens = new HashSet<IToken>();
        for (TokenPatternMatch match : matches) {
            operatorTokens.add((IToken)match.groupTokens(0).get(0));
        }
        return operatorTokens;
    }

    private void createFindingsForOperators(Set<IToken> operatorTokens) {
        for (IToken operatorToken : operatorTokens) {
            this.buildFinding("Avoid concatenation of literals using `" + operatorToken.getText() + "`  at runtime.", this.buildLocation().forToken(operatorToken)).createAndStore();
        }
    }
}

