/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.plsql;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-case-rather-than-decode", languages={ELanguage.PLSQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UseCaseRatherThanDecodeCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"SQL".equals(statement.getSubtype()) || !"select".equals(statement.getName())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        TokenPattern decodePattern = new TokenPattern().regex("^(?i)decode$").group(0).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false);
        TokenPatternMatch match = decodePattern.findFirstMatch((List)entity.ownStartTokens());
        if (match != null) {
            IToken decodeToken = (IToken)match.groupTokens(0).get(0);
            IToken selectToken = (IToken)entity.ownStartTokens().get(0);
            this.buildFinding("Avoid using `" + decodeToken.getText() + "` in `" + selectToken.getText() + "` statement.", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

