/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.matlab;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.simulink.matlab.SimulinkMatlabCheckUtils;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.na_0021", languages={ELanguage.SIMULINK})
public class SimulinkStringInMatlabFunctionBlockCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider using enumerations instead of character vectors.");

    public void execute() throws CheckException {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkMatlabCheckUtils.listMatlabFunctionBlocks(model)) {
            for (String script : StateflowUtils.extractMatlabScriptsFromBlock((SimulinkBlock)block)) {
                this.checkStringLiteralsInScript(script, this.context.buildLocation().forSimulinkBlock(block));
            }
        }
        for (StateflowState stateflowMatlabFunctionState : StateflowUtils.getStateflowMatlabFunctions((SimulinkModel)model)) {
            String script = StateflowUtils.extractMatlabScriptFromStateflowState((StateflowState)stateflowMatlabFunctionState);
            this.checkStringLiteralsInScript(script, this.context.buildLocation().forStateflowNode((StateflowNodeBase)stateflowMatlabFunctionState));
        }
    }

    private void checkStringLiteralsInScript(String script, QualifiedNameLocation scriptLocation) {
        List tokens = ScannerUtils.getTokens((String)script, (ELanguage)ELanguage.MATLAB, (String)this.context.getUniformPath());
        int tokenIndex = TokenStreamUtils.firstTokenOfTypeSequence((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.EQ, ETokenType.STRING_LITERAL});
        if (tokenIndex != -1) {
            int line = ((IToken)tokens.get(tokenIndex + 1)).getLineNumber() + 1;
            this.buildFinding("String literal in Matlab function block (first in line " + line + ")", (ElementLocation)scriptLocation).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

