/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.simulink.SimulinkNumberPerLevelCheckBase;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.simulink.blocks-per-level", languages={ELanguage.SIMULINK})
public class SimulinkBlocksPerLevelCheck
extends SimulinkNumberPerLevelCheckBase {
    @CheckOption(name="Maximum number of blocks per level", description="The maximum number of blocks that are allowed on each level of the model")
    private int blocksPerLevelThreshold = 25;
    @CheckOption(name="Maximum number of blocks on root level", description="The maximum number of blocks that are allowed on root level of the model")
    private int blocksAtRootLevelThreshold = 10;

    @Override
    public String getCountObjectName() {
        return "blocks";
    }

    @Override
    public int getObjectsPerLevelThreshold() {
        return this.blocksPerLevelThreshold;
    }

    @Override
    public int getRootLevelThreshold() {
        return this.blocksAtRootLevelThreshold;
    }

    @Override
    public int determineNumberOfObjects(SimulinkBlock block) {
        return (int)block.getSubBlocks().stream().filter(subBlock -> !SimulinkUtils.isCommentedBlock((SimulinkBlock)subBlock)).count();
    }
}

