/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPropagatedSignalLabels;
import org.conqat.lib.simulink.model.datahandler.GotoFromResolver;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jspecify.annotations.Nullable;

@Check(id="cqse.jmaab.jc_0602", languages={ELanguage.SIMULINK})
public class SimulinkElementNamesConsistencyCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the block's name or its signal name to match.");
    private static final FindingPropertyList RECOMMENDED_ACTION_GOTO_TAG = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the block's goto tag or its signal name to match.");
    private static final FindingPropertyList RECOMMENDED_ACTION_SUBSYSTEM_OUTPORT = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the Subsystem block's output port name or its signal name to match.");
    private static final FindingPropertyList RECOMMENDED_ACTION_SUBSYSTEM_INPORT = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the Subsystem block's input port name or its signal name to match.");
    private static final String FINDING_MESSAGE_FORMAT = "{0}: {1} is inconsistent with {2} signal: {3}";
    private static final String FINDING_MESSAGE_FORMAT_GOTO_FROM = "Signal name `{0}` differs from `{1}` on the other side of goto/from with tag `{2}`";
    private static final String INPUT_DIRECTION = "input";
    private static final String OUTPUT_DIRECTION = "output";

    public void execute() {
        Optional optionalSimulinkModel = this.context.getSimulinkContext().getSimulinkModelForModelFile();
        if (optionalSimulinkModel.isEmpty()) {
            return;
        }
        SimulinkModel model = (SimulinkModel)optionalSimulinkModel.get();
        GotoFromResolver gotoFromResolver = new GotoFromResolver((SimulinkBlock)model);
        SimulinkPropagatedSignalLabels propagatedSignalLabels = this.context.getSimulinkContext().getPropagatedSimulinkSignalLabelsForFile().orElse(null);
        for (SimulinkLine simulinkLine : model.getContainedLinesRecursively(false, false)) {
            SimulinkInPort dstPort;
            String signalName = SimulinkElementNamesConsistencyCheck.signalNameFrom(simulinkLine, propagatedSignalLabels);
            if (signalName == null) continue;
            SimulinkOutPort srcPort = simulinkLine.getSrcPort();
            if (srcPort != null) {
                SimulinkBlock srcBlock = srcPort.getBlock();
                this.checkSignalNamesInRelevantBlockTypes(srcBlock, signalName, INPUT_DIRECTION, gotoFromResolver);
                this.checkSubSystemBlocks(srcBlock, signalName, propagatedSignalLabels);
            }
            if ((dstPort = simulinkLine.getDstPort()) == null) continue;
            SimulinkBlock dstBlock = dstPort.getBlock();
            this.checkSignalNamesInRelevantBlockTypes(dstBlock, signalName, OUTPUT_DIRECTION, gotoFromResolver);
            this.checkSubSystemBlocks(dstBlock, signalName, propagatedSignalLabels);
        }
    }

    private static String signalNameFrom(SimulinkLine simulinkLine, @Nullable SimulinkPropagatedSignalLabels propagatedSignalLabels) {
        SimulinkOutPort srcPort = simulinkLine.getSrcPort();
        if (srcPort == null) {
            return null;
        }
        String showPropagatedParameter = srcPort.getParameter("ShowPropagatedSignals");
        String propagatedSignalName = SimulinkUtils.getPropagatedSignalName((SimulinkOutPort)srcPort, (SimulinkPropagatedSignalLabels)propagatedSignalLabels);
        if (propagatedSignalName != null && "on".equals(showPropagatedParameter) && !propagatedSignalName.isEmpty()) {
            return propagatedSignalName;
        }
        String lineName = simulinkLine.getName().orElse(null);
        if (lineName != null && lineName.startsWith("<") && lineName.endsWith(">")) {
            return lineName.substring(1, lineName.length() - 1);
        }
        return lineName;
    }

    private void checkSubSystemBlocks(SimulinkBlock block, String signalName, SimulinkPropagatedSignalLabels propagatedSignalLabels) {
        if (SimulinkElementNamesConsistencyCheck.isReusableSubsystem(block) || !block.isOfType("SubSystem")) {
            return;
        }
        for (SimulinkInPort inPort : block.getInPorts()) {
            SimulinkLine line = inPort.getLine();
            if (line == null || !line.getName().isPresent() || !((String)line.getName().get()).equals(signalName)) continue;
            this.checkSubsystemInportAgainstSignal(block, signalName, propagatedSignalLabels);
            return;
        }
        for (SimulinkOutPort outPort : block.getOutPorts()) {
            for (SimulinkLine line : outPort.getLines()) {
                if (!line.getName().isPresent() || !((String)line.getName().get()).equals(signalName)) continue;
                String propagatedSignal = SimulinkUtils.getPropagatedSignalName((SimulinkOutPort)outPort, (SimulinkPropagatedSignalLabels)propagatedSignalLabels);
                this.checkSubsystemOutportAgainstSignal(block, propagatedSignal, signalName, propagatedSignalLabels);
            }
        }
    }

    private void checkSubsystemInportAgainstSignal(SimulinkBlock block, String externalSignal, SimulinkPropagatedSignalLabels propagatedSignalLabels) {
        for (SimulinkBlock inport : block.getSubBlocks()) {
            if (!SimulinkUtils.isInport((SimulinkBlock)inport)) continue;
            for (SimulinkOutPort outport : inport.getOutPorts()) {
                String subsystemBlockInportName;
                String propagatedSignal;
                SimulinkLine line = outport.getAnyLine();
                if (line == null || StringUtils.isEmpty((String)(propagatedSignal = SimulinkUtils.getPropagatedSignalName((SimulinkOutPort)outport, (SimulinkPropagatedSignalLabels)propagatedSignalLabels))) || !propagatedSignal.equals(externalSignal) || StringUtils.isEmpty((String)(subsystemBlockInportName = inport.getName())) || subsystemBlockInportName.equals(propagatedSignal)) continue;
                String message = MessageFormat.format(FINDING_MESSAGE_FORMAT, "Subsystem block", MarkupUtils.formatAsSourceCode((String)block.getNamePretty()), INPUT_DIRECTION, MarkupUtils.formatAsSourceCode((String)externalSignal));
                this.buildFinding(message, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_SUBSYSTEM_INPORT).createAndStore();
            }
        }
    }

    private void checkSubsystemOutportAgainstSignal(SimulinkBlock block, String propagatedSubsystemSignal, String externalSignal, SimulinkPropagatedSignalLabels propagatedSignalLabels) {
        if (StringUtils.isEmpty((String)propagatedSubsystemSignal)) {
            return;
        }
        for (SimulinkLine line : block.getContainedLines()) {
            if (!propagatedSubsystemSignal.equals(SimulinkElementNamesConsistencyCheck.signalNameFrom(line, propagatedSignalLabels))) continue;
            SimulinkBlock outportBlock = line.getDstPort().getBlock();
            String subsystemBlockOutportName = outportBlock.getName();
            if (!SimulinkUtils.isOutport((SimulinkBlock)outportBlock) || StringUtils.isEmpty((String)subsystemBlockOutportName) || subsystemBlockOutportName.equals(externalSignal)) continue;
            String message = MessageFormat.format(FINDING_MESSAGE_FORMAT, "Subsystem block", MarkupUtils.formatAsSourceCode((String)block.getNamePretty()), OUTPUT_DIRECTION, MarkupUtils.formatAsSourceCode((String)externalSignal));
            this.buildFinding(message, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_SUBSYSTEM_OUTPORT).createAndStore();
        }
    }

    private static boolean isReusableSubsystem(SimulinkBlock block) {
        String referencedSubsystem = block.getParameter("ReferencedSubsystem");
        return block.isOfType("SubSystem") && !StringUtils.isEmpty((String)referencedSubsystem) || block.isOfType("ModelReference");
    }

    private void checkSignalNamesInRelevantBlockTypes(SimulinkBlock block, String signalName, String signalDirection, GotoFromResolver gotoFromResolver) {
        if (SimulinkUtils.isInport((SimulinkBlock)block) || SimulinkUtils.isOutport((SimulinkBlock)block)) {
            this.checkBlockName(block, signalName, signalDirection);
        } else if (SimulinkUtils.isFromBlock((SimulinkBlock)block)) {
            this.checkFromBlock(block, signalName, gotoFromResolver);
        }
    }

    private void checkBlockName(SimulinkBlock block, String signalName, String signalDirection) {
        String blockName = block.getName();
        if (StringUtils.isEmpty((String)blockName) || StringUtils.isEmpty((String)signalName)) {
            return;
        }
        if (blockName.equals(signalName)) {
            return;
        }
        String findingsMessage = MessageFormat.format(FINDING_MESSAGE_FORMAT, "Block", MarkupUtils.formatAsSourceCode((String)block.getNamePretty()), signalDirection, MarkupUtils.formatAsSourceCode((String)signalName));
        this.buildFinding(findingsMessage, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
    }

    private void checkFromBlock(SimulinkBlock block, String signalName, GotoFromResolver gotoFromResolver) {
        List oppositeLines = gotoFromResolver.getConnectedGotoBlocks(block).stream().map(SimulinkBlock::getInLines).flatMap(Collection::stream).toList();
        for (SimulinkLine oppositeLine : oppositeLines) {
            oppositeLine.getName().ifPresent(oppositeSignalName -> {
                if (!signalName.equals(oppositeSignalName)) {
                    this.buildFinding(MessageFormat.format(FINDING_MESSAGE_FORMAT_GOTO_FROM, signalName, oppositeSignalName, block.getParameter("GotoTag")), (ElementLocation)this.buildLocation().forSimulinkLine(oppositeLine)).addFindingProperties(RECOMMENDED_ACTION_GOTO_TAG).createAndStore();
                }
            });
        }
    }
}

