/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import eu.cqse.check.simulink.simulink.utils.ExternalConfigSetUtils;
import org.conqat.lib.simulink.builder.SimulinkConfigSet;
import org.conqat.lib.simulink.model.SimulinkModel;

@Check(id="cqse.jmaab.jc_0751", languages={ELanguage.SIMULINK}, phases={SimulinkDataDictionaryLoadingPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkPreventBacktrackingCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Do not use connective junctions to separate complex conditions. Please set the parameter `Unexpected backtracking` to `error`.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null || model.isLibraryModel()) {
            return;
        }
        SimulinkConfigSet externalConfigSet = ExternalConfigSetUtils.getExternalConfigSet(model, this.context).orElse(null);
        String value = ExternalConfigSetUtils.getParameter(model, externalConfigSet, "SFUnexpectedBacktrackingDiag").orElse(null);
        if (!"Error".equalsIgnoreCase(value)) {
            this.context.buildFinding(String.format("`Unexpected backtracking` configuration is set to `%s`", value), this.buildLocation().forElement()).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

