/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sql_like;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.sql_like.SqlLikeCustomCheckUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-no-select-star", languages={ELanguage.PLSQL, ELanguage.ESQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoSelectStarCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List<ShallowEntity> selectedEntities = SqlLikeCustomCheckUtils.selectStatementsOrCursorsPerformingSelect(this.context.getRootEntity(this.getCodeViewOption()));
        for (ShallowEntity entity : selectedEntities) {
            this.processEntity(entity);
        }
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType(Collections.singletonList(this.context.getRootEntity(this.getCodeViewOption())), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!statement.getSubtype().equals("select")) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        List<IToken> tokens = SqlLikeCustomCheckUtils.extractSelect(entity);
        if (TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.SELECT, ETokenType.MULT})) {
            if (NoSelectStarCheck.isSelectIntoRowtypeVariable(tokens, entity)) {
                return;
            }
            this.buildFinding("Usage of `SELECT * FROM xxx` should be avoided", this.buildLocation().forToken(tokens.get(1))).createAndStore();
        }
    }

    private static boolean isSelectIntoRowtypeVariable(List<IToken> tokens, ShallowEntity entity) {
        int intoIndex = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.INTO);
        if (intoIndex == -1) {
            return false;
        }
        List<String> targetVariables = NoSelectStarCheck.extractVariableNamesAfterIntoClause(tokens, intoIndex);
        if (targetVariables.isEmpty()) {
            return false;
        }
        return NoSelectStarCheck.variablesAreDeclaredAsRowType(entity, targetVariables);
    }

    private static List<String> extractVariableNamesAfterIntoClause(List<IToken> tokens, int intoIndex) {
        int fromIndex = TokenStreamUtils.firstTokenMatching(tokens, (int)intoIndex, (ITokenMatcher)ETokenType.FROM);
        if (fromIndex == -1) {
            fromIndex = tokens.size();
        }
        List<IToken> tokensBetweenIntoAndFrom = tokens.subList(intoIndex + 1, fromIndex);
        List variableTokens = TokenStreamUtils.splitWithNesting(tokensBetweenIntoAndFrom, (ETokenType)ETokenType.COMMA, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        ArrayList<String> variableNames = new ArrayList<String>();
        for (List group : variableTokens) {
            if (group.isEmpty()) continue;
            variableNames.add(((IToken)group.getFirst()).getText());
        }
        return variableNames;
    }

    private static boolean variablesAreDeclaredAsRowType(ShallowEntity entity, List<String> targetVariables) {
        ShallowEntity current = ShallowEntityTraversalUtils.getPreviousEntity((ShallowEntity)entity);
        ArrayList<ShallowEntity> attributesInBlock = new ArrayList<ShallowEntity>();
        boolean hasSeenMethod = false;
        while (current != null && current.getType() != EShallowEntityType.TYPE && current.getType() != EShallowEntityType.MODULE) {
            if (current.getType() == EShallowEntityType.METHOD) {
                if (hasSeenMethod) break;
                hasSeenMethod = true;
            }
            if (current.getType() == EShallowEntityType.ATTRIBUTE) {
                attributesInBlock.add(current);
            }
            current = ShallowEntityTraversalUtils.getPreviousEntity((ShallowEntity)current);
        }
        return attributesInBlock.stream().anyMatch(attribute -> targetVariables.stream().anyMatch(variable -> NoSelectStarCheck.hasRowtypeInDeclaration(attribute, variable)));
    }

    private static boolean hasRowtypeInDeclaration(ShallowEntity varDeclaration, String variableName) {
        UnmodifiableList declarationTokens = varDeclaration.includedTokens();
        if (declarationTokens.size() < 3 || !((IToken)declarationTokens.getFirst()).getText().equals(variableName)) {
            return false;
        }
        for (int i = 0; i < declarationTokens.size() - 1; ++i) {
            if (i + 1 == declarationTokens.size()) {
                return false;
            }
            if (((IToken)declarationTokens.get(i)).getType() != ETokenType.ATTRIBUTE_INDICATOR || ((IToken)declarationTokens.get(i + 1)).getType() != ETokenType.ROWTYPE) continue;
            return true;
        }
        return false;
    }
}

