/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sqlscript;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.sqlscript.sqlstatement.SqlQuery;
import eu.cqse.check.sqlscript.sqlstatement.SqlStatement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class SqlStatementCheckBase
extends CheckImplementationBase {
    private final Set<String> excludeStatements = new HashSet<String>();

    public void initialize() {
        for (String exclude : this.excludeStatements()) {
            this.excludeStatements.add(exclude.toLowerCase());
        }
    }

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"SQL".equals(statement.getSubtype()) || this.isExcluded(statement)) continue;
            this.processEntity(statement);
        }
    }

    private boolean isExcluded(ShallowEntity entity) {
        return this.excludeStatements.contains(entity.getName());
    }

    protected List<String> excludeStatements() {
        return Collections.emptyList();
    }

    protected void processEntity(ShallowEntity entity) throws CheckException {
        this.checkSqlStatement(new SqlStatement(entity));
    }

    protected abstract void checkSqlStatement(SqlStatement var1) throws CheckException;

    protected void createFinding(String message, SqlQuery query) throws CheckException {
        this.buildFinding(message, this.buildLocation().betweenTokens(query.getBeginToken(), query.getEndToken())).createAndStore();
    }
}

