/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.vb;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-select-must-have-default", languages={ELanguage.VB}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SelectMustHaveDefaultCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List allEntities = ShallowEntityTraversalUtils.getAllEntities((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()));
        for (ShallowEntity entity : allEntities) {
            if (!"select".equals(entity.getSubtype())) continue;
            this.processEntity(entity);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.includedTokens();
        CCSMAssert.isFalse((boolean)tokens.isEmpty(), (String)"Error in SelectMustHaveDefaultCheck: The entity for the select statement did not have any tokens.");
        if (!SelectMustHaveDefaultCheck.hasDefaultStatement(entity)) {
            this.buildFinding("switch/case statements must have `case else`", this.buildLocation().betweenTokens((IToken)tokens.get(0), (IToken)tokens.get(tokens.size() - 1))).createAndStore();
        }
    }

    private static boolean hasDefaultStatement(ShallowEntity entity) {
        UnmodifiableList tokens = entity.includedTokens();
        for (int i = 0; i < tokens.size() - 1; ++i) {
            if (((IToken)tokens.get(i)).getType() != ETokenType.CASE || ((IToken)tokens.get(i + 1)).getType() != ETokenType.ELSE) continue;
            return true;
        }
        return false;
    }
}

