/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import java.util.regex.Pattern;

public class CppIntegerLiteralParser {
    private static final String DECIMAL_LITERAL_PATTERN = "[0-9']+";
    private static final String HEX_LITERAL_PATTERN = "0x[0-9a-f']+";
    private static final String OCTAL_LITERAL_PATTERN = "0[0-8']+";
    private static final String BINARY_LITERAL_PATTERN = "0b[01']+";
    private static final String INTEGER_SUFFIX_PATTERN = "(u|l|ll|ul|ull|lu|llu)?";
    private static final Pattern INTEGER_LITERAL_PATTERN = Pattern.compile("([0-9']+|0x[0-9a-f']+|0[0-8']+|0b[01']+)(u|l|ll|ul|ull|lu|llu)?", 2);

    public static boolean isInteger(String literal) {
        return INTEGER_LITERAL_PATTERN.matcher(literal).matches();
    }

    public static int parse(String literal) {
        if (!CppIntegerLiteralParser.isInteger(literal)) {
            throw new NumberFormatException(literal + " is not a valid C++ integer literal");
        }
        int base = 10;
        if (literal.startsWith("0x") || literal.startsWith("0X")) {
            base = 16;
            literal = literal.substring(2);
        } else if (literal.startsWith("0b") || literal.startsWith("0B")) {
            base = 2;
            literal = literal.substring(2);
        } else if (literal.startsWith("0")) {
            base = 8;
        }
        literal = CppIntegerLiteralParser.removeInvalidCharacters(literal);
        if (Long.parseLong(literal, base) > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(literal, base);
    }

    private static String removeInvalidCharacters(String literal) {
        literal = literal.replace("'", "");
        literal = literal.replace("u", "");
        literal = literal.replace("l", "");
        literal = literal.replace("U", "");
        literal = literal.replace("L", "");
        return literal;
    }
}

