/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class NestingAwareTokenIterator
implements Iterator<IToken> {
    protected final List<IToken> tokens;
    protected int currentPosition;
    protected final List<ETokenType> openingTypes;
    protected final List<ETokenType> closingTypes;
    protected boolean isClosingToken = false;
    private final int[] nestingDepths;

    public NestingAwareTokenIterator(List<IToken> tokens, int startPosition, List<ETokenType> openingTypes, List<ETokenType> closingTypes) {
        CCSMAssert.isTrue((openingTypes.size() == closingTypes.size() ? 1 : 0) != 0, (String)"Open and close tokens must have the same size");
        this.tokens = tokens;
        this.currentPosition = startPosition;
        this.openingTypes = openingTypes;
        this.closingTypes = closingTypes;
        this.nestingDepths = new int[openingTypes.size()];
    }

    @Override
    public boolean hasNext() {
        return this.currentPosition < this.tokens.size();
    }

    @Override
    public IToken next() {
        if (this.currentPosition >= this.tokens.size()) {
            throw new NoSuchElementException("The iterator is exhausted");
        }
        IToken token = this.tokens.get(this.currentPosition);
        ++this.currentPosition;
        this.updateNestingInfo(token);
        return token;
    }

    private void updateNestingInfo(IToken token) {
        OptionalInt closeIndex;
        this.isClosingToken = false;
        ETokenType type = token.getType();
        int openIndex = this.openingTypes.indexOf(type);
        if (openIndex != -1) {
            int n = openIndex;
            this.nestingDepths[n] = this.nestingDepths[n] + 1;
        }
        if ((closeIndex = IntStream.range(0, this.closingTypes.size()).filter(index -> type == this.closingTypes.get(index) && this.nestingDepths[index] > 0).findFirst()).isPresent()) {
            int n = closeIndex.getAsInt();
            this.nestingDepths[n] = this.nestingDepths[n] - 1;
            this.isClosingToken = true;
        }
    }

    public boolean isTopLevel() {
        return this.getNestingDepth() <= 0;
    }

    public int getNestingDepth() {
        int sum = 0;
        for (int value : this.nestingDepths) {
            sum += value;
        }
        if (this.isClosingToken) {
            ++sum;
        }
        return sum;
    }

    public int getCurrentIndex() {
        return this.currentPosition - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator does not support removal of elements");
    }
}

