/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.framework;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class ConcatenatingNameResolver
implements INameResolver {
    private static final String SEPARATOR = " ";
    private final Collection<? extends INameResolver> resolvers;

    public ConcatenatingNameResolver(Collection<? extends INameResolver> resolvers) {
        Objects.requireNonNull(resolvers, "resolvers");
        if (resolvers.isEmpty()) {
            throw new IllegalArgumentException("resolvers must not be empty");
        }
        this.resolvers = new ArrayList<INameResolver>(resolvers);
    }

    @Override
    public String resolveName(ParserState<?> state, List<IToken> tokens, int startOffset, boolean extractStringContent) {
        return this.resolvers.stream().map(resolver -> resolver.resolveName(state, tokens, startOffset, extractStringContent)).collect(Collectors.joining(SEPARATOR));
    }

    public String toString() {
        return "concatenating: " + String.valueOf(this.resolvers);
    }
}

