/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.framework;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.CreateNodeRecognizer;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.NotPreconditionRecognizer;
import eu.cqse.check.framework.shallowparser.framework.OptionalNestedRecognizer;
import eu.cqse.check.framework.shallowparser.framework.ParseUntilRecognizer;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.PreconditionRecognizer;
import eu.cqse.check.framework.shallowparser.framework.RecognizerUtils;
import eu.cqse.check.framework.shallowparser.framework.RepeatedRecognizer;
import eu.cqse.check.framework.shallowparser.framework.SequenceRecognizer;
import eu.cqse.check.framework.shallowparser.framework.SkipForwardRecognizer;
import eu.cqse.check.framework.shallowparser.framework.SkipToRecognizer;
import eu.cqse.check.framework.shallowparser.framework.StrictSubParseUntilRecognizer;
import eu.cqse.check.framework.shallowparser.framework.SubRecognizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class RecognizerBase<STATE extends Enum<STATE>> {
    public static final int NO_MATCH = -1;
    protected final List<RecognizerBase<STATE>> tailRecognizers = new ArrayList<RecognizerBase<STATE>>();

    public RecognizerBase<STATE> sequence(ITokenMatcher ... matchTerms) {
        return this.appendRecognizer(new SequenceRecognizer(List.of(matchTerms), false));
    }

    public RecognizerBase<STATE> sequenceBefore(ITokenMatcher ... matchTerms) {
        return this.appendRecognizer(new SequenceRecognizer(List.of(matchTerms), true));
    }

    public RecognizerBase<STATE> repeated(ITokenMatcher ... matchTerms) {
        return this.appendRecognizer(new RepeatedRecognizer(List.of(matchTerms), 0, Integer.MAX_VALUE));
    }

    public RecognizerBase<STATE> repeatedAtLeastOnce(ITokenMatcher ... matchTerms) {
        return this.appendRecognizer(new RepeatedRecognizer(List.of(matchTerms), 1, Integer.MAX_VALUE));
    }

    public RecognizerBase<STATE> subRecognizer(RecognizerBase<STATE> sub, int minRepetitions, int maxRepetitions) {
        return this.appendRecognizer(new SubRecognizer<STATE>(sub, minRepetitions, maxRepetitions));
    }

    public RecognizerBase<STATE> subRecognizer(RecognizerBase<STATE> sub) {
        return this.subRecognizer(sub, 1, 1);
    }

    public RecognizerBase<STATE> optionalSubRecognizer(RecognizerBase<STATE> sub) {
        return this.subRecognizer(sub, 0, 1);
    }

    public RecognizerBase<STATE> repeatedSubRecognizer(RecognizerBase<STATE> sub) {
        return this.subRecognizer(sub, 0, Integer.MAX_VALUE);
    }

    public RecognizerBase<STATE> preCondition(RecognizerBase<STATE> sub) {
        return this.appendRecognizer(new PreconditionRecognizer<STATE>(sub));
    }

    public RecognizerBase<STATE> notPreCondition(RecognizerBase<STATE> sub) {
        return this.appendRecognizer(new NotPreconditionRecognizer<STATE>(sub));
    }

    public RecognizerBase<STATE> optional(ITokenMatcher ... matchTermSequence) {
        return this.appendRecognizer(new RepeatedRecognizer(List.of(matchTermSequence), 0, 1));
    }

    public RecognizerBase<STATE> skipForward(int numberOfTokensToSkip) {
        return this.appendRecognizer(new SkipForwardRecognizer(numberOfTokensToSkip));
    }

    public RecognizerBase<STATE> skipAfter(ITokenMatcher ... matchTerms) {
        return this.appendRecognizer(new SkipToRecognizer(List.of(matchTerms), false));
    }

    public RecognizerBase<STATE> skipBefore(ITokenMatcher ... matchTerms) {
        return this.appendRecognizer(new SkipToRecognizer(List.of(matchTerms), true));
    }

    public RecognizerBase<STATE> skipNested(ETokenType open, ETokenType close) {
        return this.skipNested(open, close, null);
    }

    public RecognizerBase<STATE> skipNested(ETokenType open, ETokenType close, @Nullable RecognizerBase<STATE> subRecognizer) {
        return this.appendRecognizer(new OptionalNestedRecognizer<STATE>(open, close, subRecognizer));
    }

    public RecognizerBase<STATE> skipWhile(final ITokenMatcher matcher) {
        return this.appendRecognizer(new RecognizerBase<STATE>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            protected int matchesLocally(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
                while (startOffset < tokens.size() && matcher.matches(tokens.get(startOffset))) {
                    ++startOffset;
                }
                return startOffset;
            }

            @Override
            protected String getRecognizerStringRepresentation() {
                return "skipWhile(" + matcher.humanReadable() + ")";
            }
        });
    }

    public RecognizerBase<STATE> skipAfterWithNesting(ITokenMatcher matchTerm, ETokenType open, ETokenType close) {
        return this.skipAfterWithNesting(matchTerm, open, close, null);
    }

    public RecognizerBase<STATE> skipAfterWithNesting(ITokenMatcher matchTerm, ETokenType open, ETokenType close, @Nullable RecognizerBase<STATE> subRecognizer) {
        return this.skipAfterWithNesting(matchTerm, Collections.singletonList(open), Collections.singletonList(close), subRecognizer);
    }

    public RecognizerBase<STATE> skipAfterWithNesting(ITokenMatcher matchTerm, List<ETokenType> openingTokens, List<ETokenType> closingTokens) {
        return this.skipAfterWithNesting(matchTerm, openingTokens, closingTokens, null);
    }

    public RecognizerBase<STATE> skipAfterWithNesting(ITokenMatcher matchTerm, List<ETokenType> openingTokens, List<ETokenType> closingTokens, @Nullable RecognizerBase<STATE> subRecognizer) {
        return this.skipWithNesting(List.of(matchTerm), openingTokens, closingTokens, subRecognizer, false);
    }

    public RecognizerBase<STATE> skipBeforeWithNesting(ITokenMatcher matchTerm, ETokenType open, ETokenType close) {
        return this.skipBeforeWithNesting(matchTerm, Collections.singletonList(open), Collections.singletonList(close), null);
    }

    public RecognizerBase<STATE> skipBeforeWithNesting(ITokenMatcher matchTerm, ETokenType open1, ETokenType close1, ETokenType open2, ETokenType close2, @Nullable RecognizerBase<STATE> subRecognizer) {
        return this.skipBeforeWithNesting(matchTerm, Arrays.asList(open1, open2), Arrays.asList(close1, close2), subRecognizer);
    }

    public RecognizerBase<STATE> skipBeforeWithNesting(ITokenMatcher matchTerm, List<ETokenType> openingTokens, List<ETokenType> closingTokens) {
        return this.skipBeforeWithNesting(matchTerm, openingTokens, closingTokens, null);
    }

    public RecognizerBase<STATE> skipBeforeWithNesting(ITokenMatcher matchTerm, List<ETokenType> openingTokens, List<ETokenType> closingTokens, @Nullable RecognizerBase<STATE> subRecognizer) {
        return this.skipWithNesting(List.of(matchTerm), openingTokens, closingTokens, subRecognizer, true);
    }

    public RecognizerBase<STATE> skipBeforeWithNesting(List<ITokenMatcher> matchSequence, List<ETokenType> openingTokens, List<ETokenType> closingTokens, @Nullable RecognizerBase<STATE> subRecognizer) {
        return this.skipWithNesting(matchSequence, openingTokens, closingTokens, subRecognizer, true);
    }

    private RecognizerBase<STATE> skipWithNesting(List<ITokenMatcher> matchSequence, List<ETokenType> openingTokens, List<ETokenType> closingTokens, @Nullable RecognizerBase<STATE> subRecognizer, boolean reportStartOfEndMatch) {
        CCSMAssert.isTrue((openingTokens.size() == closingTokens.size() ? 1 : 0) != 0, (String)"There must be as many opening tokens as closing ones!");
        SkipToRecognizer<STATE> skipper = new SkipToRecognizer<STATE>(matchSequence, reportStartOfEndMatch);
        for (int i = 0; i < openingTokens.size(); ++i) {
            skipper.addNestingTokens(openingTokens.get(i), closingTokens.get(i));
        }
        skipper.setSubRecognizer(subRecognizer);
        return this.appendRecognizer(skipper);
    }

    public RecognizerBase<STATE> markStart() {
        return this.appendRecognizer(new RecognizerBase<STATE>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int matchesLocally(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
                parserState.markReferencePosition(startOffset);
                return startOffset;
            }

            @Override
            protected String getRecognizerStringRepresentation() {
                return "markStart";
            }
        });
    }

    public RecognizerBase<STATE> createNode(@NonNull EShallowEntityType type, @NonNull String subtype) {
        return this.createNode(type, INameResolver.ofString(subtype));
    }

    public RecognizerBase<STATE> createNode(@NonNull EShallowEntityType type, @NonNull INameResolver subtype) {
        return this.createNode(type, subtype, INameResolver.noName());
    }

    public RecognizerBase<STATE> createNode(@NonNull EShallowEntityType type, @NonNull String subtype, @NonNull INameResolver name) {
        return this.createNode(type, INameResolver.ofString(subtype), name);
    }

    public RecognizerBase<STATE> createNode(@NonNull EShallowEntityType type, @NonNull INameResolver subtype, @NonNull String name) {
        return this.createNode(type, subtype, INameResolver.ofString(name));
    }

    public RecognizerBase<STATE> createNode(@NonNull EShallowEntityType type, @NonNull String subtype, @NonNull String name) {
        return this.createNode(type, INameResolver.ofString(subtype), name);
    }

    public RecognizerBase<STATE> createNode(@NonNull EShallowEntityType type, @NonNull INameResolver subtype, @NonNull INameResolver name) {
        return this.appendRecognizer(new CreateNodeRecognizer(type, subtype, name, 0));
    }

    public RecognizerBase<STATE> createNode(@NonNull EShallowEntityType type, @NonNull INameResolver subtype, @NonNull INameResolver name, int offset) {
        return this.appendRecognizer(new CreateNodeRecognizer(type, subtype, name, offset));
    }

    public void endNode() {
        this.appendRecognizer(new RecognizerBase<STATE>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int matches(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
                parserState.endNode(false);
                return startOffset;
            }

            @Override
            protected String getRecognizerStringRepresentation() {
                return "endNode";
            }
        });
    }

    public void endNodeWithName(final INameResolver name) {
        this.appendRecognizer(new RecognizerBase<STATE>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int matches(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
                parserState.setNodeName(RecognizerUtils.resolveShallowEntityName(tokens, parserState, startOffset, name, CreateNodeRecognizer.shouldExtractStringContentFromName(parserState.getCurrentEntityType())));
                parserState.endNode(false);
                return startOffset;
            }

            @Override
            protected String getRecognizerStringRepresentation() {
                return "endNodeWithName[" + String.valueOf(name) + "]";
            }
        });
    }

    public void endNodeWithName(String name) {
        this.endNodeWithName(INameResolver.ofString(name));
    }

    public void endNodeWithContinuation() {
        this.endNodeWithContinuation(null);
    }

    public void endNodeWithContinuation(STATE forcedNextState) {
        this.appendRecognizer(new RecognizerBase<STATE>(this, (Enum)forcedNextState){
            final /* synthetic */ Enum val$forcedNextState;
            {
                this.val$forcedNextState = enum_;
                Objects.requireNonNull(this$0);
            }

            @Override
            public int matches(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
                parserState.endNode(true);
                if (this.val$forcedNextState != null) {
                    parserState.setForcedNextState(this.val$forcedNextState);
                }
                return startOffset;
            }

            @Override
            protected String getRecognizerStringRepresentation() {
                return "endNodeWithContinuation";
            }
        });
    }

    public RecognizerBase<STATE> parseUntil(STATE state) {
        return this.appendRecognizer(new ParseUntilRecognizer<STATE>(state, false));
    }

    public RecognizerBase<STATE> parseUntilOrEof(STATE state) {
        return this.appendRecognizer(new ParseUntilRecognizer<STATE>(state, true));
    }

    public RecognizerBase<STATE> parseStrictlyUntil(STATE state) {
        return this.appendRecognizer(new StrictSubParseUntilRecognizer<STATE>(state));
    }

    public RecognizerBase<STATE> parseOnce(STATE state) {
        return this.parseMultiple(state, 1, 1);
    }

    public RecognizerBase<STATE> parseMultiple(STATE state) {
        return this.parseMultiple(state, 0, Integer.MAX_VALUE);
    }

    private RecognizerBase<STATE> parseMultiple(STATE state, int minMatches, final int maxMatches) {
        if (minMatches < 0) {
            throw new IllegalArgumentException(String.format("minMatches (%d) must not be negative", minMatches));
        }
        if (minMatches > maxMatches) {
            throw new IllegalArgumentException(String.format("minMatches (%d) must not be greater than maxMatches (%d)", minMatches, maxMatches));
        }
        return this.appendRecognizer(new RecognizerBase<STATE>(this, (Enum)state, minMatches){
            final /* synthetic */ Enum val$state;
            final /* synthetic */ int val$minMatches;
            {
                this.val$state = enum_;
                this.val$minMatches = n2;
                Objects.requireNonNull(this$0);
            }

            @Override
            protected int matchesLocally(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
                int offset;
                int matches;
                for (matches = 0; matches < maxMatches && (offset = parserState.parse(this.val$state, tokens, startOffset)) != -1; ++matches) {
                    startOffset = offset;
                }
                if (this.val$minMatches <= matches && matches <= maxMatches) {
                    return startOffset;
                }
                return -1;
            }

            @Override
            protected String getRecognizerStringRepresentation() {
                return "parseMultiple[" + String.valueOf(this.val$state) + ", [" + this.val$minMatches + "," + maxMatches + "]]";
            }
        });
    }

    public RecognizerBase<STATE> ensureTopLevel() {
        return this.appendRecognizer(new RecognizerBase<STATE>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            protected int matchesLocally(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
                if (parserState.getEntityStackSize() == 0) {
                    return startOffset;
                }
                return -1;
            }

            @Override
            protected String getRecognizerStringRepresentation() {
                return "ensureTopLevel";
            }
        });
    }

    private RecognizerBase<STATE> appendRecognizer(RecognizerBase<STATE> recognizer) {
        this.tailRecognizers.add(recognizer);
        return recognizer;
    }

    public int matches(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
        int localOffset = this.matchesLocally(parserState, tokens, startOffset);
        if (localOffset == -1) {
            return -1;
        }
        if (this.tailRecognizers.isEmpty()) {
            return localOffset;
        }
        for (RecognizerBase<STATE> recognizer : this.tailRecognizers) {
            int match = recognizer.matches(parserState, tokens, localOffset);
            if (match == -1) continue;
            return match;
        }
        return -1;
    }

    protected int matchesLocally(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
        return startOffset;
    }

    public String toString() {
        return this.getRecognizerStringRepresentation() + this.getTailRecognizerStringRepresentation();
    }

    protected String getRecognizerStringRepresentation() {
        if (this.getClass().isAnonymousClass()) {
            return this.getClass().getName();
        }
        return this.getClass().getSimpleName();
    }

    private String getTailRecognizerStringRepresentation() {
        if (this.tailRecognizers.isEmpty()) {
            return "";
        }
        if (this.tailRecognizers.size() == 1) {
            return " " + this.tailRecognizers.getFirst().toString();
        }
        return this.tailRecognizers.stream().map(RecognizerBase::toString).collect(Collectors.joining(" || ", " ( ", " )"));
    }

    public RecognizerBase<STATE> debug(final String message) {
        return this.appendRecognizer(new PreconditionRecognizer(new RecognizerBase<STATE>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int matchesLocally(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
                if (startOffset >= tokens.size()) {
                    System.err.println(message + ": startOffset out of bounds: " + startOffset + " >= " + tokens.size());
                } else {
                    System.err.println(message + ": line=" + (tokens.get(startOffset).getLineNumber() + 1) + ", start=" + startOffset + ", token=" + String.valueOf(tokens.get(startOffset)));
                }
                return startOffset;
            }

            @Override
            protected String getRecognizerStringRepresentation() {
                return "debug \"" + message + "\"";
            }
        }));
    }

    public RecognizerBase<STATE> notFollowedBySequence(ETokenType ... tokenTypes) {
        return this.notPreCondition(RecognizerUtils.createRecognizer(start -> start.sequence((ITokenMatcher[])tokenTypes)));
    }

    public RecognizerBase<STATE> peekAhead(ETokenType ... tokenTypes) {
        return this.preCondition(RecognizerUtils.createRecognizer(start -> start.sequence((ITokenMatcher[])tokenTypes)));
    }

    public RecognizerBase<STATE> peekAheadAnyOf(ETokenType ... tokenTypes) {
        return this.preCondition(RecognizerUtils.createRecognizer(start -> start.sequence(ITokenMatcher.anyOfType((ETokenType[])tokenTypes))));
    }

    public RecognizerBase<STATE> onLanguage(final ELanguage language) {
        return this.appendRecognizer(new RecognizerBase<STATE>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            protected int matchesLocally(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
                if (tokens.isEmpty()) {
                    return -1;
                }
                if (tokens.getFirst().getLanguage() != language) {
                    return -1;
                }
                return startOffset;
            }

            @Override
            protected String getRecognizerStringRepresentation() {
                return "onLanguage[" + String.valueOf(language) + "]";
            }
        });
    }
}

