/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.cpp;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.RecognizerUtils;
import eu.cqse.check.framework.shallowparser.languages.base.EGenericParserStates;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class CppRecognizerUtils {
    public static int matchesAttribute(List<IToken> tokens, int startOffset, Set<String> attributeVariants) {
        int closingRightBracesIndex = TokenStreamUtils.firstTokenOfTypeSequence(tokens, startOffset, ETokenType.RBRACK, ETokenType.RBRACK);
        if (closingRightBracesIndex == -1) {
            return -1;
        }
        String attributeText = TokenStreamTextUtils.concatTokenTexts(tokens.subList(startOffset, closingRightBracesIndex));
        if (attributeVariants.stream().anyMatch(attributeText::equals)) {
            return closingRightBracesIndex;
        }
        return -1;
    }

    private CppRecognizerUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    public static RecognizerBase<EGenericParserStates> createAttributeAnnotationSubrecognizer() {
        return RecognizerUtils.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LBRACK, ETokenType.LBRACK}).skipAfter(new ITokenMatcher[]{ETokenType.RBRACK}).sequence(new ITokenMatcher[]{ETokenType.RBRACK}));
    }
}

