/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.kotlin;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.RecognizerUtils;
import eu.cqse.check.framework.shallowparser.languages.kotlin.EKotlinParserStates;
import eu.cqse.check.framework.shallowparser.languages.kotlin.KotlinShallowParser;
import java.util.List;
import java.util.Objects;

public class KotlinStatementSubRecognizer
extends RecognizerBase<EKotlinParserStates> {
    private static final ITokenMatcher STATEMENT_SEPARATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EOL, ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.EOF, ETokenType.LT, ETokenType.RPAREN, ETokenType.RBRACK, ETokenType.ELSE});
    private static final ITokenMatcher BINARY_OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.SAFECALL_OPERATOR, ETokenType.ELVIS, ETokenType.PLUS, ETokenType.MINUS, ETokenType.MULT, ETokenType.DIV, ETokenType.MOD, ETokenType.ANDAND, ETokenType.OROR, ETokenType.EQEQ, ETokenType.NOTEQ, ETokenType.GT, ETokenType.LT, ETokenType.LTEQ, ETokenType.GTEQ, ETokenType.OR, ETokenType.EQ});
    private final RecognizerBase<EKotlinParserStates> partialStatementRecognizer;
    private final RecognizerBase<EKotlinParserStates> statementContinuationRecognizer = new RecognizerBase<EKotlinParserStates>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        protected int matchesLocally(ParserState<EKotlinParserStates> parserState, List<IToken> tokens, int startOffset) {
            if (startOffset < tokens.size() && ETokenType.EOL.matches(tokens.get(startOffset))) {
                IToken lastTokenOnLine;
                if (startOffset > 1 && BINARY_OPERATORS.matches(lastTokenOnLine = tokens.get(startOffset - 1))) {
                    return 1.skipEOLs(tokens, startOffset);
                }
                int newOffset = 1.skipEOLs(tokens, startOffset);
                if (newOffset >= tokens.size()) {
                    return -1;
                }
                IToken tokenOnNextLine = tokens.get(newOffset);
                if (tokenOnNextLine.getType() != ETokenType.EOL) {
                    if (BINARY_OPERATORS.matches(tokenOnNextLine) || ETokenType.LBRACE.matches(tokenOnNextLine)) {
                        return newOffset;
                    }
                    return -1;
                }
            }
            return -1;
        }

        private static int skipEOLs(List<IToken> tokens, int startOffset) {
            for (int i = startOffset; i < tokens.size(); ++i) {
                if (tokens.get(i).getType() == ETokenType.EOL) continue;
                return i;
            }
            return tokens.size();
        }

        @Override
        protected String getRecognizerStringRepresentation() {
            return "statement continuation";
        }
    };

    public KotlinStatementSubRecognizer(RecognizerBase<EKotlinParserStates> subExpressionRecognizer, List<ETokenType> openingBrackets, List<ETokenType> closingBrackets) {
        RecognizerBase genericRecognizer = RecognizerUtils.createRecognizer(start -> {
            start.sequence(new ITokenMatcher[]{ETokenType.LT}).repeated(KotlinShallowParser.VALID_INSIDE_GENERIC_TOKEN_TYPES).sequence(new ITokenMatcher[]{ETokenType.GT}).skipBeforeWithNesting(STATEMENT_SEPARATORS, openingBrackets, closingBrackets, subExpressionRecognizer);
            start.sequence(new ITokenMatcher[]{ETokenType.LT}).skipBeforeWithNesting(STATEMENT_SEPARATORS, openingBrackets, closingBrackets, subExpressionRecognizer);
        });
        this.partialStatementRecognizer = RecognizerUtils.createRecognizer(start -> start.skipBeforeWithNesting(STATEMENT_SEPARATORS, openingBrackets, closingBrackets, subExpressionRecognizer).repeatedSubRecognizer(genericRecognizer).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}));
    }

    @Override
    protected int matchesLocally(ParserState<EKotlinParserStates> parserState, List<IToken> tokens, int startOffset) {
        int currentOffset = startOffset;
        int newOffset;
        while ((newOffset = this.partialStatementRecognizer.matches(parserState, tokens, currentOffset)) != -1 && (newOffset != currentOffset || tokens.get(currentOffset).getType() == ETokenType.EOL)) {
            currentOffset = newOffset;
            if ((newOffset = this.statementContinuationRecognizer.matches(parserState, tokens, currentOffset)) == -1 || newOffset == currentOffset) {
                return currentOffset;
            }
            currentOffset = newOffset;
        }
        return currentOffset;
    }

    @Override
    protected String getRecognizerStringRepresentation() {
        return super.getRecognizerStringRepresentation() + "[" + this.partialStatementRecognizer.toString() + ", " + String.valueOf(this.statementContinuationRecognizer) + "]";
    }
}

