/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker.java;

import eu.cqse.check.framework.typetracker.java.ImportInformation;
import eu.cqse.check.framework.typetracker.java.JavaPlatformModules;
import eu.cqse.check.framework.typetracker.java.TypeUsageResolutionResult;
import eu.cqse.check.framework.typetracker.java.TypeUsageResolver;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;

class FullyQualifiedUsageResolver
implements TypeUsageResolver {
    private static final UnmodifiableSet<String> KNOWN_FULLY_QUALIFIED = FullyQualifiedUsageResolver.calculateKnownFullyQualified();

    FullyQualifiedUsageResolver() {
    }

    private static UnmodifiableSet<String> calculateKnownFullyQualified() {
        HashSet<String> knownFullyQualified = new HashSet<String>();
        for (Map.Entry module : JavaPlatformModules.MODULE_TO_IMPORTS.entrySet()) {
            for (String someImport : (UnmodifiableSet)module.getValue()) {
                knownFullyQualified.add(someImport.replace('$', '.'));
            }
        }
        return CollectionUtils.asUnmodifiable(knownFullyQualified);
    }

    @Override
    public TypeUsageResolutionResult resolve(ImportInformation importInformation, String typeName) {
        if (typeName.contains(".")) {
            if (KNOWN_FULLY_QUALIFIED.contains((Object)typeName)) {
                return new TypeUsageResolutionResult.Accurate(typeName);
            }
            return new TypeUsageResolutionResult.Inaccurate(Set.of(typeName));
        }
        return new TypeUsageResolutionResult.NotFound();
    }
}

