/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker.java;

import eu.cqse.check.framework.typetracker.java.TypeUsageResolver;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;

public class JavaPlatformModules {
    public static final UnmodifiableMap<String, UnmodifiableSet<String>> MODULE_TO_IMPORTS = JavaPlatformModules.loadModuleFiles();
    private static final String MODULE_HIERARCHY_PATH = "/module-hierarchy";

    private static UnmodifiableMap<String, UnmodifiableSet<String>> loadModuleFiles() {
        try {
            HashMap<String, UnmodifiableSet<String>> moduleFiles;
            block21: {
                moduleFiles = new HashMap<String, UnmodifiableSet<String>>();
                URI uri = TypeUsageResolver.class.getResource(MODULE_HIERARCHY_PATH).toURI();
                if ("jar".equals(uri.getScheme())) {
                    try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap(), null);
                         Stream<Path> list = Files.list(fileSystem.getPath(MODULE_HIERARCHY_PATH, new String[0]));){
                        JavaPlatformModules.extractTypesInModule(moduleFiles, list);
                        break block21;
                    }
                }
                try (Stream<Path> list = Files.list(Paths.get(uri));){
                    JavaPlatformModules.extractTypesInModule(moduleFiles, list);
                }
            }
            return CollectionUtils.asUnmodifiable(moduleFiles);
        }
        catch (IOException | URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void extractTypesInModule(Map<String, UnmodifiableSet<String>> moduleFiles, Stream<Path> list) throws IOException {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Path file = (Path)it.next();
            moduleFiles.put(StringUtils.stripSuffix((String)file.getFileName().toString(), (String)".txt"), (UnmodifiableSet<String>)CollectionUtils.asUnmodifiable(new HashSet<String>(Files.readAllLines(file))));
        }
    }
}

