/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker.java;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.conqat.lib.commons.string.StringUtils;

public class ModuleInformationExtractorHelper {
    static void main() throws IOException, InterruptedException {
        Files.createDirectories(new File("lib/eu.cqse.check/src/main/resources/module-hierarchy/").toPath(), new FileAttribute[0]);
        Process jdepsListModules = new ProcessBuilder("java", "--list-modules").start();
        String stdout = IOUtils.toString((InputStream)jdepsListModules.getInputStream(), (Charset)Charset.defaultCharset());
        jdepsListModules.waitFor();
        for (String name : stdout.split("\n")) {
            String moduleName = StringUtils.getFirstPart((String)name, (char)'@');
            String base = "lib/eu.cqse.check/src/main/resources/module-hierarchy";
            Path basePath = Paths.get(base, new String[0]);
            Path fullPath = basePath.resolve(moduleName + ".txt");
            if (!fullPath.startsWith(base)) {
                throw new IllegalStateException("Invalid path specified!");
            }
            Process jdeps = new ProcessBuilder("jdeps", "--api-only", "-verbose", "-m", moduleName).redirectErrorStream(true).start();
            List<String> types = IOUtils.readLines((InputStream)jdeps.getInputStream(), (Charset)Charset.defaultCharset()).stream().filter(s -> s.startsWith("   ") && s.contains(" -> ")).map(s -> StringUtils.getFirstPart((String)s, (String)" -> ").trim()).sorted().distinct().toList();
            try (FileWriter writer = new FileWriter(fullPath.toFile(), StandardCharsets.UTF_8);){
                IOUtils.writeLines(types, (String)"\n", (Writer)writer);
            }
        }
    }
}

