/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public enum EJavaTestFramework {
    JUNIT_3("junit.framework.", "junit.framework.Assert"),
    JUNIT_4("org.junit.", "org.junit.Assert"),
    JUNIT_5("org.junit.jupiter.", "org.junit.jupiter.api.Assertions"),
    ASSERT_J("org.assertj.", "org.assertj.core.api.Assertions", "org.assertj.core.api.AssertionsForInterfaceTypes", "org.assertj.core.api.AssertionsForClassTypes", "org.assertj.core.api.Fail", "org.assertj.core.api.BDDAssertions", "org.assertj.core.api.SoftAssertions"),
    FEST_ASSERT("org.fest.", "org.fest.assertions.Assertions", "org.fest.assertions.Fail", "org.fest.assertions.GenericAssert"),
    TESTNG("org.testng.", "org.testng.Assert");

    public static final Set<String> TEST_ANNOTATION_NAMES;
    public static final Set<String> ASSERT_J_ASSERTION_METHODS;
    public static final Set<String> ASSERT_J_VALUE_NEUTRAL_METHODS;
    public static final Set<String> ALL_ASSERTION_TYPES;
    private final String namespacePrefix;
    private final Set<String> assertionTypes;

    private EJavaTestFramework(String namespacePrefix, String ... assertionTypes) {
        this.namespacePrefix = namespacePrefix;
        this.assertionTypes = CollectionUtils.asUnmodifiableHashSet((Object[])assertionTypes);
    }

    private static UnmodifiableSet<String> allAssertionTypes() {
        return CollectionUtils.asUnmodifiable(Arrays.stream(EJavaTestFramework.values()).map(framework -> framework.assertionTypes).flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public Set<String> getAssertionTypes() {
        return this.assertionTypes;
    }

    public boolean isImport(String foundImport) {
        return foundImport.startsWith(this.namespacePrefix);
    }

    static {
        TEST_ANNOTATION_NAMES = CollectionUtils.asUnmodifiableHashSet((Object[])new String[]{"Test", "org.junit.Test", "org.junit.jupiter.api.Test", "ParameterizedTest", "org.junit.jupiter.params.ParameterizedTest", "RepeatedTest", "org.junit.jupiter.api.RepeatedTest", "TestFactory", "org.junit.jupiter.api.TestFactory", "TestTemplate", "org.junit.jupiter.api.TestTemplate"});
        ASSERT_J_ASSERTION_METHODS = Set.of("contains", "containsAll", "containsAllEntriesOf", "containsAnyElementOf", "containsAnyOf", "containsExactly", "containsExactlyElementsOf", "containsExactlyEntriesOf", "containsExactlyInAnyOrder", "containsExactlyInAnyOrderEntriesOf", "containsIgnoringCase", "containsOnly", "containsOnlyElementsOf", "containsSequence", "containsSubsequence", "doesNotContain", "endsWith", "hasSameClassAs", "hasSameElementsAs", "hasSameHashCodeAs", "hasSameSizeAs", "isEqualTo", "isEqualToIgnoringCase", "isSameAs", "startsWith");
        ASSERT_J_VALUE_NEUTRAL_METHODS = Set.of("as", "describedAs", "withFailMessage", "overridingErrorMessage");
        ALL_ASSERTION_TYPES = EJavaTestFramework.allAssertionTypes();
    }
}

