/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.EJavaTestFramework;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.MatchGroupElement;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.variable.CLikeVariableUseExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class JavaLanguageFeatureParser
extends CLikeLanguageFeatureParserBase {
    private static final ITokenMatcher ADDITIONAL_TYPE_TOKENS = ETokenType.IDENTIFIER;
    private static final UnmodifiableSet<ETokenType> PRIMITIVE_TYPE_TOKENS = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.BOOLEAN, new ETokenType[]{ETokenType.CHAR, ETokenType.BYTE, ETokenType.SHORT, ETokenType.INT, ETokenType.LONG, ETokenType.FLOAT, ETokenType.DOUBLE, ETokenType.VOID, ETokenType.VAR}));
    private static final ITokenMatcher VALID_IDENTIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.PERMITS, ETokenType.YIELD, ETokenType.SEALED});
    private static final Pattern UNIT_TEST_NAME_RELATED_TO_OBJECT_METHODS_REGEX = Pattern.compile("equal|hash_?code|object_?method|to_?string", 2);
    private static final int FULL_ANNOTATION_GROUP = 0;
    private static final int ANNOTATION_NAME_GROUP = 1;
    private static final int ANNOTATION_PARAMETER_GROUP = 2;
    private static final int SUPERCLASS_GROUP = 3;
    private static final int SUPERINTERFACE_GROUP = 4;
    private static final TokenPattern ANNOTATION_PATTERN = TokenPattern.of().sequence(TokenPattern.of().sequence(ETokenType.AT_OPERATOR).repeated(ETokenType.IDENTIFIER, ETokenType.DOT).sequence(ETokenType.IDENTIFIER).group(1).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, true).group(2)).group(0);
    private static final String DEFAULT_ANNOTATION_PARAMETER_NAME = "value";
    private static final String CLASS_SUFFIX = ".class";
    private static final int ANNOTATION_PARAMETER_VALUE_GROUP = 0;
    private static final TokenPattern ANNOTATION_PARAMETER_VALUE_PATTERN = TokenPattern.of().optional(TokenPattern.of().sequence(ETokenType.IDENTIFIER, ETokenType.EQ)).repeated(TokenPattern.of().anyToken()).group(0);
    private final UnmodifiableSet<String> genericExceptionNames = CollectionUtils.asUnmodifiable(this.generateExceptionNamesSet(RuntimeException.class, Error.class, Throwable.class, Exception.class));
    private static final TokenPattern INTERFACE_TOKEN_PATTERN = TokenPattern.of().sequence(ETokenType.INTERFACE, ETokenType.IDENTIFIER).skipNested(ETokenType.LT, ETokenType.GT, true).optional(TokenPattern.of().sequence(ETokenType.EXTENDS).repeated(TokenPattern.of().repeated(ANNOTATION_PATTERN).sequence(ETokenType.IDENTIFIER, TokenPattern.of().repeated(ETokenType.DOT, ETokenType.IDENTIFIER)).group(4).skipNested(ETokenType.LT, ETokenType.GT, true).optional(ETokenType.COMMA)));
    private static final TokenPattern CLASS_TOKEN_PATTERN = TokenPattern.of().sequence(ETokenType.CLASS).repeated(ETokenType.EOL).sequence(ETokenType.IDENTIFIER).skipNested(ETokenType.LT, ETokenType.GT, true).optional(TokenPattern.of().sequence(ETokenType.EXTENDS).repeated(ANNOTATION_PATTERN).sequence(ETokenType.IDENTIFIER, TokenPattern.of().repeated(ETokenType.DOT, ETokenType.IDENTIFIER)).group(3).skipNested(ETokenType.LT, ETokenType.GT, true)).optional(TokenPattern.of().sequence(ETokenType.IMPLEMENTS).repeated(TokenPattern.of().repeated(ANNOTATION_PATTERN).sequence(ETokenType.IDENTIFIER, TokenPattern.of().repeated(ETokenType.DOT, ETokenType.IDENTIFIER)).group(4).skipNested(ETokenType.LT, ETokenType.GT, true).optional(ETokenType.COMMA)));

    JavaLanguageFeatureParser() {
        super(ELanguage.JAVA, VALID_IDENTIFIERS, ITokenMatcher.anyOfType(PRIMITIVE_TYPE_TOKENS), ADDITIONAL_TYPE_TOKENS, ETokenType.DOT, ".", new CLikeVariableUseExtractor(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.DOUBLE_COLON}), VALID_IDENTIFIERS), ETokenType.COMMA);
    }

    public UnmodifiableSet<ETokenType> primitiveTypeTokens() {
        return PRIMITIVE_TYPE_TOKENS;
    }

    public ITokenMatcher getValidIdentifierTokenTypes() {
        return VALID_IDENTIFIERS;
    }

    @SafeVarargs
    public final Set<String> generateExceptionNamesSet(Class<? extends Throwable> ... exceptionClasses) {
        HashSet<String> exceptionNames = new HashSet<String>();
        for (Class<? extends Throwable> clazz : exceptionClasses) {
            exceptionNames.add(clazz.getSimpleName());
            exceptionNames.add(clazz.getName());
        }
        return exceptionNames;
    }

    public List<IToken> getFieldDeclarationTokens(ShallowEntity attributeEntity) {
        UnmodifiableList tokens = attributeEntity.ownStartTokens();
        int definitionIndex = TokenStreamUtils.firstTokenMatching((List<IToken>)tokens, (ITokenMatcher)ETokenType.EQ);
        if (definitionIndex == -1) {
            return Collections.emptyList();
        }
        int endOffset = tokens.size();
        if (((IToken)tokens.getLast()).getType() == ETokenType.SEMICOLON) {
            --endOffset;
        }
        return tokens.subList(definitionIndex + 1, endOffset);
    }

    public List<List<IToken>> getMethodParameterAnnotationParameters(List<IToken> parameterTokens, Set<String> annotationClasses) {
        Set includingNonQualified = annotationClasses.stream().mapMulti((c, consumer) -> {
            consumer.accept(c);
            int index = c.lastIndexOf(46);
            if (index != -1) {
                consumer.accept(c.substring(index + 1));
            }
        }).collect(Collectors.toSet());
        List<TokenPatternMatch> tokenPatternMatches = ANNOTATION_PATTERN.findNonOverlappingMatches(parameterTokens);
        return tokenPatternMatches.stream().filter(match -> includingNonQualified.contains(match.groupString(1))).map(match -> match.groupTokens(2)).toList();
    }

    public Map<String, List<ParameterValue>> extractAnnotationParameters(List<IToken> paramTokens, Set<String> relevantParameters) {
        HashMap<String, List<ParameterValue>> parameters = new HashMap<String, List<ParameterValue>>();
        List<List<IToken>> individualParameterTokens = TokenStreamUtils.splitWithNesting(paramTokens, ETokenType.COMMA, ETokenType.LBRACE, ETokenType.RBRACE);
        for (List<IToken> parameterTokens : individualParameterTokens) {
            List<ParameterValue> extractedValues;
            if (parameterTokens.isEmpty()) continue;
            ParameterNameAndValue nameAndValue = this.extractParameterNameAndValue(parameterTokens);
            if (!relevantParameters.contains(nameAndValue.name) || nameAndValue.valueTokens.isEmpty() || (extractedValues = JavaLanguageFeatureParser.extractParameterValues(nameAndValue.valueTokens)).isEmpty()) continue;
            parameters.put(nameAndValue.name, extractedValues);
        }
        return parameters;
    }

    private ParameterNameAndValue extractParameterNameAndValue(List<IToken> parameterTokens) {
        String paramName = this.getDefaultAnnotationParameterName();
        List<IToken> valueTokens = parameterTokens;
        int equalsIndex = TokenStreamUtils.firstTokenMatching(parameterTokens, (ITokenMatcher)ETokenType.EQ);
        if (equalsIndex > 0 && parameterTokens.get(equalsIndex - 1).getType() == ETokenType.IDENTIFIER) {
            paramName = parameterTokens.get(equalsIndex - 1).getText();
            valueTokens = parameterTokens.subList(equalsIndex + 1, parameterTokens.size());
        }
        return new ParameterNameAndValue(paramName, valueTokens);
    }

    private static List<ParameterValue> extractParameterValues(List<IToken> valueTokens) {
        ArrayList<ParameterValue> extractedValues = new ArrayList<ParameterValue>();
        if (valueTokens.getFirst().getType() == ETokenType.LBRACE) {
            JavaLanguageFeatureParser.extractArrayParameterValues(valueTokens, extractedValues);
        } else {
            ParameterValue value = JavaLanguageFeatureParser.extractSingleParameterValue(valueTokens);
            if (value != null) {
                extractedValues.add(value);
            }
        }
        return extractedValues;
    }

    private static void extractArrayParameterValues(List<IToken> valueTokens, List<ParameterValue> extractedValues) {
        List<IToken> arrayContentTokens = TokenStreamUtils.tokensBetween(valueTokens, ETokenType.LBRACE, ETokenType.RBRACE);
        if (arrayContentTokens.isEmpty()) {
            return;
        }
        List<List<IToken>> arrayElementTokens = TokenStreamUtils.splitWithNesting(arrayContentTokens, ETokenType.COMMA, ETokenType.LBRACE, ETokenType.RBRACE);
        for (List<IToken> elementTokens : arrayElementTokens) {
            JavaLanguageFeatureParser.extractSingleArrayValueElement(elementTokens, extractedValues);
        }
    }

    private static void extractSingleArrayValueElement(List<IToken> elementTokens, List<ParameterValue> extractedValues) {
        if (elementTokens.isEmpty()) {
            return;
        }
        ParameterValue value = JavaLanguageFeatureParser.extractSingleParameterValue(elementTokens);
        if (value != null) {
            extractedValues.add(value);
        }
    }

    private static @Nullable ParameterValue extractSingleParameterValue(List<IToken> tokens) {
        if (tokens.isEmpty()) {
            return null;
        }
        if (tokens.getFirst().getType() == ETokenType.STRING_LITERAL) {
            String text = tokens.getFirst().getText();
            text = StringUtils.removeDoubleQuotes((String)text);
            return new ParameterValue(tokens, text);
        }
        if (tokens.getFirst().getType() == ETokenType.BOOLEAN_LITERAL) {
            return new ParameterValue(tokens, tokens.getFirst().getText());
        }
        if (ParameterValue.looksLikeClassReference(tokens)) {
            return new ParameterValue(tokens, TokenStreamTextUtils.concatTokenTexts(tokens));
        }
        return null;
    }

    @Override
    public String getImportName(ShallowEntity entity) {
        CCSMAssert.isTrue((boolean)this.isImport(entity), (String)"entity.getType() must be equal to EShallowEntityType.META and entity.getSubtype() must be equal to SubTypeNames.IMPORT or SubTypeNames.STATIC_IMPORT");
        UnmodifiableList tokens = entity.ownStartTokens();
        if (TokenStreamUtils.firstTokenMatching((List<IToken>)tokens, (ITokenMatcher)ETokenType.STATIC) != -1) {
            return null;
        }
        String importName = entity.getName();
        return StringUtils.removeLastPart((String)importName, (char)'.');
    }

    @Override
    public boolean isImport(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && (entity.getSubtype().equals("import") || entity.getSubtype().equals("static import"));
    }

    public List<ShallowEntity> getImportStatements(List<ShallowEntity> ast) {
        return ShallowEntityTraversalUtils.listEntitiesOfType(ast, (EShallowEntityType)EShallowEntityType.META).stream().filter(this::isImport).toList();
    }

    public boolean isConstant(ShallowEntity entity) {
        if (entity.getType() != EShallowEntityType.ATTRIBUTE) {
            return false;
        }
        if (TokenStreamUtils.containsAll((List<IToken>)entity.ownStartTokens(), ETokenType.FINAL, ETokenType.STATIC)) {
            return true;
        }
        ShallowEntity parent = entity.getParent();
        return parent != null && parent.getType() == EShallowEntityType.TYPE && (parent.getSubtype().equals("interface") || parent.getSubtype().equals("@interface"));
    }

    public boolean isForEachLoop(ShallowEntity entity) {
        if (entity.getType() == EShallowEntityType.STATEMENT && entity.getSubtype().equals("for")) {
            return TokenStreamUtils.findFirstTopLevel((List<IToken>)entity.ownStartTokens(), (ITokenMatcher)ETokenType.COLON, List.of(ETokenType.LBRACE), List.of(ETokenType.RBRACE)) != -1;
        }
        return false;
    }

    @Override
    protected TokenPattern getParameterAnnotationPattern() {
        return ANNOTATION_PATTERN;
    }

    public List<List<IToken>> getThrownTypesTokens(ShallowEntity methodEntity) {
        CCSMAssert.isTrue((methodEntity.getType() == EShallowEntityType.METHOD ? 1 : 0) != 0, (String)"Only methods can throw exceptions");
        UnmodifiableList tokens = methodEntity.ownStartTokens();
        List<IToken> thrownClauseTokens = TokenStreamUtils.tokensBetween((List<IToken>)tokens, EnumSet.of(ETokenType.THROWS), EnumSet.of(ETokenType.LBRACE, ETokenType.SEMICOLON));
        if (thrownClauseTokens.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        return TokenStreamUtils.split(thrownClauseTokens, ETokenType.COMMA);
    }

    public IToken getThrowsToken(ShallowEntity methodEntity) {
        CCSMAssert.isTrue((methodEntity.getType() == EShallowEntityType.METHOD ? 1 : 0) != 0, (String)"Only methods can throw exceptions");
        UnmodifiableList tokens = methodEntity.ownStartTokens();
        int throwsTokenIndex = TokenStreamUtils.firstTokenMatching((List<IToken>)tokens, (ITokenMatcher)ETokenType.THROWS);
        if (throwsTokenIndex == -1) {
            return null;
        }
        return (IToken)tokens.get(throwsTokenIndex);
    }

    public boolean isAnnotated(ShallowEntity entity) {
        return !this.getAnnotations(entity).isEmpty();
    }

    public String getDetailedReturnType(ShallowEntity entity) {
        CCSMAssert.isTrue((entity.getType() == EShallowEntityType.METHOD ? 1 : 0) != 0, (String)"May only be applied to methods!");
        CCSMAssert.isFalse((boolean)ShallowParsingUtils.isLambdaMethod(entity), (String)"May not be applied to lambda methods!");
        UnmodifiableList tokens = entity.ownStartTokens();
        int nameIndex = JavaLanguageFeatureParser.getMethodNameIndex(entity, (List<IToken>)tokens);
        List<IToken> typeTokens = JavaLanguageFeatureParser.getDetailedReturnTypeTokens((List<IToken>)tokens, nameIndex);
        return TokenStreamTextUtils.concatTokenTexts(typeTokens);
    }

    private static int getMethodNameIndex(ShallowEntity entity, List<IToken> tokens) {
        int nameIndex = 0;
        for (IToken token : tokens) {
            if (!token.getText().equals(entity.getName())) continue;
            nameIndex = tokens.indexOf(token);
        }
        return nameIndex;
    }

    private static List<IToken> getDetailedReturnTypeTokens(List<IToken> tokens, int nameIndex) {
        int startIndex = nameIndex - 1;
        while (startIndex >= 2) {
            ETokenType startType = tokens.get(startIndex).getType();
            if (startType == ETokenType.RBRACK || startType == ETokenType.IDENTIFIER && tokens.get(startIndex - 1).getType() == ETokenType.DOT) {
                startIndex -= 2;
                continue;
            }
            if (startType != ETokenType.GT) break;
            startIndex = TokenStreamUtils.findMatchingOpeningToken(tokens, startIndex - 1, ETokenType.LT, ETokenType.GT) - 1;
        }
        return tokens.subList(startIndex, nameIndex);
    }

    public boolean isGenericExceptionClass(String className) {
        return this.genericExceptionNames.contains((Object)className);
    }

    @Override
    protected List<IToken> filterGenericTokens(List<IToken> genericTokens) {
        if (genericTokens.isEmpty()) {
            return genericTokens;
        }
        return Collections.singletonList(genericTokens.getFirst());
    }

    public Optional<String> getPackageName(List<ShallowEntity> shallowEntities) {
        return shallowEntities.stream().filter(entity -> entity.getType() == EShallowEntityType.META && "package".equals(entity.getSubtype())).map(ShallowEntity::getName).filter(Objects::nonNull).findFirst();
    }

    public String getFullClassName(ShallowEntity shallowEntity) {
        Optional firstType = ShallowEntityTraversalUtils.findEntityOrParentEntity((ShallowEntity)shallowEntity, entity -> entity.getType() == EShallowEntityType.TYPE);
        if (firstType.isEmpty()) {
            return "";
        }
        ArrayList<String> classNames = new ArrayList<String>();
        ShallowEntity parent = (ShallowEntity)firstType.get();
        do {
            String testClassName = parent.getName();
            classNames.addFirst(testClassName);
        } while ((parent = parent.getParent()) != null && parent.getType() == EShallowEntityType.TYPE);
        return String.join((CharSequence)"$", classNames);
    }

    public boolean isTestClass(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.TYPE && entity.getChildren().stream().filter(child -> child.getType() == EShallowEntityType.METHOD).anyMatch(method -> this.getAnnotations((ShallowEntity)method).stream().anyMatch(this::isTestAnnotation));
    }

    public boolean isTestAnnotation(ShallowEntity annotationEntity) {
        return this.isSpecificAnnotation(annotationEntity, EJavaTestFramework.TEST_ANNOTATION_NAMES);
    }

    public boolean isTestMethod(ShallowEntity method) {
        List<ShallowEntity> annotations = this.getAnnotations(method);
        Optional<ShallowEntity> testAnnotation = annotations.stream().filter(this::isTestAnnotation).findFirst();
        return testAnnotation.isPresent();
    }

    public Set<String> getImports(List<ShallowEntity> entities) {
        return this.getImportsByPrefix(entities, "");
    }

    public Set<String> getImportsAndFullNamespaceVariables(List<ShallowEntity> entities) {
        Set<String> imports = this.getImportsFromImportStatements(entities);
        for (ShallowEntity entity : ShallowEntityTraversalUtils.listEntitiesOfTypes(entities, Set.of(EShallowEntityType.META, EShallowEntityType.STATEMENT))) {
            if (this.isAnnotation(entity) && entity.getName() != null && !((String)StringUtils.splitAtFirst((String)entity.getName(), (String)".").getSecond()).isEmpty()) {
                imports.add(entity.getName());
                continue;
            }
            if (entity.getType() != EShallowEntityType.STATEMENT || !"local variable".equals(entity.getSubtype())) continue;
            TokenPattern pattern = new TokenPattern().sequence(ETokenType.IDENTIFIER).group(0).repeatedAtLeastOnce(ETokenType.DOT, ETokenType.IDENTIFIER).group(1).sequence(ETokenType.IDENTIFIER, ETokenType.EQ);
            for (TokenPatternMatch match : pattern.findAll((List<IToken>)entity.ownStartTokens())) {
                imports.add(match.groupString(0) + match.groupString(1));
            }
        }
        return imports;
    }

    public Set<String> getImportsFromImportStatements(List<ShallowEntity> entities) {
        return this.getImportStatements(entities).stream().map(ShallowEntity::getName).collect(Collectors.toSet());
    }

    public Set<String> getImportsByPrefix(List<ShallowEntity> entities, String ... prefixes) {
        return this.getImportsAndFullNamespaceVariables(entities).stream().filter(fullImport -> StringUtils.startsWithOneOf((String)fullImport, (String[])prefixes)).collect(Collectors.toSet());
    }

    public ListMap<EJavaTestFramework, String> getTestFrameworkImports(List<ShallowEntity> entities) {
        ListMap frameworkWithFoundImports = new ListMap();
        for (String foundImport : this.getImportsAndFullNamespaceVariables(entities)) {
            for (EJavaTestFramework testFramework : EJavaTestFramework.values()) {
                if (!testFramework.isImport(foundImport)) continue;
                frameworkWithFoundImports.add((Object)testFramework, (Object)foundImport);
            }
        }
        return frameworkWithFoundImports;
    }

    public boolean isConstructorOfType(@Nullable ShallowEntity type, ShallowEntity child) {
        return type != null && type.getType() == EShallowEntityType.TYPE && child.getType() == EShallowEntityType.METHOD && type.getName() != null && child.getName() != null && Objects.equals(type.getName(), child.getName());
    }

    public Set<String> extractStaticImportedAssertions(List<ShallowEntity> importStatements) {
        HashSet<String> staticImportedAssertionMethods = new HashSet<String>();
        for (ShallowEntity importStatement : importStatements) {
            Pair importedTypeAndMethod;
            String subtype = importStatement.getSubtype();
            if (importStatement.getName() == null || !"static import".equals(subtype) || !EJavaTestFramework.ALL_ASSERTION_TYPES.contains((importedTypeAndMethod = StringUtils.splitAtLast((String)importStatement.getName(), (char)'.')).getFirst()) || !this.isAssertionMethod((String)importedTypeAndMethod.getSecond())) continue;
            staticImportedAssertionMethods.add((String)importedTypeAndMethod.getSecond());
        }
        return staticImportedAssertionMethods;
    }

    public Set<String> extractImportedAssertionsTypes(List<ShallowEntity> importStatements) {
        HashSet<String> importedAssertionTypes = new HashSet<String>();
        for (ShallowEntity importStatement : importStatements) {
            String subtype = importStatement.getSubtype();
            if (importStatement.getName() == null || !"import".equals(subtype) || !EJavaTestFramework.ALL_ASSERTION_TYPES.contains(importStatement.getName())) continue;
            String assertionType = (String)StringUtils.splitAtLast((String)importStatement.getName(), (char)'.').getSecond();
            importedAssertionTypes.add(assertionType);
        }
        return importedAssertionTypes;
    }

    private boolean isAssertionType(String typeName) {
        return EJavaTestFramework.ALL_ASSERTION_TYPES.contains(typeName);
    }

    private boolean isAssertionMethod(String methodName) {
        return methodName.startsWith("assert") || methodName.startsWith("fail");
    }

    public List<IToken> getAssertionCalls(ShallowEntity statement, Set<String> importedAssertionTypes, Set<String> staticImportedAssertionMethods) {
        ArrayList<IToken> assertionCallTokens = new ArrayList<IToken>();
        List<TokenPatternMatch> matches = new TokenPattern().repeated(ETokenType.IDENTIFIER, ETokenType.DOT).group(0).sequence(ETokenType.IDENTIFIER, ETokenType.LPAREN).group(1).findNonOverlappingMatches((List<IToken>)statement.ownStartTokens());
        for (TokenPatternMatch match : matches) {
            List<IToken> methodCall = match.groupTokens(1);
            String typeName = TokenStreamTextUtils.concatTokenTexts(match.groupTokens(0));
            String methodCallName = methodCall.getFirst().getText();
            if (typeName.isEmpty()) {
                if (!staticImportedAssertionMethods.contains(methodCallName)) continue;
                assertionCallTokens.add(methodCall.getFirst());
                continue;
            }
            if ((typeName = typeName.substring(0, typeName.length() - 1)).contains(".")) {
                if (!LanguageFeatureParser.JAVA.isAssertionType(typeName) || !LanguageFeatureParser.JAVA.isAssertionMethod(methodCallName)) continue;
                assertionCallTokens.add(methodCall.getFirst());
                continue;
            }
            if (!importedAssertionTypes.contains(typeName) || !LanguageFeatureParser.JAVA.isAssertionMethod(methodCallName)) continue;
            assertionCallTokens.add(methodCall.getFirst());
        }
        return assertionCallTokens;
    }

    public @Nullable ShallowEntity findTryStatement(ShallowEntity catchEntity) {
        if (catchEntity.getParent() == null) {
            return null;
        }
        UnmodifiableList siblingEntities = catchEntity.getParent().getChildren();
        boolean foundCatch = false;
        for (ShallowEntity sibling : siblingEntities.reversed()) {
            if (sibling.equals(catchEntity)) {
                foundCatch = true;
            }
            if (!foundCatch || !"try".equals(sibling.getSubtype())) continue;
            return sibling;
        }
        return null;
    }

    public boolean annotationHasParameters(@NonNull ShallowEntity annotation) {
        return !this.getAnnotationParameterTokens(annotation).isEmpty();
    }

    public boolean isSpecificAnnotation(List<IToken> annotation, Set<String> annotations) {
        TokenPatternMatch match = ANNOTATION_PATTERN.findFirstMatch(annotation);
        if (match == null) {
            return false;
        }
        String annotationName = match.groupString(1);
        return annotations.contains(annotationName);
    }

    public TokenPattern getAnnotationPattern() {
        return ANNOTATION_PATTERN;
    }

    public @NonNull List<IToken> getAnnotationParameterTokens(@NonNull ShallowEntity annotation) {
        CCSMAssert.isTrue((boolean)this.isAnnotation(annotation), (String)"`annotation` must be an annotation entity");
        return TokenStreamUtils.tokensBetween((List<IToken>)annotation.ownStartTokens(), ETokenType.LPAREN, ETokenType.RPAREN);
    }

    public List<IToken> extractAnnotationParameterValue(List<IToken> annotationParameter) {
        TokenPatternMatch match = ANNOTATION_PARAMETER_VALUE_PATTERN.findFirstMatch(annotationParameter);
        if (match == null) {
            return Collections.emptyList();
        }
        return match.groupTokens(0);
    }

    public List<List<IToken>> extractAnnotationsFromParameter(List<IToken> parameterTokens) {
        return ANNOTATION_PATTERN.findNonOverlappingMatches(parameterTokens).stream().map(match -> match.groupTokens(0)).toList();
    }

    public List<String> getImplementedInterfacesOfClass(@NonNull ShallowEntity classEntity) {
        if (classEntity.getType() != EShallowEntityType.TYPE || !"class".equals(classEntity.getSubtype())) {
            return CollectionUtils.emptyList();
        }
        return Objects.requireNonNull(CLASS_TOKEN_PATTERN.findFirstMatch((List<IToken>)classEntity.ownStartTokens())).getMatchGroup(4).stream().map(MatchGroupElement::concatTokenTexts).toList();
    }

    public List<IToken> getSuperclass(@NonNull ShallowEntity classEntity) {
        if (classEntity.getType() != EShallowEntityType.TYPE || !"class".equals(classEntity.getSubtype())) {
            return CollectionUtils.emptyList();
        }
        return Objects.requireNonNull(CLASS_TOKEN_PATTERN.findFirstMatch((List<IToken>)classEntity.ownStartTokens())).groupTokens(3);
    }

    public List<String> getExtendedInterfacesOfInterface(@NonNull ShallowEntity interfaceEntity) {
        if (interfaceEntity.getType() != EShallowEntityType.TYPE || !"interface".equals(interfaceEntity.getSubtype())) {
            return CollectionUtils.emptyList();
        }
        return Objects.requireNonNull(INTERFACE_TOKEN_PATTERN.findFirstMatch((List<IToken>)interfaceEntity.ownStartTokens())).getMatchGroup(4).stream().map(MatchGroupElement::concatTokenTexts).toList();
    }

    public List<String> getExtendedOrImplementedInterfaces(@NonNull ShallowEntity entity) {
        return switch (entity.getSubtype()) {
            case "class" -> LanguageFeatureParser.JAVA.getImplementedInterfacesOfClass(entity);
            case "interface" -> LanguageFeatureParser.JAVA.getExtendedInterfacesOfInterface(entity);
            default -> CollectionUtils.emptyList();
        };
    }

    public boolean statementIsInMethodWithEqualsOrHashcodeNamePattern(ShallowEntity declaringEntity) {
        if (declaringEntity.getType() != EShallowEntityType.STATEMENT) {
            return false;
        }
        Optional surroundingMethod = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)declaringEntity, parent -> parent.getType() == EShallowEntityType.METHOD);
        return surroundingMethod.isPresent() && ((ShallowEntity)surroundingMethod.get()).getName() != null && UNIT_TEST_NAME_RELATED_TO_OBJECT_METHODS_REGEX.matcher(((ShallowEntity)surroundingMethod.get()).getName()).find();
    }

    public boolean usesImportedType(List<ShallowEntity> entities, String fullTypeName) {
        return this.getImportsAndFullNamespaceVariables(entities).contains(fullTypeName) || this.getImportStatements(entities).stream().anyMatch(importStatement -> importStatement.getName() != null && importStatement.getName().equals(StringUtils.removeLastPart((String)fullTypeName, (char)'.') + ".*"));
    }

    public String getClassSuffix() {
        return CLASS_SUFFIX;
    }

    public String getDefaultAnnotationParameterName() {
        return DEFAULT_ANNOTATION_PARAMETER_NAME;
    }

    public String resolveFullyQualifiedTypeName(@NonNull ShallowEntity entity) {
        Preconditions.checkArgument((!entity.getSubtype().equals("anonymous class") ? 1 : 0) != 0, (Object)"Use resolveFullyQualifiedTypeName returning Set<String> instead as imported anonymous class could resolve to multiple possible imports");
        return this.fullyQualifiedTypeNameToRootNoImports(Objects.requireNonNull(entity.getParent()), Objects.requireNonNull(entity.getName()));
    }

    public Set<String> resolveFullyQualifiedTypeName(JavaImportSensitiveTypeResolver typeResolver, @NonNull ShallowEntity context, @NonNull String typeName) {
        String firstTypeNamePart = StringUtils.getFirstPart((String)typeName, (String)".");
        while (context.getParent() != null) {
            UnmodifiableList children = context.getParent().getChildren();
            for (ShallowEntity child : children) {
                if (child.getType() != EShallowEntityType.TYPE || "anonymous class".equals(child.getSubtype()) || !Objects.equals(child.getName(), firstTypeNamePart)) continue;
                return Set.of(this.fullyQualifiedTypeNameToRootNoImports(Objects.requireNonNull(child.getParent()), typeName));
            }
            context = context.getParent();
        }
        return this.fullyQualifiedTypeNameToRootWithImports(typeResolver, context, typeName);
    }

    public boolean isSetterMethod(ShallowEntity method) {
        boolean isPublic = LanguageFeatureParser.JAVA.hasExplicitVisibility(method, ETokenType.PUBLIC);
        boolean isNonStatic = !LanguageFeatureParser.JAVA.isStatic(method);
        boolean returnsVoid = LanguageFeatureParser.JAVA.hasVoidReturnType(method);
        boolean startsWithSet = method.getName() != null && method.getName().startsWith("set");
        boolean hasOneParameter = LanguageFeatureParser.JAVA.getSplitParameterTokens(method).size() == 1;
        return isPublic && isNonStatic && returnsVoid && startsWithSet && hasOneParameter;
    }

    private Set<String> fullyQualifiedTypeNameToRootWithImports(JavaImportSensitiveTypeResolver typeResolver, @NonNull ShallowEntity entity, @NonNull String typeName) {
        UnmodifiableSet<String> possibleFullyQualifiedTypeNames = typeResolver.getPossibleFullyQualifiedTypeNames(typeName).toSet();
        if (!possibleFullyQualifiedTypeNames.isEmpty()) {
            return possibleFullyQualifiedTypeNames;
        }
        if (typeName.contains(".")) {
            return Set.of(typeName);
        }
        return Set.of(this.getPackageName((List<ShallowEntity>)entity.getChildren()).map(s -> s + ".").orElse("") + typeName);
    }

    private String fullyQualifiedTypeNameToRootNoImports(@NonNull ShallowEntity entity, @NonNull String typeName) {
        StringBuilder result = new StringBuilder();
        while (entity.getParent() != null) {
            if (entity.getType() == EShallowEntityType.TYPE) {
                result.insert(0, Objects.requireNonNull(entity.getName()) + ".");
            }
            entity = entity.getParent();
        }
        return this.getPackageName((List<ShallowEntity>)entity.getChildren()).map(s -> s + ".").orElse("") + String.valueOf(result) + typeName;
    }

    private record ParameterNameAndValue(String name, List<IToken> valueTokens) {
    }

    public static final class ParameterValue {
        private final List<IToken> tokens;
        private final String value;
        private final boolean classReference;

        public ParameterValue(List<IToken> tokens, String value) {
            this.tokens = tokens;
            this.value = value;
            this.classReference = ParameterValue.looksLikeClassReference(tokens);
        }

        public static boolean looksLikeClassReference(List<IToken> tokens) {
            return TokenStreamUtils.endsWith(tokens, ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.CLASS_LITERAL);
        }

        public List<IToken> getTokens() {
            return this.tokens;
        }

        public String simpleClassName() {
            String className = this.value;
            if (this.isQualifiedClassReference()) {
                className = StringUtils.getLastPart((String)className, (String)".", (int)2);
            }
            return StringUtils.stripSuffix((String)className, (String)JavaLanguageFeatureParser.CLASS_SUFFIX);
        }

        public boolean isEmptyString() {
            return StringUtils.isEmpty((String)this.value) && this.tokens.size() == 1 && this.tokens.getFirst().getType() == ETokenType.STRING_LITERAL;
        }

        public boolean isFalse() {
            return this.tokens.size() == 1 && this.tokens.getFirst().getType() == ETokenType.BOOLEAN_LITERAL && this.tokens.getFirst().getText().equals("false");
        }

        public boolean isTrue() {
            return this.tokens.size() == 1 && this.tokens.getFirst().getType() == ETokenType.BOOLEAN_LITERAL && this.tokens.getFirst().getText().equals("true");
        }

        public boolean isQualifiedClassReference() {
            return this.classReference && TokenStreamUtils.count(this.tokens, ETokenType.DOT) > 2;
        }

        public boolean isClassReference() {
            return this.classReference;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "ParameterValue[tokens='" + TokenStreamTextUtils.concatTokenTexts(this.tokens) + "', value='" + this.value + "']";
        }
    }
}

