/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.framework.util.clike.CLikeCheckUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;

class JavaMethodCallFinder {
    private static final TokenPattern GET_INSTANCE_PATTERN = TokenPattern.of().sequence(ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.matchesRegex((String)"getInstance|INSTANCE|Instance")})).group(1).sequence(ETokenType.LPAREN);
    private static final TokenPattern STANDARD_CONSTRUCTOR_PATTERN = TokenPattern.of().sequence(ETokenType.NEW).group(0).repeated(ETokenType.IDENTIFIER, ETokenType.DOT).sequence(ETokenType.IDENTIFIER).sequence(ETokenType.LPAREN).group(1);
    private static final TokenPattern LAMBDA_CONSTRUCTOR_PATTERN = TokenPattern.of().anyToken().group(0).repeated(ETokenType.IDENTIFIER, ETokenType.DOT).sequence(ETokenType.IDENTIFIER).sequence(ETokenType.DOUBLE_COLON).group(1).sequence(ETokenType.NEW);

    JavaMethodCallFinder() {
    }

    static List<JavaMethodCallMatcher.MethodCall> findConstructorCalls(List<ShallowEntity> statementsOrAttributes, JavaImportSensitiveTypeResolver typeResolver, JavaMethodCallMatcher matcher) {
        ArrayList<JavaMethodCallMatcher.MethodCall> methodCalls = new ArrayList<JavaMethodCallMatcher.MethodCall>();
        for (ShallowEntity statement : statementsOrAttributes) {
            ArrayList matchesForPatterns = new ArrayList(Stream.concat(STANDARD_CONSTRUCTOR_PATTERN.findNonOverlappingMatches((List<IToken>)statement.ownStartTokens()).stream(), LAMBDA_CONSTRUCTOR_PATTERN.findNonOverlappingMatches((List<IToken>)statement.ownStartTokens()).stream()).toList());
            for (TokenPatternMatch constructorMatch : matchesForPatterns) {
                JavaMethodCallFinder.extractConstructorCall(typeResolver, matcher, statement, constructorMatch.tokensBetweenGroupsExclusive(0, 1)).ifPresent(methodCalls::add);
            }
            if (!matcher.isGetInstanceCallsIncluded()) continue;
            JavaMethodCallFinder.findGetInstanceCalls(typeResolver, matcher, statement, methodCalls);
        }
        return methodCalls;
    }

    private static void findGetInstanceCalls(JavaImportSensitiveTypeResolver typeResolver, JavaMethodCallMatcher matcher, ShallowEntity statement, List<JavaMethodCallMatcher.MethodCall> methodCalls) {
        for (TokenPatternMatch getInstanceMatch : GET_INSTANCE_PATTERN.findNonOverlappingMatches((List<IToken>)statement.ownStartTokens())) {
            IToken getInstanceCall = getInstanceMatch.groupTokens(1).getLast();
            SequencedCollection callTokens = statement.ownStartTokens().reversed().stream().dropWhile(token -> token.getOffset() > getInstanceCall.getOffset()).skip(2L).takeWhile(token -> token.getType() == ETokenType.DOT || token.getType() == ETokenType.IDENTIFIER).toList().reversed();
            JavaMethodCallFinder.extractConstructorCall(typeResolver, matcher, statement, (List<IToken>)callTokens).ifPresent(methodCalls::add);
        }
    }

    private static Optional<JavaMethodCallMatcher.MethodCall> extractConstructorCall(JavaImportSensitiveTypeResolver typeResolver, JavaMethodCallMatcher matcher, ShallowEntity statement, List<IToken> callTokens) {
        if (callTokens.isEmpty()) {
            return Optional.empty();
        }
        String constructorName = TokenStreamTextUtils.concatTokenTexts(callTokens);
        IToken callToken = callTokens.getLast();
        String fullType = typeResolver.getFullyQualifiedTypeName(callToken.getText());
        if (matcher.getFullTypeNames().contains(fullType) || matcher.getFullTypeNames().contains(constructorName) || JavaMethodCallFinder.isHasStarImportMatch(typeResolver, matcher, callToken.getText())) {
            List<List<IToken>> parameters = CLikeCheckUtils.getMethodArguments(statement, callToken.getOffset());
            if (!matcher.getParameterPredicates().stream().allMatch(parameterCondition -> parameterCondition.test(parameters))) {
                return Optional.empty();
            }
            return Optional.of(new JavaMethodCallMatcher.MethodCall(statement, callToken, parameters, matcher.getTag()));
        }
        return Optional.empty();
    }

    private static boolean isHasStarImportMatch(JavaImportSensitiveTypeResolver typeResolver, JavaMethodCallMatcher matcher, String constructorText) {
        UnmodifiableSet<String> starImports = typeResolver.getWildcardImports();
        if (starImports.isEmpty()) {
            return false;
        }
        Set fullTargetTypesWithStaticImport = matcher.getFullTypeNames().stream().filter(fullTargetType -> starImports.contains(StringUtils.removeLastPart((String)fullTargetType, (char)'.'))).collect(Collectors.toSet());
        return fullTargetTypesWithStaticImport.stream().map(fullNamespace -> StringUtils.getLastPart((String)fullNamespace, (char)'.')).collect(Collectors.toSet()).contains(constructorText);
    }

    static List<JavaMethodCallMatcher.MethodCall> findCallsOnType(List<ShallowEntity> statementsOrAttributes, JavaImportSensitiveTypeResolver typeResolver, ITypeResolution typeResolution, JavaMethodCallMatcher methodMatcher) {
        ArrayList<JavaMethodCallMatcher.MethodCall> methodCalls = new ArrayList<JavaMethodCallMatcher.MethodCall>();
        for (ShallowEntity statementOrAttribute : statementsOrAttributes) {
            UnmodifiableList tokens = statementOrAttribute.ownStartTokens();
            List<PotentialMatch> potentialMatches = JavaMethodCallFinder.collectCallsOnVariables(methodMatcher, (List<IToken>)tokens);
            JavaMethodCallFinder.collectCallsWithNewKeyword((List<IToken>)tokens, potentialMatches);
            List<JavaMethodCallMatcher.MethodCall> staticCalls = JavaMethodCallFinder.collectCallsOfStaticallyImportedMethods(statementOrAttribute, (List<IToken>)tokens, typeResolver, methodMatcher);
            methodCalls.addAll(staticCalls);
            ScopedTypeLookup lookup = typeResolution.getTypeLookup(statementOrAttribute);
            for (PotentialMatch candidate : potentialMatches) {
                JavaMethodCallFinder.findMethodCall(typeResolver, methodMatcher, statementOrAttribute, candidate, lookup).ifPresent(methodCalls::add);
            }
        }
        return methodCalls;
    }

    private static Optional<JavaMethodCallMatcher.MethodCall> findMethodCall(JavaImportSensitiveTypeResolver typeResolver, JavaMethodCallMatcher methodMatcher, ShallowEntity statementOrAttribute, PotentialMatch candidate, ScopedTypeLookup lookup) {
        IToken tokenWithCalledMethodName = candidate.callStartingWithMethodName.getFirst();
        if (methodMatcher.getKnownMethodReturningSameType().contains(tokenWithCalledMethodName.getText())) {
            Optional<IToken> methodCallLaterInTokenStream = candidate.callStartingWithMethodName.stream().filter(token -> token.getType().isIdentifier() && methodMatcher.isTargetMethod(token.getText())).findFirst();
            if (methodCallLaterInTokenStream.isEmpty()) {
                return Optional.empty();
            }
            tokenWithCalledMethodName = methodCallLaterInTokenStream.get();
        }
        if (!methodMatcher.isTargetMethod(tokenWithCalledMethodName.getText())) {
            return Optional.empty();
        }
        List<List<IToken>> parameters = CLikeCheckUtils.getMethodArguments(statementOrAttribute, tokenWithCalledMethodName.getOffset());
        if (!methodMatcher.getParameterPredicates().stream().allMatch(parameterCondition -> parameterCondition.test(parameters))) {
            return Optional.empty();
        }
        if (JavaMethodCallFinder.methodInvocationHasRightType(typeResolver, methodMatcher, candidate, lookup)) {
            return Optional.of(new JavaMethodCallMatcher.MethodCall(statementOrAttribute, tokenWithCalledMethodName, parameters, methodMatcher.getTag()));
        }
        return Optional.empty();
    }

    private static void collectCallsWithNewKeyword(List<IToken> tokens, List<PotentialMatch> result) {
        for (Integer indexOfNewKeyword : TokenStreamUtils.firstTokenOfTypeSequences(tokens, 0, ETokenType.NEW, ETokenType.IDENTIFIER, ETokenType.DOT)) {
            int offsetToLeftConstructorBrace = TokenStreamUtils.firstTokenMatching(tokens, indexOfNewKeyword, (ITokenMatcher)ETokenType.LPAREN) - indexOfNewKeyword;
            if (offsetToLeftConstructorBrace < 0) continue;
            List<IToken> constructorTokens = TokenStreamUtils.tokensBetweenWithNesting(tokens, indexOfNewKeyword + offsetToLeftConstructorBrace, ETokenType.LPAREN, ETokenType.RPAREN);
            int afterConstructorIndex = indexOfNewKeyword + offsetToLeftConstructorBrace + constructorTokens.size() + 2;
            if (!TokenStreamUtils.hasTokenTypeSequence(tokens, afterConstructorIndex, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN)) continue;
            int methodCallIndex = afterConstructorIndex + 1;
            List<IToken> callStartingWithMethodName = tokens.subList(methodCallIndex, tokens.size());
            List<IToken> tokensUntilMethodCall = tokens.subList(indexOfNewKeyword + 1, indexOfNewKeyword + offsetToLeftConstructorBrace);
            result.add(new PotentialMatch(callStartingWithMethodName, tokensUntilMethodCall));
        }
    }

    private static List<JavaMethodCallMatcher.MethodCall> collectCallsOfStaticallyImportedMethods(ShallowEntity statement, List<IToken> tokens, JavaImportSensitiveTypeResolver typeResolver, JavaMethodCallMatcher methodMatcher) {
        List<Integer> callIndices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, 0, ETokenType.IDENTIFIER, ETokenType.LPAREN);
        ArrayList<JavaMethodCallMatcher.MethodCall> staticCalls = new ArrayList<JavaMethodCallMatcher.MethodCall>();
        UnmodifiableSet<String> staticImports = typeResolver.getStaticImports();
        for (Integer tokenIndex : callIndices) {
            IToken methodCallToken;
            if (!JavaMethodCallFinder.isPotentialCallOfStaticallyImportedMethod(tokens, tokenIndex) || !methodMatcher.isTargetMethod((methodCallToken = tokens.get(tokenIndex)).getText())) continue;
            for (String staticImport : staticImports) {
                Optional<JavaMethodCallMatcher.MethodCall> optionalStaticCall = JavaMethodCallFinder.extractStaticallyImportedMethodCall(statement, methodMatcher, staticImport, methodCallToken);
                optionalStaticCall.ifPresent(staticCalls::add);
            }
        }
        return staticCalls;
    }

    private static Optional<JavaMethodCallMatcher.MethodCall> extractStaticallyImportedMethodCall(ShallowEntity statement, JavaMethodCallMatcher methodMatcher, String staticImport, IToken method) {
        for (String typeName : methodMatcher.getFullTypeNames()) {
            List<List<IToken>> parameters;
            if (!staticImport.equals(typeName + "." + method.getText()) || !JavaMethodCallFinder.hasMatchingParameters(parameters = CLikeCheckUtils.getMethodArguments(statement, method.getOffset()), methodMatcher)) continue;
            return Optional.of(new JavaMethodCallMatcher.MethodCall(statement, method, parameters, methodMatcher.getTag()));
        }
        return Optional.empty();
    }

    private static boolean isPotentialCallOfStaticallyImportedMethod(List<IToken> tokens, int index) {
        if (index == 0) {
            return true;
        }
        return tokens.get(index - 1).getType() != ETokenType.DOT;
    }

    private static List<PotentialMatch> collectCallsOnVariables(JavaMethodCallMatcher methodMatcher, List<IToken> tokens) {
        return new ArrayList<PotentialMatch>(TokenStreamUtils.firstTokenOfTypeSequences(tokens, 0, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN).stream().map(tokenIndex -> {
            List<IToken> tokensUntilMethodCall = tokens.subList(0, Math.max(0, tokenIndex));
            List<IToken> tokensFromMethodName = tokens.subList(tokenIndex + 1, tokens.size());
            if (methodMatcher.isTargetMethod(((IToken)tokensFromMethodName.getFirst()).getText())) {
                return new PotentialMatch(tokensFromMethodName, tokensUntilMethodCall);
            }
            return null;
        }).filter(Objects::nonNull).toList());
    }

    private static boolean methodInvocationHasRightType(JavaImportSensitiveTypeResolver typeResolver, JavaMethodCallMatcher methodMatcher, PotentialMatch candidate, ScopedTypeLookup lookup) {
        return Optional.empty().or(() -> JavaMethodCallFinder.hasCorrectName(candidate, methodMatcher)).or(() -> JavaMethodCallFinder.isOfType(candidate, typeResolver, methodMatcher, lookup)).or(() -> JavaMethodCallFinder.hasFullyQualifiedType(candidate, methodMatcher)).or(() -> JavaMethodCallFinder.isStaticallyImported(candidate, typeResolver.getStaticImports(), methodMatcher)).or(() -> JavaMethodCallFinder.isChained(candidate, methodMatcher, typeResolver)).orElseGet(() -> JavaMethodCallFinder.handlePotentialInnerClass(typeResolver, methodMatcher, candidate.tokensUntilMethodCall()));
    }

    private static Optional<Boolean> hasCorrectName(PotentialMatch candidate, JavaMethodCallMatcher methodMatcher) {
        return Optional.of(methodMatcher.isTargetMethod(candidate.methodName())).filter(b -> b == false);
    }

    private static Optional<Boolean> isOfType(PotentialMatch candidate, JavaImportSensitiveTypeResolver typeResolver, JavaMethodCallMatcher methodMatcher, ScopedTypeLookup lookup) {
        return typeResolver.isOfType(candidate.tokensUntilMethodCall(), methodMatcher.getFullTypeNames(), lookup, methodMatcher.getKnownMethodReturningSameType()).filter(b -> b);
    }

    private static Optional<Boolean> hasFullyQualifiedType(PotentialMatch candidate, JavaMethodCallMatcher methodMatcher) {
        if (candidate.tokensUntilMethodCall().isEmpty() || !candidate.tokensUntilMethodCall().stream().allMatch(token -> token.getType() == ETokenType.IDENTIFIER || token.getType() == ETokenType.DOT)) {
            return Optional.empty();
        }
        String maybeTypeName = TokenStreamTextUtils.concatTokenTexts(candidate.tokensUntilMethodCall());
        if (methodMatcher.getFullTypeNames().contains(maybeTypeName)) {
            return Optional.of(true);
        }
        return Optional.empty();
    }

    private static Optional<Boolean> isStaticallyImported(PotentialMatch candidate, Set<String> staticImports, JavaMethodCallMatcher methodMatcher) {
        if (!candidate.tokensUntilMethodCall().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(staticImports.stream().anyMatch(staticImport -> {
            String importedType = StringUtils.removeLastPart((String)staticImport, (char)'.');
            String importedMethod = StringUtils.getLastPart((String)staticImport, (String)".");
            return methodMatcher.getFullTypeNames().contains(importedType) && candidate.methodName().equals(importedMethod);
        }));
    }

    private static Optional<Boolean> isChained(PotentialMatch candidate, JavaMethodCallMatcher matcher, JavaImportSensitiveTypeResolver typeResolver) {
        if (matcher.isChainingAllowed() || candidate.tokensUntilMethodCall().size() != 1 && candidate.tokensUntilMethodCall().get(candidate.tokensUntilMethodCall().size() - 2).getType() == ETokenType.DOT) {
            return Optional.empty();
        }
        return Optional.of(candidate.tokensUntilMethodCall().getLast().getType() == ETokenType.IDENTIFIER && matcher.getFullTypeNames().contains(typeResolver.getFullyQualifiedTypeName(candidate.tokensUntilMethodCall().getLast().getText())));
    }

    private static boolean handlePotentialInnerClass(JavaImportSensitiveTypeResolver typeResolver, JavaMethodCallMatcher methodMatcher, List<IToken> tokensUntilMethodCall) {
        String innerClassAwareType = StringUtils.stripSuffix((String)tokensUntilMethodCall.stream().takeWhile(token -> !methodMatcher.isChainingAllowed() || token.getType() == ETokenType.IDENTIFIER || token.getType() == ETokenType.DOT).map(token -> {
            if (token.getType() == ETokenType.DOT) {
                return "$";
            }
            return token.getText();
        }).collect(Collectors.joining()), (String)"$");
        String[] typeParts = innerClassAwareType.split("\\$", 2);
        Set<String> fullTypeNames = methodMatcher.getFullTypeNames();
        if (fullTypeNames.contains(typeResolver.getFullyQualifiedTypeName(typeParts[0]))) {
            return true;
        }
        if (typeParts.length < 2) {
            return false;
        }
        String parentType = typeParts[0];
        return fullTypeNames.contains(typeResolver.getFullyQualifiedTypeName(parentType) + "$" + typeParts[1]);
    }

    private static boolean hasMatchingParameters(List<List<IToken>> parameters, JavaMethodCallMatcher methodMatcher) {
        return methodMatcher.getParameterPredicates().stream().allMatch(parameterCondition -> parameterCondition.test(parameters));
    }

    private record PotentialMatch(List<IToken> callStartingWithMethodName, List<IToken> tokensUntilMethodCall) {
        public String methodName() {
            return this.callStartingWithMethodName.getFirst().getText();
        }
    }
}

