/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.client.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.jetbrains.annotations.NotNull;
import ru.bozaro.gitlfs.client.internal.LfsRequest;
import ru.bozaro.gitlfs.client.internal.Request;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001d\u0010\u000f\u001a\u00028\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lru/bozaro/gitlfs/client/internal/JsonPost;", "Req", "Res", "Lru/bozaro/gitlfs/client/internal/Request;", "req", "type", "Ljava/lang/Class;", "(Ljava/lang/Object;Ljava/lang/Class;)V", "Ljava/lang/Object;", "createRequest", "Lru/bozaro/gitlfs/client/internal/LfsRequest;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "url", "", "processResponse", "response", "Lorg/apache/http/HttpResponse;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/apache/http/HttpResponse;)Ljava/lang/Object;", "gitlfs-client"})
public final class JsonPost<Req, Res>
implements Request<Res> {
    private final Req req;
    @NotNull
    private final Class<Res> type;

    public JsonPost(Req req, @NotNull Class<Res> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this.req = req;
        this.type = type;
    }

    @Override
    @NotNull
    public LfsRequest createRequest(@NotNull ObjectMapper mapper, @NotNull String url) throws JsonProcessingException {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpPost method = new HttpPost(url);
        method.addHeader("Accept", "application/vnd.git-lfs+json");
        ByteArrayEntity entity = new ByteArrayEntity(mapper.writeValueAsBytes(this.req));
        entity.setContentType("application/vnd.git-lfs+json");
        method.setEntity((HttpEntity)entity);
        return new LfsRequest((HttpUriRequest)method, (AbstractHttpEntity)entity);
    }

    @Override
    public Res processResponse(@NotNull ObjectMapper mapper, @NotNull HttpResponse response) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return (Res)mapper.readValue(response.getEntity().getContent(), this.type);
    }

    @Override
    @NotNull
    public int[] statusCodes() {
        return Request.DefaultImpls.statusCodes(this);
    }
}

