/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.client.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.bozaro.gitlfs.client.internal.LfsRequest;
import ru.bozaro.gitlfs.client.internal.Request;
import ru.bozaro.gitlfs.common.data.Meta;
import ru.bozaro.gitlfs.common.data.ObjectRes;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lru/bozaro/gitlfs/client/internal/MetaPost;", "Lru/bozaro/gitlfs/client/internal/Request;", "Lru/bozaro/gitlfs/common/data/ObjectRes;", "meta", "Lru/bozaro/gitlfs/common/data/Meta;", "(Lru/bozaro/gitlfs/common/data/Meta;)V", "createRequest", "Lru/bozaro/gitlfs/client/internal/LfsRequest;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "url", "", "processResponse", "response", "Lorg/apache/http/HttpResponse;", "statusCodes", "", "gitlfs-client"})
public final class MetaPost
implements Request<ObjectRes> {
    @NotNull
    private final Meta meta;

    public MetaPost(@NotNull Meta meta) {
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        this.meta = meta;
    }

    @Override
    @NotNull
    public LfsRequest createRequest(@NotNull ObjectMapper mapper, @NotNull String url) throws JsonProcessingException {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpPost req = new HttpPost(url);
        req.addHeader("Accept", "application/vnd.git-lfs+json");
        AbstractHttpEntity entity = (AbstractHttpEntity)new ByteArrayEntity(mapper.writeValueAsBytes((Object)this.meta));
        entity.setContentType("application/vnd.git-lfs+json");
        req.setEntity((HttpEntity)entity);
        return new LfsRequest((HttpUriRequest)req, entity);
    }

    @Override
    @Nullable
    public ObjectRes processResponse(@NotNull ObjectMapper mapper, @NotNull HttpResponse response) throws IOException {
        ObjectRes objectRes;
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        switch (response.getStatusLine().getStatusCode()) {
            case 200: {
                objectRes = null;
                break;
            }
            case 202: {
                objectRes = (ObjectRes)mapper.readValue(response.getEntity().getContent(), ObjectRes.class);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return objectRes;
    }

    @Override
    @NotNull
    public int[] statusCodes() {
        int[] nArray = new int[]{200, 202};
        return nArray;
    }
}

