/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.teamscale.core.log.worker.ShortWorkerLog;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.DetailedInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ILogErrorsComparisonDetailContribution;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@JsonTypeName(value="worker")
@IndexValueClass
class WorkerLogErrorsComparisonDetailContribution
implements ILogErrorsComparisonDetailContribution {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    private static final String LOG_ENTRIES_FOR_TRIGGER_PROPERTY = "logEntriesForTrigger";
    @JsonProperty(value="logEntriesForTrigger")
    private final @NonNull Map<String, Set<LogEntry>> logErrorEntriesForTriggerName;

    @JsonCreator
    WorkerLogErrorsComparisonDetailContribution(@JsonProperty(value="logEntriesForTrigger") @NonNull Map<String, Set<LogEntry>> logErrorEntriesForTriggerName) {
        CCSMAssert.isNotNull(logErrorEntriesForTriggerName, () -> String.format("Expected \"%s\" to be not null", LOG_ENTRIES_FOR_TRIGGER_PROPERTY));
        this.logErrorEntriesForTriggerName = logErrorEntriesForTriggerName;
    }

    public WorkerLogErrorsComparisonDetailContribution() {
        this.logErrorEntriesForTriggerName = new HashMap<String, Set<LogEntry>>();
    }

    public void add(ShortWorkerLog logEntry) {
        this.logErrorEntriesForTriggerName.computeIfAbsent(logEntry.getTriggerName(), ignored -> new HashSet()).add(new LogEntry(logEntry));
    }

    @Override
    public @NonNull Map<String, DetailedInstanceComparisonValue> getDetailedValues(String triggerName) {
        TreeMap<String, DetailedInstanceComparisonValue> result = new TreeMap<String, DetailedInstanceComparisonValue>();
        for (LogEntry logEntry : this.logErrorEntriesForTriggerName.getOrDefault(triggerName, Collections.emptySet())) {
            DetailedInstanceComparisonValue value;
            String key = String.valueOf(logEntry.getAnalyzedCommit());
            DetailedInstanceComparisonValue currentValueForSameKey = result.putIfAbsent(key, value = DetailedInstanceComparisonValue.ofWorkerLogError(new DetailedInstanceComparisonValue.WorkerLogId(triggerName, logEntry.getAnalyzedCommit(), logEntry.getEntryTimestamp())));
            if (currentValueForSameKey == null) continue;
            LOGGER.warn("Calculated duplicate comparison key \"{}\" for different worker log errors \"{}\" and \"{}\"", (Object)key, (Object)value, (Object)currentValueForSameKey);
        }
        return result;
    }

    @IndexValueClass
    private static class LogEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String COMMIT_PROPERTY = "commit";
        private static final String TIMESTAMP_PROPERTY = "timestamp";
        @JsonProperty(value="commit")
        private final CommitDescriptor analyzedCommit;
        @JsonProperty(value="timestamp")
        private final long entryTimestamp;

        public LogEntry(ShortWorkerLog logEntry) {
            this.analyzedCommit = logEntry.getAnalyzedCommit();
            this.entryTimestamp = logEntry.getTimestamp();
        }

        @JsonCreator
        LogEntry(@JsonProperty(value="commit") CommitDescriptor analyzedCommit, @JsonProperty(value="timestamp") long entryTimestamp) {
            this.analyzedCommit = analyzedCommit;
            this.entryTimestamp = entryTimestamp;
        }

        public CommitDescriptor getAnalyzedCommit() {
            return this.analyzedCommit;
        }

        public long getEntryTimestamp() {
            return this.entryTimestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogEntry logEntry = (LogEntry)o;
            return this.entryTimestamp == logEntry.entryTimestamp && Objects.equals(this.analyzedCommit, logEntry.analyzedCommit);
        }

        public int hashCode() {
            return Objects.hash(this.analyzedCommit, this.entryTimestamp);
        }
    }
}

