/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture;

import com.teamscale.index.architecture.ArchitectureComponentInfo;
import com.teamscale.index.architecture.ArchitectureConstraintInfo;
import com.teamscale.index.architecture.DependencyPolicyInfo;
import com.teamscale.index.architecture.TypeDependencyInfo;
import com.teamscale.index.architecture.commons.EAssessmentType;
import com.teamscale.index.architecture.commons.EFindingCreationType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.index.shared.ArchitectureCreationModificationInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class ArchitectureAssessmentInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final ArchitectureComponentInfo root;
    private final List<String> orphans;
    private final List<DependencyPolicyInfo> policies;
    public final boolean fileBased;
    public final boolean legacyCodeMapping;
    public final boolean structureOnly;
    public final EFindingCreationType findingCreation;
    private final List<ArchitectureConstraintInfo> constraints;
    private final Set<String> unsupportedLanguages;
    private final @Nullable ArchitectureCreationModificationInfo creationModificationInfo;

    protected ArchitectureAssessmentInfo(Builder builder) {
        this.root = Objects.requireNonNull(builder.root, "root");
        this.orphans = new ArrayList<String>(builder.orphans);
        this.policies = new ArrayList<DependencyPolicyInfo>(builder.policies);
        this.fileBased = builder.fileBased;
        this.legacyCodeMapping = builder.legacyCodeMapping;
        this.structureOnly = builder.structureOnly;
        this.findingCreation = Objects.requireNonNull(builder.findingCreation, "findingCreation");
        this.constraints = new ArrayList<ArchitectureConstraintInfo>(builder.constraints);
        this.unsupportedLanguages = new HashSet<String>(builder.unsupportedLanguages);
        this.creationModificationInfo = builder.creationModificationInfo;
    }

    public int orphanCount() {
        return this.orphans.size();
    }

    public List<String> getOrphans() {
        return this.orphans;
    }

    public int getViolationCount() {
        int violations = 0;
        violations += this.constraints.stream().map(ArchitectureConstraintInfo::getViolatingDependenciesCount).reduce(0, Integer::sum).intValue();
        for (DependencyPolicyInfo policy : this.policies) {
            if (policy.getAssessmentType() != EAssessmentType.INVALID) continue;
            HashSet<TypeDependencyInfo> toleratedDependencies = new HashSet<TypeDependencyInfo>((Collection<TypeDependencyInfo>)policy.getToleratedDependencies());
            violations += (int)policy.getDependencies().stream().filter(typeDependencyInfo -> !toleratedDependencies.contains(typeDependencyInfo)).count();
        }
        return violations;
    }

    public EFindingCreationType getFindingCreation() {
        return this.findingCreation;
    }

    public List<DependencyPolicyInfo> getPolicies() {
        return CollectionUtils.asUnmodifiable(this.policies);
    }

    public ArchitectureComponentInfo getRoot() {
        return this.root;
    }

    public UnmodifiableList<ArchitectureConstraintInfo> getConstraints() {
        return CollectionUtils.asUnmodifiable(this.constraints);
    }

    public UnmodifiableSet<String> getUnsupportedLanguages() {
        return CollectionUtils.asUnmodifiable(this.unsupportedLanguages);
    }

    public @Nullable ArchitectureCreationModificationInfo getCreationModificationInfo() {
        return this.creationModificationInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchitectureAssessmentInfo that = (ArchitectureAssessmentInfo)o;
        return this.fileBased == that.fileBased && Objects.equals(this.root, that.root) && Objects.equals(this.orphans, that.orphans) && Objects.equals(this.policies, that.policies) && this.findingCreation == that.findingCreation && Objects.equals(this.constraints, that.constraints) && Objects.equals(this.unsupportedLanguages, that.unsupportedLanguages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.root, this.orphans, this.policies, this.fileBased, this.findingCreation, this.constraints, this.unsupportedLanguages});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ArchitectureComponentInfo root;
        private List<String> orphans = new ArrayList<String>();
        private List<DependencyPolicyInfo> policies = new ArrayList<DependencyPolicyInfo>();
        private boolean fileBased;
        private boolean legacyCodeMapping;
        private boolean structureOnly;
        private EFindingCreationType findingCreation;
        private List<ArchitectureConstraintInfo> constraints = new ArrayList<ArchitectureConstraintInfo>();
        private Set<String> unsupportedLanguages = new HashSet<String>();
        private ArchitectureCreationModificationInfo creationModificationInfo;

        protected Builder() {
        }

        protected Builder(ArchitectureAssessmentInfo architectureAssessmentInfo) {
            this.root = architectureAssessmentInfo.root;
            this.orphans = new ArrayList<String>(architectureAssessmentInfo.orphans);
            this.policies = new ArrayList<DependencyPolicyInfo>(architectureAssessmentInfo.policies);
            this.fileBased = architectureAssessmentInfo.fileBased;
            this.legacyCodeMapping = architectureAssessmentInfo.legacyCodeMapping;
            this.structureOnly = architectureAssessmentInfo.structureOnly;
            this.findingCreation = architectureAssessmentInfo.findingCreation;
            this.constraints = new ArrayList<ArchitectureConstraintInfo>(architectureAssessmentInfo.constraints);
            this.unsupportedLanguages = new HashSet<String>(architectureAssessmentInfo.unsupportedLanguages);
            this.creationModificationInfo = architectureAssessmentInfo.creationModificationInfo;
        }

        public Builder withRoot(ArchitectureComponentInfo root) {
            this.root = root;
            return this;
        }

        public Builder withOrphans(Collection<String> orphans) {
            this.orphans.addAll(orphans);
            return this;
        }

        public Builder withPolicy(DependencyPolicyInfo policy) {
            this.policies.add(policy);
            return this;
        }

        public Builder withFileBased(boolean fileBased) {
            this.fileBased = fileBased;
            return this;
        }

        public Builder withLegacyCodeMapping(boolean legacyCodeMapping) {
            this.legacyCodeMapping = legacyCodeMapping;
            return this;
        }

        public Builder withStructureOnly(boolean structureOnly) {
            this.structureOnly = structureOnly;
            return this;
        }

        public Builder withFindingCreation(EFindingCreationType findingCreation) {
            this.findingCreation = findingCreation;
            return this;
        }

        public Builder withConstraint(ArchitectureConstraintInfo constraint) {
            this.constraints.add(constraint);
            return this;
        }

        public Builder withUnsupportedLanguages(Collection<String> unsupportedLanguages) {
            this.unsupportedLanguages.addAll(unsupportedLanguages);
            return this;
        }

        public Builder withCreationModificationInfo(ArchitectureCreationModificationInfo creationModificationInfo) {
            this.creationModificationInfo = creationModificationInfo;
            return this;
        }

        public ArchitectureAssessmentInfo build() {
            return new ArchitectureAssessmentInfo(this);
        }
    }
}

