/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.assessment;

import com.teamscale.index.architecture.scope.ComponentNode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@IndexValueClass
public final class ComponentOverlapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Map<String, Set<String>>> componentToTypeOverlaps = new HashMap<String, Map<String, Set<String>>>();
    private final Map<String, Set<String>> typeToComponentOverlaps = new HashMap<String, Set<String>>();

    public void addAll(ComponentOverlapping other) {
        other.componentToTypeOverlaps.forEach((component1, componentOverlaps) -> {
            Map typeOverlaps = this.componentToTypeOverlaps.computeIfAbsent((String)component1, k -> new HashMap());
            componentOverlaps.forEach((component2, types) -> typeOverlaps.computeIfAbsent(component2, ignored -> new HashSet()).addAll(types));
        });
        other.typeToComponentOverlaps.forEach((type, components) -> this.typeToComponentOverlaps.computeIfAbsent((String)type, ignored -> new HashSet()).addAll(components));
    }

    public void addOverlap(ComponentNode component1, ComponentNode component2, String type) {
        Objects.requireNonNull(component1, "component1");
        Objects.requireNonNull(component2, "component2");
        this.addOverlapForComponent(component1, component2, type);
        this.addOverlapForComponent(component2, component1, type);
    }

    private void addOverlapForComponent(ComponentNode component1, ComponentNode component2, String type) {
        this.componentToTypeOverlaps.computeIfAbsent(component1.getName(), s -> new HashMap()).computeIfAbsent(component2.getName(), ignored -> new HashSet()).add(type);
        this.typeToComponentOverlaps.computeIfAbsent(type, ignored -> new HashSet()).addAll(List.of(component1.getName(), component2.getName()));
    }

    public boolean isEmpty() {
        return this.componentToTypeOverlaps.isEmpty();
    }

    public @NonNull SetMap<String, String> getOverlaps(ComponentNode componentNode) {
        SetMap result = new SetMap();
        Map<String, Set<String>> value = this.componentToTypeOverlaps.get(componentNode.getName());
        if (value != null) {
            result.addAll(value);
        }
        return result;
    }

    public void removeType(String type) {
        Set<String> overlappingComponents = this.typeToComponentOverlaps.remove(type);
        if (overlappingComponents == null || overlappingComponents.isEmpty()) {
            return;
        }
        for (String firstComponent : overlappingComponents) {
            Map<String, Set<String>> firstComponentOverlaps = this.componentToTypeOverlaps.get(firstComponent);
            for (String secondComponent : overlappingComponents) {
                if (firstComponent.equals(secondComponent)) continue;
                Set secondComponentOverlaps = firstComponentOverlaps.getOrDefault(secondComponent, new HashSet());
                secondComponentOverlaps.remove(type);
                if (!secondComponentOverlaps.isEmpty()) continue;
                firstComponentOverlaps.remove(secondComponent);
            }
            if (!firstComponentOverlaps.isEmpty()) continue;
            this.componentToTypeOverlaps.remove(firstComponent);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ComponentOverlapping)) {
            return false;
        }
        ComponentOverlapping that = (ComponentOverlapping)o;
        return Objects.equals(this.componentToTypeOverlaps, that.componentToTypeOverlaps) && Objects.equals(this.typeToComponentOverlaps, that.typeToComponentOverlaps);
    }

    public int hashCode() {
        return Objects.hash(this.componentToTypeOverlaps, this.typeToComponentOverlaps);
    }

    public String toString() {
        return this.typeToComponentOverlaps.toString();
    }
}

