/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.scope;

import com.teamscale.index.architecture.assessment.shared.TypeDependency;
import com.teamscale.index.architecture.commons.EFindingCreationType;
import com.teamscale.index.architecture.commons.EPolicyType;
import com.teamscale.index.architecture.commons.EStereotype;
import com.teamscale.index.architecture.format.ArchitectureFormats;
import com.teamscale.index.architecture.format.EArchitectureIOAttribute;
import com.teamscale.index.architecture.format.EArchitectureIOElement;
import com.teamscale.index.architecture.format.ECodeMappingType;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.architecture.scope.Constraint;
import com.teamscale.index.architecture.scope.DependencyPolicy;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.commons.util.CommonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.util.XMLReaderBase;
import org.conqat.engine.index.shared.ArchitectureCreationModificationInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.IXMLElementProcessor;
import org.conqat.lib.commons.xml.IXMLResolver;
import org.conqat.lib.commons.xml.LowercaseResolver;

public class ArchitectureDefinitionParser
extends XMLReaderBase<EArchitectureIOElement, EArchitectureIOAttribute, ConQATException> {
    private static final String DIGITS = "(-?\\d+)";
    private static final Pattern NUMBER_PAIR_PATTERN = Pattern.compile("(-?\\d+), ?(-?\\d+)");
    private static final String ARCHITECTURE_ASSESSMENT_DEFAULT_IS_FILE_BASED = "architecture.default.file-based";
    private static final String ARCHITECTURE_ASSESSMENT_DEFAULT_CREATED_BY_OR_LAST_MODIFIED_BY = null;
    private static final long ARCHITECTURE_ASSESSMENT_DEFAULT_CREATION_OR_MODIFICATION_DATE = -1L;
    private final String location;
    private final String architectureName;
    private final Map<String, ComponentNode> componentByName = new HashMap<String, ComponentNode>();

    public ArchitectureDefinitionParser(String uniformPath, String content) {
        super(content, (IXMLResolver)new LowercaseResolver(EArchitectureIOAttribute.class));
        this.setSchema(ArchitectureFormats.getArchitectureDefinitionSchema());
        this.location = uniformPath;
        this.architectureName = uniformPath;
    }

    public ArchitectureDefinition parse() throws ConQATException {
        this.parseAndWrapExceptions();
        ArchitectureCreationModificationInfo creationModificationInfo = this.determineCreationModificationInfo();
        boolean isStructureOnly = this.getBooleanAttributeOrDefault(EArchitectureIOAttribute.STRUCTURE_ONLY, false);
        ArchitectureDefinition result = new ArchitectureDefinition(this.architectureName, this.getBooleanAttributeOrDefault(EArchitectureIOAttribute.FILE_BASED, Boolean.getBoolean(ARCHITECTURE_ASSESSMENT_DEFAULT_IS_FILE_BASED)), this.determineFindingCreation(isStructureOnly), this.getStringAttribute(EArchitectureIOAttribute.SCOPE_INCLUDE), this.getStringAttribute(EArchitectureIOAttribute.SCOPE_EXCLUDE), creationModificationInfo, this.getBooleanAttributeOrDefault(EArchitectureIOAttribute.LEGACY_CODE_MAPPING, true), isStructureOnly);
        this.processChildElements(new ComponentProcessor(this, result));
        if (!result.isStructureOnly()) {
            this.processChildElements(new PolicyProcessor(this, EArchitectureIOElement.ALLOW, EPolicyType.ALLOW_EXPLICIT));
            this.processChildElements(new PolicyProcessor(this, EArchitectureIOElement.DENY, EPolicyType.DENY_EXPLICIT));
            this.processChildElements(new PolicyProcessor(this, EArchitectureIOElement.TOLERATE, EPolicyType.TOLERATE_EXPLICIT));
            this.processChildElements(new ConstraintProcessor(this, result));
        }
        return result;
    }

    private ArchitectureCreationModificationInfo determineCreationModificationInfo() {
        String creator = this.getStringAttributeOrDefault(EArchitectureIOAttribute.CREATED_BY, ARCHITECTURE_ASSESSMENT_DEFAULT_CREATED_BY_OR_LAST_MODIFIED_BY);
        long creationDate = this.determineCreationOrModificationDate(EArchitectureIOAttribute.CREATION_DATE);
        String lastModifiedBy = this.getStringAttributeOrDefault(EArchitectureIOAttribute.LAST_MODIFIED_BY, ARCHITECTURE_ASSESSMENT_DEFAULT_CREATED_BY_OR_LAST_MODIFIED_BY);
        long lastModificationDate = this.determineCreationOrModificationDate(EArchitectureIOAttribute.MODIFICATION_DATE);
        return new ArchitectureCreationModificationInfo(creator, Long.valueOf(creationDate), lastModifiedBy, Long.valueOf(lastModificationDate));
    }

    private EFindingCreationType determineFindingCreation(boolean isStructureOnly) {
        if (isStructureOnly) {
            return EFindingCreationType.NONE;
        }
        return (EFindingCreationType)this.getEnumAttributeIgnoreCase(EArchitectureIOAttribute.FINDING_CREATION, EFindingCreationType.class, EFindingCreationType.VIOLATIONS_ORPHANS);
    }

    private long determineCreationOrModificationDate(EArchitectureIOAttribute attribute) {
        if (!this.hasAttribute(attribute)) {
            return -1L;
        }
        return this.getLongAttribute(attribute);
    }

    protected String getLocation() {
        return this.location;
    }

    private DependencyPolicy insertPolicy(String sourceName, String targetName, EPolicyType policyType, List<Point> points) throws ConQATException {
        return ArchitectureDefinitionParser.createPolicy(this.getComponent(sourceName), this.getComponent(targetName), policyType, points);
    }

    private ComponentNode getComponent(String name) throws ConQATException {
        ComponentNode component = this.componentByName.get(name);
        if (component == null) {
            throw new ConQATException("Component " + name + " not found!");
        }
        return component;
    }

    private static DependencyPolicy createPolicy(ComponentNode source, ComponentNode target, EPolicyType policyType, List<Point> points) throws ConQATException {
        DependencyPolicy policy = new DependencyPolicy(source, target, policyType, points);
        policy.registerWithComponents();
        return policy;
    }

    private static Pair<Integer, Integer> parseNumberPair(String pairString) throws ConQATException {
        Matcher matcher = NUMBER_PAIR_PATTERN.matcher(pairString);
        if (!matcher.matches()) {
            throw new ConQATException("Invalid position/dimension string: " + pairString);
        }
        return new Pair((Object)Integer.parseInt(matcher.group(1)), (Object)Integer.parseInt(matcher.group(2)));
    }

    private class ComponentProcessor
    implements IXMLElementProcessor<EArchitectureIOElement, ConQATException> {
        private final ComponentNode parent;
        final /* synthetic */ ArchitectureDefinitionParser this$0;

        private ComponentProcessor(ArchitectureDefinitionParser architectureDefinitionParser, ComponentNode parent) {
            ArchitectureDefinitionParser architectureDefinitionParser2 = architectureDefinitionParser;
            Objects.requireNonNull(architectureDefinitionParser2);
            this.this$0 = architectureDefinitionParser2;
            this.parent = parent;
        }

        public EArchitectureIOElement getTargetElement() {
            return EArchitectureIOElement.COMPONENT;
        }

        public void process() throws ConQATException {
            String name = this.this$0.getStringAttribute(EArchitectureIOAttribute.NAME);
            if (this.this$0.componentByName.containsKey(name)) {
                throw new ConQATException("Duplicate unique name: " + name);
            }
            String stereotypeString = this.this$0.getStringAttribute(EArchitectureIOAttribute.STEREOTYPE);
            EStereotype stereoType = EStereotype.NONE;
            if (!StringUtils.isEmpty((String)stereotypeString)) {
                stereoType = (EStereotype)EnumUtils.valueOfIgnoreCase(EStereotype.class, (String)stereotypeString);
            }
            Pair<Integer, Integer> positionPair = ArchitectureDefinitionParser.parseNumberPair(this.this$0.getStringAttribute(EArchitectureIOAttribute.POS));
            Pair<Integer, Integer> dimensionPair = ArchitectureDefinitionParser.parseNumberPair(this.this$0.getStringAttribute(EArchitectureIOAttribute.DIM));
            Point position = new Point((Integer)positionPair.getFirst(), (Integer)positionPair.getSecond());
            Dimension dimension = new Dimension((Integer)dimensionPair.getFirst(), (Integer)dimensionPair.getSecond());
            ComponentNode node = new ComponentNode(name, position, dimension, stereoType);
            this.this$0.componentByName.put(name, node);
            this.this$0.processChildElements(new ComponentProcessor(this.this$0, node));
            this.this$0.processChildElements(new CodeMappingProcessor(this.this$0, node));
            this.this$0.processChildElements(new CommentProcessor(this.this$0, node));
            this.this$0.processChildElements(new SpecItemMappingProcessor(this.this$0, node));
            this.parent.addSubComponent(node);
        }
    }

    private final class PolicyProcessor
    implements IXMLElementProcessor<EArchitectureIOElement, ConQATException> {
        private final EArchitectureIOElement targetElement;
        private final EPolicyType policyType;
        final /* synthetic */ ArchitectureDefinitionParser this$0;

        private PolicyProcessor(ArchitectureDefinitionParser architectureDefinitionParser, EArchitectureIOElement targetElement, EPolicyType policyType) {
            ArchitectureDefinitionParser architectureDefinitionParser2 = architectureDefinitionParser;
            Objects.requireNonNull(architectureDefinitionParser2);
            this.this$0 = architectureDefinitionParser2;
            this.targetElement = targetElement;
            this.policyType = policyType;
        }

        public EArchitectureIOElement getTargetElement() {
            return this.targetElement;
        }

        public void process() throws ConQATException {
            DependencyPolicy policy = this.this$0.insertPolicy(this.this$0.getStringAttribute(EArchitectureIOAttribute.SOURCE), this.this$0.getStringAttribute(EArchitectureIOAttribute.TARGET), this.policyType, this.parsePoints());
            if (this.policyType == EPolicyType.TOLERATE_EXPLICIT) {
                this.this$0.processChildElements(new ToleratePolicyProcessor(this.this$0, policy));
            }
        }

        private List<Point> parsePoints() throws ConQATException {
            ArrayList<Point> points = new ArrayList<Point>();
            String pointsString = this.this$0.getStringAttribute(EArchitectureIOAttribute.POINTS);
            if (StringUtils.isEmpty((String)pointsString)) {
                return points;
            }
            String[] parts = pointsString.split(",");
            int i = 0;
            while (i + 1 < parts.length) {
                try {
                    points.add(new Point(Integer.parseInt(parts[i]), Integer.parseInt(parts[i + 1])));
                }
                catch (NumberFormatException e) {
                    throw new ConQATException("Had invalid point description: " + pointsString, (Throwable)e);
                }
                i += 2;
            }
            return points;
        }
    }

    private final class ConstraintProcessor
    implements IXMLElementProcessor<EArchitectureIOElement, ConQATException> {
        private final ArchitectureDefinition architecture;
        final /* synthetic */ ArchitectureDefinitionParser this$0;

        private ConstraintProcessor(ArchitectureDefinitionParser architectureDefinitionParser, ArchitectureDefinition architecture) {
            ArchitectureDefinitionParser architectureDefinitionParser2 = architectureDefinitionParser;
            Objects.requireNonNull(architectureDefinitionParser2);
            this.this$0 = architectureDefinitionParser2;
            this.architecture = architecture;
        }

        public EArchitectureIOElement getTargetElement() {
            return EArchitectureIOElement.CONSTRAINT;
        }

        public void process() throws ConQATException {
            String source = this.this$0.getStringAttribute(EArchitectureIOAttribute.SOURCE);
            String target = this.this$0.getStringAttribute(EArchitectureIOAttribute.TARGET);
            CommonUtils.compilePattern((String)source);
            CommonUtils.compilePattern((String)target);
            this.architecture.addConstraint(new Constraint(source, target));
        }
    }

    private final class ToleratePolicyProcessor
    implements IXMLElementProcessor<EArchitectureIOElement, ConQATException> {
        private final DependencyPolicy policy;
        final /* synthetic */ ArchitectureDefinitionParser this$0;

        private ToleratePolicyProcessor(ArchitectureDefinitionParser architectureDefinitionParser, DependencyPolicy policy) {
            ArchitectureDefinitionParser architectureDefinitionParser2 = architectureDefinitionParser;
            Objects.requireNonNull(architectureDefinitionParser2);
            this.this$0 = architectureDefinitionParser2;
            this.policy = policy;
        }

        public EArchitectureIOElement getTargetElement() {
            return EArchitectureIOElement.DEPENDENCY;
        }

        public void process() {
            this.policy.addToleratedTypeDependency(new TypeDependency(this.this$0.getStringAttribute(EArchitectureIOAttribute.SOURCE), this.this$0.getStringAttribute(EArchitectureIOAttribute.TARGET)));
        }
    }

    private final class SpecItemMappingProcessor
    implements IXMLElementProcessor<EArchitectureIOElement, ConQATException> {
        private final ComponentNode node;
        final /* synthetic */ ArchitectureDefinitionParser this$0;

        private SpecItemMappingProcessor(ArchitectureDefinitionParser architectureDefinitionParser, ComponentNode node) {
            ArchitectureDefinitionParser architectureDefinitionParser2 = architectureDefinitionParser;
            Objects.requireNonNull(architectureDefinitionParser2);
            this.this$0 = architectureDefinitionParser2;
            this.node = node;
        }

        public EArchitectureIOElement getTargetElement() {
            return EArchitectureIOElement.SPEC_ITEM_MAPPING;
        }

        public void process() {
            String specItemMapping = this.this$0.getText();
            CCSMAssert.isNotNull((Object)specItemMapping);
            this.node.setSpecItemMapping(specItemMapping);
        }
    }

    private final class CommentProcessor
    implements IXMLElementProcessor<EArchitectureIOElement, ConQATException> {
        private final ComponentNode node;
        final /* synthetic */ ArchitectureDefinitionParser this$0;

        private CommentProcessor(ArchitectureDefinitionParser architectureDefinitionParser, ComponentNode node) {
            ArchitectureDefinitionParser architectureDefinitionParser2 = architectureDefinitionParser;
            Objects.requireNonNull(architectureDefinitionParser2);
            this.this$0 = architectureDefinitionParser2;
            this.node = node;
        }

        public EArchitectureIOElement getTargetElement() {
            return EArchitectureIOElement.COMMENT;
        }

        public void process() {
            String description = this.this$0.getText();
            CCSMAssert.isNotNull((Object)description);
            this.node.setDescription(description);
        }
    }

    private final class CodeMappingProcessor
    implements IXMLElementProcessor<EArchitectureIOElement, ConQATException> {
        private final ComponentNode node;
        final /* synthetic */ ArchitectureDefinitionParser this$0;

        private CodeMappingProcessor(ArchitectureDefinitionParser architectureDefinitionParser, ComponentNode node) {
            ArchitectureDefinitionParser architectureDefinitionParser2 = architectureDefinitionParser;
            Objects.requireNonNull(architectureDefinitionParser2);
            this.this$0 = architectureDefinitionParser2;
            this.node = node;
        }

        public EArchitectureIOElement getTargetElement() {
            return EArchitectureIOElement.CODE_MAPPING;
        }

        public void process() {
            ECodeMappingType codeMappingType = ECodeMappingType.valueOf(this.this$0.getStringAttribute(EArchitectureIOAttribute.TYPE).toUpperCase());
            switch (codeMappingType) {
                case INCLUDE: {
                    this.node.addIncludePattern(this.this$0.getStringAttribute(EArchitectureIOAttribute.REGEX));
                    break;
                }
                case EXCLUDE: {
                    this.node.addExcludePattern(this.this$0.getStringAttribute(EArchitectureIOAttribute.REGEX));
                    break;
                }
                case EXCLUDE_COMPONENT: {
                    this.node.addExcludedComponent(this.this$0.getStringAttribute(EArchitectureIOAttribute.REGEX));
                    break;
                }
                default: {
                    CCSMAssert.fail((String)("Unknown code mapping type: " + String.valueOf((Object)codeMappingType)));
                }
            }
        }
    }
}

