/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.audit.analysis.copyrightlicense;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.audit.analysis.copyrightlicense.CopyrightLicenseIndex;
import com.teamscale.index.audit.analysis.copyrightlicense.CopyrightLicenseInfo;
import com.teamscale.index.audit.analysis.copyrightlicense.ELicenseType;
import com.teamscale.index.comment_analysis.CommentAnalysisBase;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

public class CopyrightLicenseIndexUpdater
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CopyrightLicenseIndex index;
    @DeltaSource.Named(index=TokenElementIndex.class, name="content")
    private KeyDelta contentDelta;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="content")
    private TokenElementIndex contentIndex;

    public void execute() throws StorageException {
        for (String key : this.contentDelta.getAddedOrChangedKeysAsStrings()) {
            TokenElementInfo tokenElementInfo = this.contentIndex.getTokenElement(key);
            CCSMAssert.isNotNull((Object)((Object)tokenElementInfo), (String)"Added or Changed Element does not exist in content index.");
            this.processAddedOrChangedFile(tokenElementInfo);
        }
        this.index.removeCopyrightLicenseInfo(this.contentDelta.getDeletedKeysAsStrings());
    }

    private void processAddedOrChangedFile(TokenElementInfo tokenElementInfo) throws StorageException {
        CopyrightLicenseInfo licenseInformation = CopyrightLicenseIndexUpdater.getMostCriticalLicenseInformation(tokenElementInfo);
        if (licenseInformation != null) {
            this.index.setCopyrightLicenseInfo(tokenElementInfo.getUniformPath(), licenseInformation);
        } else {
            this.index.removeCopyrightLicenseInfo(tokenElementInfo.getUniformPath());
        }
    }

    private static CopyrightLicenseInfo getMostCriticalLicenseInformation(TokenElementInfo tokenElementInfo) {
        List<IToken> mergedTokens = CommentAnalysisBase.unifyMultipleSingleLineComments(tokenElementInfo.getTokens());
        List licenseInfos = CollectionUtils.filterAndMap(mergedTokens, CopyrightLicenseIndexUpdater::isCopyrightComment, token -> CopyrightLicenseIndexUpdater.createLicenseInfoElement(tokenElementInfo, token));
        if (licenseInfos.isEmpty()) {
            return null;
        }
        return (CopyrightLicenseInfo)Collections.min(licenseInfos);
    }

    private static CopyrightLicenseInfo createLicenseInfoElement(TokenElementInfo element, IToken token) {
        String comment = token.getText();
        return new CopyrightLicenseInfo(element.getUniformPath(), comment, ELicenseType.getLicenseType(comment), token.getLineNumber() + 1);
    }

    private static boolean isCopyrightComment(IToken token) {
        if (token.getType().getTokenClass() != ETokenType.ETokenClass.COMMENT) {
            return false;
        }
        String commentInLowerCase = token.getText().toLowerCase();
        return commentInLowerCase.contains("copyright") || commentInLowerCase.contains("license");
    }
}

